<?php
require_once '../config.php';
header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit;
}

$customer_id = $_SESSION['user_id'];

try {
    // Get inquiries for this customer
    $stmt = $conn->prepare("
        SELECT i.id, p.title, i.message, i.status, i.created_at, i.updated_at
        FROM inquiries i
        LEFT JOIN properties p ON i.property_id = p.id
        WHERE i.customer_id = ?
        ORDER BY i.created_at DESC
        LIMIT 10
    ");
    $stmt->bind_param('i', $customer_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $inquiries = [];
    while ($row = $result->fetch_assoc()) {
        $inquiries[] = $row;
    }
    $stmt->close();

    echo json_encode(['success' => true, 'inquiries' => $inquiries]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
