<?php
require_once '../config.php';
header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit;
}

$customer_id = $_SESSION['user_id'];

try {
    // Ensure columns exist
    $conn->query("ALTER TABLE users ADD COLUMN IF NOT EXISTS city VARCHAR(100) AFTER address");
    $conn->query("ALTER TABLE users ADD COLUMN IF NOT EXISTS bio TEXT AFTER city");
    
    $stmt = $conn->prepare("SELECT user_name, email, phone, address, city, bio FROM users WHERE id = ?");
    $stmt->bind_param('i', $customer_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $profile = $result->fetch_assoc();
    $stmt->close();

    echo json_encode(['success' => true, 'profile' => $profile]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
