<?php
require_once '../config.php';

header('Content-Type: application/json');

$property_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($property_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid property ID']);
    exit;
}

$query = "SELECT id, title, description, price, type, status, address, city, state, bedrooms, bathrooms, garage, area, image_url, broker_id FROM properties WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param('i', $property_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode(['success' => true, 'property' => $row]);
} else {
    echo json_encode(['success' => false, 'message' => 'Property not found']);
}
?>
