<?php
require_once '../../config.php';
header('Content-Type: application/json');

// Check if user is logged in and is staff
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'staff') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

// Get JSON input
$data = json_decode(file_get_contents('php://input'), true);

if (!$data || !isset($data['inquiry_id']) || !isset($data['action'])) {
    echo json_encode(['success' => false, 'message' => 'Missing required fields']);
    exit;
}

$inquiry_id = intval($data['inquiry_id']);
$action = $data['action']; // 'approve' or 'decline'

if (!in_array($action, ['approve', 'decline'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid action']);
    exit;
}

try {
    // Update inquiry with approval status
    $status = $action === 'approve' ? 'approved' : 'declined';
    
    $stmt = $conn->prepare("
        UPDATE inquiries 
        SET status = ?, updated_at = NOW()
        WHERE id = ?
    ");
    
    $stmt->bind_param('si', $status, $inquiry_id);
    
    if ($stmt->execute()) {
        $stmt->close();
        echo json_encode(['success' => true, 'message' => 'Inquiry ' . $action . 'ed successfully']);
    } else {
        throw new Exception('Failed to update inquiry');
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
