<?php
// Test API - Check database connection
header('Content-Type: application/json');

// Try including config
if (!file_exists('../config.php')) {
    echo json_encode(['success' => false, 'message' => 'config.php not found']);
    exit;
}

require_once '../config.php';

// Check connection
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

// Check if appointments table exists
$result = $conn->query("SHOW TABLES LIKE 'appointments'");
if ($result->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => 'Appointments table does not exist. Run setup-appointments.php first']);
    exit;
}

echo json_encode([
    'success' => true,
    'message' => 'API is working correctly',
    'database' => 'Connected',
    'table' => 'appointments table exists'
]);

$conn->close();
?>
