<?php
require_once '../config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'customer') {
    header('Location: ../login.php');
    exit;
}

$customer_id = $_SESSION['user_id'];
$checks = ['status' => 'success', 'results' => []];

// Check database tables
$tables_to_check = [
    'favorites' => 'Favorites table',
    'appointments' => 'Appointments table',
    'inquiries' => 'Inquiries table',
    'users' => 'Users table',
    'properties' => 'Properties table'
];

foreach ($tables_to_check as $table => $label) {
    $result = $conn->query("SELECT 1 FROM $table LIMIT 1");
    if ($result !== false) {
        $checks['results'][] = ['name' => $label, 'status' => 'OK', 'error' => null];
    } else {
        $checks['results'][] = ['name' => $label, 'status' => 'MISSING', 'error' => $conn->error];
        $checks['status'] = 'warning';
    }
}

// Check table columns
$required_columns = [
    'appointments' => ['customer_id', 'appointment_date', 'appointment_time', 'status'],
    'inquiries' => ['customer_id', 'property_id', 'status', 'message'],
    'favorites' => ['customer_id', 'property_id'],
    'users' => ['phone', 'address']
];

foreach ($required_columns as $table => $columns) {
    foreach ($columns as $col) {
        $result = $conn->query("SHOW COLUMNS FROM $table LIKE '$col'");
        if ($result && $result->num_rows > 0) {
            $checks['results'][] = ['name' => "$table.$col", 'status' => 'OK', 'error' => null];
        } else {
            $checks['results'][] = ['name' => "$table.$col", 'status' => 'MISSING', 'error' => "Column not found"];
            $checks['status'] = 'warning';
        }
    }
}

// Check API files
$api_files = [
    'favorites-toggle.php',
    'get-favorites.php',
    'appointment-add.php',
    'get-appointments.php',
    'inquiry-add.php',
    'get-inquiries.php',
    'profile-update.php',
    'get-profile.php',
    'schedule-visit.php'
];

foreach ($api_files as $file) {
    $path = __DIR__ . '/../api/' . $file;
    if (file_exists($path)) {
        $checks['results'][] = ['name' => "API: $file", 'status' => 'EXISTS', 'error' => null];
    } else {
        $checks['results'][] = ['name' => "API: $file", 'status' => 'MISSING', 'error' => "File not found"];
        $checks['status'] = 'warning';
    }
}

// Test API connectivity
$api_tests = [
    'get-favorites.php' => 'GET',
    'get-appointments.php' => 'GET',
    'get-inquiries.php' => 'GET',
    'get-profile.php' => 'GET'
];

foreach ($api_tests as $file => $method) {
    $url = 'http://' . $_SERVER['HTTP_HOST'] . '/nexthm/api/' . $file;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt_array($ch, [
        CURLOPT_COOKIE => session_name() . '=' . session_id(),
        CURLOPT_FOLLOWLOCATION => true
    ]);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code === 200) {
        $checks['results'][] = ['name' => "API Test: $file", 'status' => 'OK', 'error' => null];
    } else {
        $checks['results'][] = ['name' => "API Test: $file", 'status' => "HTTP $http_code", 'error' => null];
    }
}

header('Content-Type: application/json');
echo json_encode($checks);
?>
