<?php
// Diagnostic page for appointment system
header('Content-Type: text/html; charset=utf-8');

// Check current directory
$currentDir = dirname(__FILE__);
$configPath = $currentDir . '/config.php';
$apiPath = $currentDir . '/api/appointment-save.php';

echo "<style>
body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
.check-box { background: white; padding: 20px; margin: 10px 0; border-radius: 5px; border-left: 4px solid #667eea; }
.pass { border-left-color: #28a745; color: #155724; background: #d4edda; }
.fail { border-left-color: #dc3545; color: #721c24; background: #f8d7da; }
.warning { border-left-color: #ffc107; color: #856404; background: #fff3cd; }
h1 { color: #333; }
code { background: #f0f0f0; padding: 2px 6px; border-radius: 3px; }
</style>";

echo "<h1>🔍 Appointment System Diagnostic</h1>";

// Check 1: Config file exists
echo "<div class='check-box " . (file_exists($configPath) ? 'pass' : 'fail') . "'>";
echo file_exists($configPath) ? "✓ config.php exists" : "✗ config.php NOT FOUND";
echo "</div>";

if (file_exists($configPath)) {
    // Check 2: Database connection
    echo "<div class='check-box'>";
    require_once $configPath;
    
    if (isset($conn)) {
        if ($conn->connect_error) {
            echo "<div class='fail'>✗ Database Connection Failed: " . $conn->connect_error . "</div>";
        } else {
            echo "<div class='pass'>✓ Database Connected Successfully</div>";
            
            // Check 3: Appointments table
            $result = $conn->query("SHOW TABLES LIKE 'appointments'");
            if ($result && $result->num_rows > 0) {
                echo "<div class='pass' style='margin-top: 10px;'>✓ Appointments table exists</div>";
                
                // Show table structure
                $columns = $conn->query("SHOW COLUMNS FROM appointments");
                echo "<details style='margin-top: 10px;'><summary>Table Structure</summary><pre>";
                while ($col = $columns->fetch_assoc()) {
                    echo $col['Field'] . " (" . $col['Type'] . ")\n";
                }
                echo "</pre></details>";
            } else {
                echo "<div class='warning' style='margin-top: 10px;'>⚠ Appointments table NOT FOUND. <a href='setup-appointments.php'>Click here to create it</a></div>";
            }
        }
    } else {
        echo "<div class='fail'>✗ \$conn variable not defined in config.php</div>";
    }
    echo "</div>";
    
    // Check 4: API file exists
    echo "<div class='check-box " . (file_exists($apiPath) ? 'pass' : 'fail') . "'>";
    echo file_exists($apiPath) ? "✓ API file (appointment-save.php) exists" : "✗ API file NOT FOUND";
    echo "</div>";
    
    // Check 5: Directories are writable
    echo "<div class='check-box'>";
    $apiDir = $currentDir . '/api';
    if (is_writable($apiDir)) {
        echo "<div class='pass'>✓ /api directory is writable</div>";
    } else {
        echo "<div class='warning'>⚠ /api directory may not be writable (needed for logs)</div>";
    }
    echo "</div>";
} else {
    echo "<div class='check-box fail'>";
    echo "✗ Cannot proceed without config.php<br>";
    echo "Expected at: <code>" . $configPath . "</code>";
    echo "</div>";
}

echo "<div class='check-box' style='background: #e7f3ff; border-left-color: #2196F3;'>";
echo "<h3>📋 Troubleshooting Steps:</h3>";
echo "<ol>";
echo "<li>Verify <code>config.php</code> is in the Zemaraim root directory</li>";
echo "<li>Check that the database connection details in config.php are correct</li>";
echo "<li>If the appointments table doesn't exist, <a href='setup-appointments.php'>run this setup page</a></li>";
echo "<li>Open browser DevTools (F12) → Console tab to see error messages</li>";
echo "<li>Check error logs at: <code>appointment_errors.log</code></li>";
echo "<li>Make a test request: <a href='api/test-appointment.php'>Test API Connection</a></li>";
echo "</ol>";
echo "</div>";

echo "<div class='check-box' style='background: #f9f9f9; border-left-color: #999;'>";
echo "<h3>🧪 Test API Connection</h3>";
echo "<p>Visit this URL to test if the API is working:</p>";
echo "<code>" . htmlspecialchars($_SERVER['HTTP_HOST']) . "/Zemaraim/api/test-appointment.php</code>";
echo "</div>";
?>
