<?php
require_once 'config.php';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Book an Appointment - Zemaraim Real Estate</title>
  <meta name="author" content="vecuro">
  <meta name="description" content="Book your property consultation appointment with our expert real estate agents">
  <meta name="keywords" content="appointment, real estate, consultation, property">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  
  <style>
    /* Appointment Form Responsive Styles */
    .appointment-section {
      padding: 50px 0;
    }

    .appointment-form-wrapper {
      background: white;
      padding: 40px;
      border-radius: 10px;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    }

    .form-header {
      margin-bottom: 35px;
      text-align: center;
    }

    .form-header h2 {
      font-size: 28px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 10px;
    }

    .form-header p {
      font-size: 15px;
      color: #666;
    }

    .form-row {
      display: flex;
      gap: 20px;
      margin-bottom: 20px;
      flex-wrap: wrap;
    }

    .form-group {
      display: flex;
      flex-direction: column;
    }

    .form-label {
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 8px;
      font-size: 14px;
    }

    .appointment-input {
      padding: 12px 15px;
      border: 1px solid #ddd;
      border-radius: 5px;
      font-size: 14px;
      transition: all 0.3s ease;
    }

    .appointment-input:focus {
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
      outline: none;
    }

    .property-type-options {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
      gap: 15px;
      margin-top: 10px;
    }

    .form-check {
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .form-check-input {
      width: 18px;
      height: 18px;
      cursor: pointer;
      accent-color: #667eea;
    }

    .form-check-label {
      cursor: pointer;
      font-size: 14px;
      margin-bottom: 0;
      color: #1a1a1a;
    }

    .appointment-submit-btn {
      width: 100%;
      padding: 14px 25px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      border-radius: 5px;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }

    .appointment-submit-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
    }

    .appointment-submit-btn:disabled {
      opacity: 0.7;
      cursor: not-allowed;
    }

    .form-message {
      padding: 15px;
      border-radius: 5px;
      margin-top: 20px;
      display: flex;
      align-items: center;
      gap: 10px;
      font-size: 14px;
    }

    .success-message {
      background-color: #d4edda;
      border: 1px solid #c3e6cb;
      color: #155724;
    }

    .error-message {
      background-color: #f8d7da;
      border: 1px solid #f5c6cb;
      color: #721c24;
    }

    /* Appointment Info Cards */
    .appointment-info-card {
      background: white;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
      margin-bottom: 25px;
      transition: all 0.3s ease;
    }

    .appointment-info-card:hover {
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
      transform: translateY(-2px);
    }

    .card-icon {
      font-size: 28px;
      color: #667eea;
      margin-bottom: 15px;
    }

    .appointment-info-card h3 {
      font-size: 18px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 15px;
    }

    .info-list {
      list-style: none;
      padding: 0;
      margin: 0;
    }

    .info-list li {
      padding: 8px 0;
      color: #666;
      font-size: 14px;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .info-list i {
      color: #667eea;
      font-size: 12px;
    }

    .contact-details {
      display: flex;
      flex-direction: column;
      gap: 15px;
    }

    .detail-item {
      display: flex;
      gap: 12px;
      align-items: flex-start;
    }

    .detail-item i {
      color: #667eea;
      margin-top: 2px;
      font-size: 16px;
      min-width: 20px;
    }

    .detail-label {
      font-size: 12px;
      color: #999;
      font-weight: 600;
      margin: 0;
      text-transform: uppercase;
    }

    .detail-item a {
      color: #667eea;
      text-decoration: none;
      font-weight: 500;
      font-size: 14px;
      word-break: break-word;
    }

    .detail-item a:hover {
      text-decoration: underline;
    }

    .detail-item p {
      margin: 0;
      font-size: 14px;
      color: #666;
    }

    .hours-list {
      display: flex;
      flex-direction: column;
      gap: 12px;
    }

    .hour-item {
      display: flex;
      justify-content: space-between;
      font-size: 14px;
      color: #666;
      padding-bottom: 10px;
      border-bottom: 1px solid #f0f0f0;
    }

    .hour-item:last-child {
      border-bottom: none;
    }

    .hour-item .time {
      font-weight: 600;
      color: #667eea;
    }

    .card-link {
      display: inline-flex;
      align-items: center;
      gap: 8px;
      color: #667eea;
      text-decoration: none;
      font-weight: 600;
      font-size: 14px;
      transition: all 0.3s ease;
    }

    .card-link:hover {
      gap: 12px;
      color: #764ba2;
    }

    /* FAQ Section */
    .appointment-faq-section {
      padding: 60px 0;
      background-color: #f8f9fa;
    }

    .section-title {
      margin-bottom: 40px;
    }

    .section-title h2 {
      font-size: 32px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 10px;
    }

    .section-title p {
      font-size: 16px;
      color: #666;
    }

    .faq-item {
      background: white;
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
      margin-bottom: 20px;
    }

    .faq-question {
      padding: 20px;
      background: #f8f9fa;
      cursor: pointer;
      display: flex;
      align-items: center;
      gap: 15px;
      transition: all 0.3s ease;
    }

    .faq-question:hover {
      background: #f0f0f0;
    }

    .faq-question i {
      color: #667eea;
      font-size: 18px;
      min-width: 20px;
    }

    .faq-question h4 {
      margin: 0;
      font-size: 15px;
      font-weight: 600;
      color: #1a1a1a;
    }

    .faq-answer {
      padding: 20px;
      display: none;
      color: #666;
      font-size: 14px;
      line-height: 1.6;
    }

    .faq-answer p {
      margin: 0;
    }

    /* CTA Section */
    .appointment-cta-section {
      padding: 60px 20px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      text-align: center;
    }

    .appointment-cta-section h2 {
      font-size: 36px;
      font-weight: 700;
      margin-bottom: 15px;
    }

    .appointment-cta-section p {
      font-size: 16px;
      margin-bottom: 30px;
    }

    .cta-button {
      display: inline-block;
      padding: 15px 40px;
      background: white;
      color: #667eea;
      text-decoration: none;
      font-weight: 600;
      border-radius: 5px;
      transition: all 0.3s ease;
    }

    .cta-button:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(255, 255, 255, 0.3);
    }

    .appointment-checkbox {
      padding: 15px;
      background: #f8f9fa;
      border-radius: 5px;
      margin-top: 10px;
      display: flex;
      align-items: flex-start;
      gap: 10px;
    }

    .appointment-checkbox .form-check-input {
      margin-top: 3px;
      flex-shrink: 0;
    }

    .appointment-checkbox label {
      font-size: 13px;
      line-height: 1.5;
      color: #666;
    }

    /* Responsive Styles */
    @media (max-width: 992px) {
      .appointment-form-wrapper {
        padding: 30px;
      }

      .form-header h2 {
        font-size: 24px;
      }

      .appointment-submit-btn {
        padding: 12px 20px;
        font-size: 15px;
      }
    }

    @media (max-width: 768px) {
      .appointment-section {
        padding: 30px 0;
      }

      .appointment-form-wrapper {
        padding: 20px;
      }

      .form-header {
        margin-bottom: 25px;
      }

      .form-header h2 {
        font-size: 22px;
      }

      .form-header p {
        font-size: 14px;
      }

      .form-row {
        flex-direction: column;
        gap: 0;
        margin-bottom: 15px;
      }

      .form-group {
        margin-bottom: 15px;
        width: 100%;
      }

      .property-type-options {
        grid-template-columns: repeat(2, 1fr);
        gap: 12px;
      }

      .appointment-label {
        font-size: 13px;
      }

      .appointment-input {
        padding: 11px 12px;
        font-size: 13px;
      }

      .detail-item {
        gap: 10px;
      }

      .section-title h2 {
        font-size: 26px;
      }

      .appointment-cta-section h2 {
        font-size: 28px;
      }
    }

    @media (max-width: 576px) {
      .appointment-form-wrapper {
        padding: 15px;
      }

      .form-header h2 {
        font-size: 20px;
      }

      .form-header p {
        font-size: 13px;
      }

      .property-type-options {
        grid-template-columns: 1fr;
      }

      .section-title h2 {
        font-size: 22px;
      }

      .section-title p {
        font-size: 14px;
      }

      .faq-question {
        padding: 15px;
        gap: 12px;
      }

      .faq-answer {
        padding: 15px;
      }

      .appointment-cta-section {
        padding: 40px 15px;
      }

      .appointment-cta-section h2 {
        font-size: 24px;
      }

      .appointment-cta-section p {
        font-size: 14px;
      }

      .cta-button {
        padding: 12px 30px;
        font-size: 14px;
      }

      .appointment-submit-btn {
        padding: 11px 18px;
        font-size: 14px;
      }
    }
  </style>
</head>

<body>

  <?php include 'header.php'; ?>

  <!--==============================
    Breadcrumb Area
  ==============================-->
  <div class="breadcrumb-wrapper" style="background-image: url('assets/img/bg/breadcrumb-bg.jpg')">
    <div class="breadcrumb-content">
      <h1 class="breadcrumb-title">Book Your Appointment</h1>
      <div class="breadcrumb-menu">
        <a href="index.php">Home</a>
        <span class="breadcrumb-separator">/</span>
        <span class="breadcrumb-current">Appointment</span>
      </div>
    </div>
  </div>

  <!--==============================
    Appointment Section
  ==============================-->
  <section class="appointment-section">
    <div class="container">
      <div class="row g-4 align-items-center">

        <!-- LEFT SIDE: APPOINTMENT FORM -->
        <div class="col-lg-8">
          <div class="appointment-form-wrapper">
            
            <div class="form-header">
              <h2>Schedule Your Property Consultation</h2>
              <p>Fill out the form below to book your appointment with our expert real estate agents</p>
            </div>

            <form class="appointment-form" id="appointmentForm" method="POST">
              
              <!-- Row 1: Name and Email -->
              <div class="form-row">
                <div class="form-group col-md-6 col-12">
                  <label for="fullName" class="form-label">Full Name *</label>
                  <input type="text" class="form-control appointment-input" id="fullName" name="fullName" placeholder="Enter your full name" required>
                </div>
                <div class="form-group col-md-6 col-12">
                  <label for="email" class="form-label">Email Address *</label>
                  <input type="email" class="form-control appointment-input" id="email" name="email" placeholder="Enter your email" required>
                </div>
              </div>

              <!-- Row 2: Phone and Date -->
              <div class="form-row">
                <div class="form-group col-md-6 col-12">
                  <label for="phone" class="form-label">Phone Number *</label>
                  <input type="tel" class="form-control appointment-input" id="phone" name="phone" placeholder="Enter your phone number" required>
                </div>
                <div class="form-group col-md-6 col-12">
                  <label for="appointmentDate" class="form-label">Preferred Date *</label>
                  <input type="date" class="form-control appointment-input" id="appointmentDate" name="appointmentDate" required>
                </div>
              </div>

              <!-- Row 3: Time and Appointment Type -->
              <div class="form-row">
                <div class="form-group col-md-6 col-12">
                  <label for="appointmentTime" class="form-label">Preferred Time *</label>
                  <input type="time" class="form-control appointment-input" id="appointmentTime" name="appointmentTime" required>
                </div>
                <div class="form-group col-md-6 col-12">
                  <label for="appointmentType" class="form-label">Appointment Type *</label>
                  <select class="form-control appointment-input" id="appointmentType" name="appointmentType" required>
                    <option value="">Select appointment type</option>
                    <option value="property-viewing">Property Viewing</option>
                    <option value="consultation">General Consultation</option>
                    <option value="investment">Investment Discussion</option>
                    <option value="selling">Selling Property</option>
                    <option value="renovation">Renovation Support</option>
                  </select>
                </div>
              </div>

              <!-- Row 4: Property Interest -->
              <div class="form-row">
                <div class="form-group col-12">
                  <label for="propertyType" class="form-label">Property Type of Interest *</label>
                  <div class="property-type-options">
                    <div class="form-check">
                      <input class="form-check-input" type="checkbox" name="propertyType" value="apartment" id="apartment">
                      <label class="form-check-label" for="apartment">
                        <span class="property-option-text">Apartment</span>
                      </label>
                    </div>
                    <div class="form-check">
                      <input class="form-check-input" type="checkbox" name="propertyType" value="villa" id="villa">
                      <label class="form-check-label" for="villa">
                        <span class="property-option-text">Villa</span>
                      </label>
                    </div>
                    <div class="form-check">
                      <input class="form-check-input" type="checkbox" name="propertyType" value="commercial" id="commercial">
                      <label class="form-check-label" for="commercial">
                        <span class="property-option-text">Commercial</span>
                      </label>
                    </div>
                    <div class="form-check">
                      <input class="form-check-input" type="checkbox" name="propertyType" value="land" id="land">
                      <label class="form-check-label" for="land">
                        <span class="property-option-text">Land</span>
                      </label>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Row 5: Budget Range -->
              <div class="form-row">
                <div class="form-group col-12">
                  <label for="budgetRange" class="form-label">Budget Range</label>
                  <select class="form-control appointment-input" id="budgetRange" name="budgetRange">
                    <option value="">Select budget range</option>
                    <option value="below-100k">Below $100,000</option>
                    <option value="100k-250k">$100,000 - $250,000</option>
                    <option value="250k-500k">$250,000 - $500,000</option>
                    <option value="500k-1m">$500,000 - $1,000,000</option>
                    <option value="above-1m">Above $1,000,000</option>
                  </select>
                </div>
              </div>

              <!-- Row 6: Additional Info -->
              <div class="form-row">
                <div class="form-group col-12">
                  <label for="message" class="form-label">Additional Information</label>
                  <textarea class="form-control appointment-input" id="message" name="message" rows="5" placeholder="Tell us more about your requirements..."></textarea>
                </div>
              </div>

              <!-- Row 7: Terms & Submit -->
              <div class="form-row">
                <div class="form-group col-12">
                  <div class="form-check appointment-checkbox">
                    <input class="form-check-input" type="checkbox" id="terms" name="terms" required>
                    <label class="form-check-label" for="terms">
                      I agree to the terms and conditions and consent to have my contact details used for appointment confirmation
                    </label>
                  </div>
                </div>
              </div>

              <!-- Submit Button -->
              <div class="form-row">
                <div class="form-group col-12">
                  <button type="submit" class="appointment-submit-btn">
                    <i class="fas fa-check-circle"></i> Book Appointment
                  </button>
                </div>
              </div>

              <!-- Success Message -->
              <div class="form-message success-message" id="successMessage" style="display: none;">
                <i class="fas fa-check-circle"></i>
                <p>Thank you for your appointment request! We'll contact you soon to confirm.</p>
              </div>

              <!-- Error Message -->
              <div class="form-message error-message" id="errorMessage" style="display: none;">
                <i class="fas fa-exclamation-circle"></i>
                <p id="errorText"></p>
              </div>

            </form>

          </div>
        </div>

        <!-- RIGHT SIDE: INFO CARDS -->
        <div class="col-lg-4">
          
          <!-- Why Book Card -->
          <div class="appointment-info-card">
            <div class="card-icon">
              <i class="fas fa-calendar-check"></i>
            </div>
            <h3>Why Book an Appointment?</h3>
            <ul class="info-list">
              <li><i class="fas fa-check"></i> Personalized consultation</li>
              <li><i class="fas fa-check"></i> Expert property guidance</li>
              <li><i class="fas fa-check"></i> Best matching properties</li>
              <li><i class="fas fa-check"></i> Flexible scheduling</li>
            </ul>
          </div>

          <!-- Contact Info Card -->
          <div class="appointment-info-card">
            <div class="card-icon">
              <i class="fas fa-phone-alt"></i>
            </div>
            <h3>Contact Information</h3>
            <div class="contact-details">
              <div class="detail-item">
                <i class="fas fa-phone"></i>
                <div>
                  <p class="detail-label">Phone</p>
                  <a href="tel:+11234562228">+1 123 456 2228</a>
                </div>
              </div>
              <div class="detail-item">
                <i class="fas fa-envelope"></i>
                <div>
                  <p class="detail-label">Email</p>
                  <a href="mailto:info@example.com">info@example.com</a>
                </div>
              </div>
              <div class="detail-item">
                <i class="fas fa-map-marker-alt"></i>
                <div>
                  <p class="detail-label">Address</p>
                  <p>W7 Road Central Park, New York</p>
                </div>
              </div>
            </div>
          </div>

          <!-- Hours Card -->
          <div class="appointment-info-card">
            <div class="card-icon">
              <i class="fas fa-clock"></i>
            </div>
            <h3>Working Hours</h3>
            <div class="hours-list">
              <div class="hour-item">
                <span>Monday - Friday</span>
                <span class="time">09:00 - 18:00</span>
              </div>
              <div class="hour-item">
                <span>Saturday</span>
                <span class="time">10:00 - 16:00</span>
              </div>
              <div class="hour-item">
                <span>Sunday</span>
                <span class="time">Closed</span>
              </div>
            </div>
          </div>

          <!-- Agent Card -->
          <div class="appointment-info-card">
            <div class="card-icon">
              <i class="fas fa-user-tie"></i>
            </div>
            <h3>Our Expert Agents</h3>
            <p style="font-size: 14px; margin-bottom: 15px;">Book with our professional team ready to help you find your dream property</p>
            <a href="agents.php" class="card-link">
              View All Agents <i class="fas fa-arrow-right"></i>
            </a>
          </div>

        </div>

      </div>
    </div>
  </section>

  <!--==============================
    FAQ Section
  ==============================-->
  <section class="appointment-faq-section">
    <div class="container">
      <div class="section-title text-center">
        <h2>Frequently Asked Questions</h2>
        <p>Get answers to common questions about our appointment process</p>
      </div>

      <div class="row g-4">
        <div class="col-lg-6">
          <div class="faq-item">
            <div class="faq-question">
              <i class="fas fa-plus"></i>
              <h4>How long does a consultation appointment take?</h4>
            </div>
            <div class="faq-answer">
              <p>A typical consultation appointment takes 30-45 minutes. This gives us enough time to understand your needs and discuss suitable properties.</p>
            </div>
          </div>
        </div>

        <div class="col-lg-6">
          <div class="faq-item">
            <div class="faq-question">
              <i class="fas fa-plus"></i>
              <h4>Can I reschedule my appointment?</h4>
            </div>
            <div class="faq-answer">
              <p>Yes, you can reschedule your appointment up to 24 hours before the scheduled time by contacting our office directly.</p>
            </div>
          </div>
        </div>

        <div class="col-lg-6">
          <div class="faq-item">
            <div class="faq-question">
              <i class="fas fa-plus"></i>
              <h4>Is there a fee for consultation?</h4>
            </div>
            <div class="faq-answer">
              <p>No, our initial consultation is completely free. We're committed to understanding your needs without any obligation.</p>
            </div>
          </div>
        </div>

        <div class="col-lg-6">
          <div class="faq-item">
            <div class="faq-question">
              <i class="fas fa-plus"></i>
              <h4>Can I book multiple appointments?</h4>
            </div>
            <div class="faq-answer">
              <p>Absolutely! You can book multiple appointments for property viewings or follow-up consultations as needed.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!--==============================
    CTA Section
  ==============================-->
  <section class="appointment-cta-section">
    <div class="container text-center">
      <h2>Ready to Find Your Dream Property?</h2>
      <p>Our expert agents are waiting to help you make the right investment decision</p>
      <a href="appointment.php" class="cta-button">Book Your Consultation Today</a>
    </div>
  </section>

  <?php include 'footer.php'; ?>

  <!-- Scroll To Top -->
  <a href="#" class="scrollToTop scroll-btn"><i class="far fa-arrow-up"></i></a>

  <!--==============================
        All Js File
    ============================== -->
  <!-- Jquery -->
  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <!-- Bootstrap -->
  <script src="assets/js/bootstrap.min.js"></script>
  <!-- Slick Slider -->
  <script src="assets/js/slick.min.js"></script>
  <!-- Magnific Popup -->
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <!-- Imagesloaded -->
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <!-- Isotope -->
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <!-- Main Js File -->
  <script src="assets/js/main.js"></script>

  <!-- Appointment Form Script -->
  <script>
    document.getElementById('appointmentForm').addEventListener('submit', function(e) {
      e.preventDefault();

      // Get form values
      const fullName = document.getElementById('fullName').value;
      const email = document.getElementById('email').value;
      const phone = document.getElementById('phone').value;
      const appointmentDate = document.getElementById('appointmentDate').value;
      const appointmentTime = document.getElementById('appointmentTime').value;
      const appointmentType = document.getElementById('appointmentType').value;
      const propertyTypes = Array.from(document.querySelectorAll('input[name="propertyType"]:checked')).map(el => el.value);
      const budgetRange = document.getElementById('budgetRange').value;
      const message = document.getElementById('message').value;
      const terms = document.getElementById('terms').checked;

      // Validate
      if (!fullName || !email || !phone || !appointmentDate || !appointmentTime || !appointmentType) {
        showError('Please fill in all required fields');
        return;
      }

      if (propertyTypes.length === 0) {
        showError('Please select at least one property type');
        return;
      }

      if (!terms) {
        showError('Please agree to the terms and conditions');
        return;
      }

      // Validate date is not in the past
      const selectedDate = new Date(appointmentDate);
      const today = new Date();
      today.setHours(0, 0, 0, 0);

      if (selectedDate < today) {
        showError('Please select a future date');
        return;
      }

      // Disable submit button
      const submitBtn = this.querySelector('button[type="submit"]');
      submitBtn.disabled = true;
      submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Booking...';

      // Send data to server
      fetch('api/appointment-save.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({
          fullName,
          email,
          phone,
          appointmentDate,
          appointmentTime,
          appointmentType,
          propertyTypes,
          budgetRange,
          message
        })
      })
      .then(response => {
        if (!response.ok) {
          return response.text().then(text => {
            console.error('HTTP Error:', response.status, text);
            throw new Error(`Server error: ${response.status}`);
          });
        }
        return response.text().then(text => {
          try {
            return JSON.parse(text);
          } catch (e) {
            console.error('JSON Parse Error:', e, 'Response text:', text);
            throw new Error('Invalid response from server');
          }
        });
      })
      .then(data => {
        if (data.success) {
          showSuccess();
          setTimeout(() => {
            this.reset();
            document.getElementById('successMessage').style.display = 'none';
            submitBtn.disabled = false;
            submitBtn.innerHTML = '<i class="fas fa-check-circle"></i> Book Appointment';
          }, 3000);
        } else {
          showError(data.message || 'An error occurred. Please try again.');
          submitBtn.disabled = false;
          submitBtn.innerHTML = '<i class="fas fa-check-circle"></i> Book Appointment';
        }
      })
      .catch(error => {
        console.error('Error Details:', error);
        showError('Error: ' + error.message);
        submitBtn.disabled = false;
        submitBtn.innerHTML = '<i class="fas fa-check-circle"></i> Book Appointment';
      });
    });

    function showError(message) {
      const errorDiv = document.getElementById('errorMessage');
      const errorText = document.getElementById('errorText');
      errorText.textContent = message;
      errorDiv.style.display = 'block';
      document.getElementById('successMessage').style.display = 'none';

      setTimeout(() => {
        errorDiv.style.display = 'none';
      }, 5000);
    }

    function showSuccess() {
      document.getElementById('successMessage').style.display = 'block';
      document.getElementById('errorMessage').style.display = 'none';
    }

    // Set minimum date to today
    const dateInput = document.getElementById('appointmentDate');
    const today = new Date().toISOString().split('T')[0];
    dateInput.setAttribute('min', today);

    // Add FAQ toggle functionality
    document.querySelectorAll('.faq-question').forEach(question => {
      question.addEventListener('click', function() {
        const answer = this.nextElementSibling;
        const icon = this.querySelector('i');
        
        // Close all other FAQs
        document.querySelectorAll('.faq-question').forEach(q => {
          if (q !== this) {
            q.nextElementSibling.style.display = 'none';
            q.querySelector('i').classList.remove('fa-minus');
            q.querySelector('i').classList.add('fa-plus');
          }
        });

        // Toggle current FAQ
        if (answer.style.display === 'none' || answer.style.display === '') {
          answer.style.display = 'block';
          icon.classList.remove('fa-plus');
          icon.classList.add('fa-minus');
        } else {
          answer.style.display = 'none';
          icon.classList.add('fa-plus');
          icon.classList.remove('fa-minus');
        }
      });
    });
  </script>

</body>

</html>
