<?php
require_once 'config.php';

// Get blog post ID from URL
$blog_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Redirect to blog.php if no ID provided
if ($blog_id <= 0) {
    header("Location: blog.php");
    exit;
}

// Fetch current blog post
$stmt = $conn->prepare("SELECT * FROM blog_posts WHERE id = ?");
$stmt->bind_param("i", $blog_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    header("Location: blog.php");
    exit;
}

$blog_post = $result->fetch_assoc();
$stmt->close();

// Fetch recent blog posts for sidebar
$recent_stmt = $conn->prepare("SELECT id, title, created_at, featured_image FROM blog_posts ORDER BY created_at DESC LIMIT 5");
$recent_stmt->execute();
$recent_result = $recent_stmt->get_result();
$recent_posts = [];
while ($row = $recent_result->fetch_assoc()) {
    $recent_posts[] = $row;
}
$recent_stmt->close();
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title><?php echo htmlspecialchars($blog_post['title']); ?> - Zemaraim Blog</title>
  <meta name="author" content="Zemaraim">
  <meta name="description" content="<?php echo htmlspecialchars(substr($blog_post['content'], 0, 150)); ?>">
  <meta name="keywords" content="real estate, blog, property">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  
  <style>
    .blog-details-wrapper {
      display: grid;
      grid-template-columns: 2fr 1fr;
      gap: 40px;
      padding: 40px 0;
    }
    
    .blog-content-main {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(10px);
      border-radius: 15px;
      padding: 40px;
      border: 1px solid rgba(255, 255, 255, 0.2);
      box-shadow: 0 8px 32px rgba(102, 126, 234, 0.1);
    }
    
    .blog-featured-image {
      width: 100%;
      max-height: 400px;
      object-fit: cover;
      border-radius: 10px;
      margin-bottom: 30px;
    }
    
    .blog-meta {
      display: flex;
      gap: 20px;
      margin-bottom: 20px;
      flex-wrap: wrap;
    }
    
    .blog-meta span {
      font-size: 14px;
      color: #667eea;
      font-weight: 500;
    }
    
    .blog-title {
      font-size: 36px;
      font-weight: 700;
      color: #212529;
      margin-bottom: 20px;
      font-family: 'Playfair Display', serif;
    }
    
    .blog-content-main p {
      font-size: 16px;
      line-height: 1.8;
      color: #555;
      margin-bottom: 20px;
    }
    
    .blog-content-main h3 {
      font-size: 24px;
      font-weight: 600;
      color: #212529;
      margin-top: 30px;
      margin-bottom: 15px;
      font-family: 'Playfair Display', serif;
    }
    
    .blog-content-main ul {
      list-style: none;
      padding-left: 0;
      margin-bottom: 20px;
    }
    
    .blog-content-main ul li {
      padding-left: 25px;
      margin-bottom: 10px;
      color: #555;
      position: relative;
    }
    
    .blog-content-main ul li:before {
      content: "✓";
      position: absolute;
      left: 0;
      color: #667eea;
      font-weight: bold;
    }
    
    .blog-sidebar {
      display: flex;
      flex-direction: column;
      gap: 30px;
    }
    
    .sidebar-widget {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(10px);
      border-radius: 15px;
      padding: 30px;
      border: 1px solid rgba(255, 255, 255, 0.2);
      box-shadow: 0 8px 32px rgba(102, 126, 234, 0.1);
    }
    
    .widget-title {
      font-size: 20px;
      font-weight: 700;
      color: #212529;
      margin-bottom: 20px;
      padding-bottom: 15px;
      border-bottom: 2px solid #667eea;
      font-family: 'Playfair Display', serif;
    }
    
    .recent-posts-list {
      list-style: none;
      padding: 0;
    }
    
    .recent-posts-list li {
      padding-bottom: 15px;
      margin-bottom: 15px;
      border-bottom: 1px solid rgba(102, 126, 234, 0.2);
    }
    
    .recent-posts-list li:last-child {
      border-bottom: none;
    }
    
    .recent-post-link {
      display: flex;
      gap: 12px;
      text-decoration: none;
      transition: all 0.3s ease;
    }
    
    .recent-post-image {
      width: 70px;
      height: 70px;
      object-fit: cover;
      border-radius: 8px;
      flex-shrink: 0;
    }
    
    .recent-post-info h5 {
      font-size: 14px;
      font-weight: 600;
      color: #212529;
      margin: 0 0 5px 0;
      line-height: 1.4;
    }
    
    .recent-post-date {
      font-size: 12px;
      color: #667eea;
    }
    
    .recent-post-link:hover .recent-post-info h5 {
      color: #667eea;
    }
    
    .share-buttons {
      display: flex;
      gap: 10px;
      flex-wrap: wrap;
    }
    
    .share-btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      width: 40px;
      height: 40px;
      border-radius: 50%;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      text-decoration: none;
      transition: all 0.3s ease;
      font-size: 16px;
    }
    
    .share-btn:hover {
      transform: translateY(-4px);
      box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
    }
    
    @media (max-width: 1200px) {
      .blog-details-wrapper {
        grid-template-columns: 1fr 1fr;
        gap: 30px;
      }
      
      .blog-content-main {
        padding: 30px;
      }
      
      .blog-title {
        font-size: 28px;
      }
    }
    
    @media (max-width: 768px) {
      .blog-details-wrapper {
        grid-template-columns: 1fr;
        gap: 30px;
        padding: 20px 0;
      }
      
      .blog-content-main {
        padding: 20px;
      }
      
      .blog-featured-image {
        max-height: 300px;
        margin-bottom: 20px;
      }
      
      .blog-title {
        font-size: 24px;
        margin-bottom: 15px;
      }
      
      .blog-meta {
        gap: 15px;
      }
      
      .blog-content-main p {
        font-size: 15px;
      }
      
      .sidebar-widget {
        padding: 20px;
      }
      
      .widget-title {
        font-size: 18px;
      }
    }
    
    @media (max-width: 480px) {
      .blog-details-wrapper {
        padding: 0;
      }
      
      .blog-content-main {
        padding: 15px;
        border-radius: 10px;
      }
      
      .blog-featured-image {
        max-height: 220px;
        border-radius: 8px;
        margin-bottom: 15px;
      }
      
      .blog-title {
        font-size: 20px;
        margin-bottom: 12px;
      }
      
      .blog-meta {
        gap: 10px;
        margin-bottom: 15px;
      }
      
      .blog-meta span {
        font-size: 12px;
      }
      
      .blog-content-main p {
        font-size: 14px;
        line-height: 1.6;
        margin-bottom: 15px;
      }
      
      .blog-content-main h3 {
        font-size: 18px;
        margin-top: 20px;
        margin-bottom: 10px;
      }
      
      .recent-post-image {
        width: 60px;
        height: 60px;
      }
      
      .recent-post-info h5 {
        font-size: 13px;
      }
      
      .sidebar-widget {
        padding: 15px;
      }
      
      .widget-title {
        font-size: 16px;
        margin-bottom: 15px;
      }
    }
  </style>
</head>

<body>
  <!--[if lte IE 9]>
    	<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
  <![endif]-->

  <?php include 'header.php'; ?>
  
  <!--==============================
    Breadcrumb
    ============================== -->
  <div class="breadcrumb-wrapper" style="background-image: url('assets/img/bg/breadcrumb-bg.jpg')">
    <div class="breadcrumb-content">
      <h1 class="breadcrumb-title">Blog Details</h1>
      <div class="breadcrumb-menu">
        <a href="index.php">Home</a>
        <span class="breadcrumb-separator">/</span>
        <a href="blog.php">Blog</a>
        <span class="breadcrumb-separator">/</span>
        <span class="breadcrumb-current"><?php echo htmlspecialchars(substr($blog_post['title'], 0, 30)); ?></span>
      </div>
    </div>
  </div>
  
  <!--==============================
  Blog Details Area
  ==============================-->
  <section class="glass-blog-details-only">
    <div class="container">
      
      <div class="blog-details-wrapper">
        
        <!-- MAIN BLOG CONTENT -->
        <div class="blog-content-main">
          
          <!-- Featured Image -->
          <img src="<?php echo htmlspecialchars($blog_post['featured_image']); ?>" alt="<?php echo htmlspecialchars($blog_post['title']); ?>" class="blog-featured-image">
          
          <!-- Meta Information -->
          <div class="blog-meta">
            <span><i class="fas fa-calendar"></i> <?php echo date('M d, Y', strtotime($blog_post['created_at'])); ?></span>
            <span><i class="fas fa-user"></i> Admin</span>
            <span><i class="fas fa-tag"></i> Real Estate</span>
          </div>
          
          <!-- Blog Title -->
          <h1 class="blog-title"><?php echo htmlspecialchars($blog_post['title']); ?></h1>
          
          <!-- Blog Content -->
          <div class="blog-text">
            <?php echo nl2br(htmlspecialchars($blog_post['content'])); ?>
          </div>
          
          <!-- Social Share -->
          <div style="margin-top: 40px; padding-top: 20px; border-top: 1px solid rgba(102, 126, 234, 0.2);">
            <h4 style="margin-bottom: 15px; color: #212529; font-weight: 600;">Share This Post</h4>
            <div class="share-buttons">
              <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode('https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']); ?>" class="share-btn" target="_blank" title="Share on Facebook">
                <i class="fab fa-facebook-f"></i>
              </a>
              <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode('https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']); ?>&text=<?php echo urlencode($blog_post['title']); ?>" class="share-btn" target="_blank" title="Share on Twitter">
                <i class="fab fa-twitter"></i>
              </a>
              <a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo urlencode('https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']); ?>" class="share-btn" target="_blank" title="Share on LinkedIn">
                <i class="fab fa-linkedin-in"></i>
              </a>
            </div>
          </div>
          
        </div>
        
        <!-- SIDEBAR -->
        <div class="blog-sidebar">
          
          <!-- Recent Posts Widget -->
          <?php if (count($recent_posts) > 0): ?>
          <div class="sidebar-widget">
            <h3 class="widget-title">Recent Posts</h3>
            <ul class="recent-posts-list">
              <?php foreach ($recent_posts as $post): ?>
              <li>
                <a href="blog-details.php?id=<?php echo $post['id']; ?>" class="recent-post-link">
                  <img src="<?php echo htmlspecialchars($post['featured_image']); ?>" alt="<?php echo htmlspecialchars($post['title']); ?>" class="recent-post-image">
                  <div class="recent-post-info">
                    <h5><?php echo htmlspecialchars($post['title']); ?></h5>
                    <div class="recent-post-date"><?php echo date('M d, Y', strtotime($post['created_at'])); ?></div>
                  </div>
                </a>
              </li>
              <?php endforeach; ?>
            </ul>
          </div>
          <?php endif; ?>
          
          <!-- Categories Widget -->
          <div class="sidebar-widget">
            <h3 class="widget-title">Categories</h3>
            <ul class="recent-posts-list">
              <li><a href="blog.php" style="text-decoration: none; color: #667eea; font-weight: 500;">Real Estate <span style="float: right; color: #999;">(6)</span></a></li>
              <li><a href="blog.php" style="text-decoration: none; color: #667eea; font-weight: 500;">Property Tips <span style="float: right; color: #999;">(6)</span></a></li>
              <li><a href="blog.php" style="text-decoration: none; color: #667eea; font-weight: 500;">Investment Guide <span style="float: right; color: #999;">(6)</span></a></li>
            </ul>
          </div>
          
        </div>
        
      </div>
      
    </div>
  </section>

  <?php include 'footer.php'; ?>
  
  <!-- Scroll To Top -->
  <a href="#" class="scrollToTop scroll-btn"><i class="far fa-arrow-up"></i></a>
  
  <!--==============================
        All Js File
    ============================== -->
  <!-- Jquery -->
  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <!-- Bootstrap -->
  <script src="assets/js/bootstrap.min.js"></script>
  <!-- Slick Slider -->
  <script src="assets/js/slick.min.js"></script>
  <!-- Magnific Popup -->
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <!-- Imagesloaded -->
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <!-- Isotope -->
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <!-- Main Js File -->
  <script src="assets/js/main.js"></script>
</body>

</html>
