<?php
require_once 'config.php';

// Get all blog posts from database
$query = "SELECT * FROM blog_posts ORDER BY created_at DESC";
$result = $conn->query($query);
$blog_posts = [];
while ($row = $result->fetch_assoc()) {
    $blog_posts[] = $row;
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Blog - Zemaraim Real Estate</title>
  <meta name="author" content="Zemaraim">
  <meta name="description" content="Real estate blog with market trends, investment tips, and property guides">
  <meta name="keywords" content="real estate blog, property investment, market trends">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  
  <style>
    body { background: #f7f7f7; }
    
    /* Breadcrumb */
    .blog-breadcrumb { 
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
      padding: 40px 0; 
      color: white;
    }
    .breadcrumb-link { color: white; text-decoration: none; transition: all 0.3s ease; }
    .breadcrumb-link:hover { color: #ddd; }
    .breadcrumb-separator { margin: 0 10px; opacity: 0.7; }
    
    /* Blog Section */
    .blog-section { padding: 60px 0; }
    .blog-header { text-align: center; margin-bottom: 50px; }
    .blog-header h1 { font-size: 42px; font-weight: 700; color: #1a1a1a; margin-bottom: 15px; }
    .blog-header p { font-size: 18px; color: #666; max-width: 600px; margin: 0 auto; }
    .section-underline { width: 60px; height: 4px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); margin: 20px auto; border-radius: 2px; }
    
    /* Blog Grid */
    .blog-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 30px; }
    
    /* Blog Card */
    .blog-card {
      background: white;
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 2px 15px rgba(0,0,0,0.08);
      transition: all 0.3s ease;
      cursor: pointer;
      text-decoration: none;
      color: inherit;
      display: flex;
      flex-direction: column;
      height: 100%;
    }
    
    .blog-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 10px 30px rgba(102,126,234,0.2);
    }
    
    .blog-image-section {
      position: relative;
      overflow: hidden;
      height: 220px;
      background: #f0f0f0;
    }
    
    .blog-image {
      width: 100%;
      height: 100%;
      object-fit: cover;
      transition: transform 0.3s ease;
    }
    
    .blog-card:hover .blog-image {
      transform: scale(1.05);
    }
    
    .blog-date-badge {
      position: absolute;
      top: 15px;
      right: 15px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 10px 15px;
      border-radius: 6px;
      font-size: 12px;
      font-weight: 600;
      text-align: center;
    }
    
    .blog-content {
      padding: 25px;
      flex-grow: 1;
      display: flex;
      flex-direction: column;
    }
    
    .blog-category {
      display: inline-block;
      background: #f0f4ff;
      color: #667eea;
      padding: 5px 12px;
      border-radius: 20px;
      font-size: 12px;
      font-weight: 600;
      text-transform: uppercase;
      margin-bottom: 12px;
      width: fit-content;
    }
    
    .blog-title {
      font-size: 20px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 12px;
      line-height: 1.4;
    }
    
    .blog-excerpt {
      color: #666;
      font-size: 14px;
      line-height: 1.6;
      margin-bottom: 20px;
      flex-grow: 1;
    }
    
    .blog-link {
      display: inline-flex;
      align-items: center;
      gap: 8px;
      color: #667eea;
      font-weight: 600;
      font-size: 14px;
      transition: all 0.3s ease;
    }
    
    .blog-card:hover .blog-link {
      gap: 12px;
      color: #764ba2;
    }
    
    .blog-link i {
      transition: transform 0.3s ease;
    }
    
    .blog-card:hover .blog-link i {
      transform: translateX(3px);
    }
    
    /* Responsive Design */
    @media (max-width: 992px) {
      .blog-header h1 { font-size: 36px; }
      .blog-header p { font-size: 16px; }
      .blog-grid { gap: 25px; }
      .blog-section { padding: 50px 0; }
    }
    
    @media (max-width: 768px) {
      .blog-section { padding: 40px 0; }
      .blog-header { margin-bottom: 40px; }
      .blog-header h1 { font-size: 28px; }
      .blog-header p { font-size: 15px; }
      .blog-grid { grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 20px; }
      .blog-image-section { height: 200px; }
      .blog-content { padding: 20px; }
      .blog-title { font-size: 18px; }
      .blog-excerpt { font-size: 13px; }
      .blog-breadcrumb { padding: 30px 0; }
      .blog-date-badge { padding: 8px 12px; font-size: 11px; }
    }
    
    @media (max-width: 480px) {
      .blog-section { padding: 30px 0; }
      .blog-header { margin-bottom: 30px; }
      .blog-header h1 { font-size: 24px; }
      .blog-header p { font-size: 14px; }
      .blog-grid { grid-template-columns: 1fr; gap: 15px; }
      .blog-image-section { height: 180px; }
      .blog-content { padding: 15px; }
      .blog-title { font-size: 16px; margin-bottom: 10px; }
      .blog-excerpt { font-size: 12px; margin-bottom: 15px; }
      .blog-category { font-size: 11px; padding: 4px 10px; }
      .blog-breadcrumb { padding: 20px 0; font-size: 13px; }
      .blog-date-badge { padding: 6px 10px; font-size: 10px; }
    }
  </style>
</head>

<body>
  <?php include 'header.php'; ?>
  
  <!-- Breadcrumb -->
  <div class="blog-breadcrumb">
    <div class="container">
      <a href="index.php" class="breadcrumb-link"><i class="fas fa-home"></i> Home</a>
      <span class="breadcrumb-separator">/</span>
      <span>Blog</span>
    </div>
  </div>

  <!-- Blog Section -->
  <section class="blog-section">
    <div class="container">
      <!-- Header -->
      <div class="blog-header">
        <h1>Latest Blog Posts</h1>
        <div class="section-underline"></div>
        <p>Stay updated with market trends, investment tips, and real estate guidance</p>
      </div>

      <!-- Blog Grid -->
      <div class="blog-grid">
        <?php foreach ($blog_posts as $post): ?>
          <a href="blog-details.php?id=<?php echo $post['id']; ?>" class="blog-card">
            <div class="blog-image-section">
              <img src="<?php echo !empty($post['featured_image']) ? htmlspecialchars($post['featured_image']) : 'assets/img/blog/blog-default.jpg'; ?>" alt="<?php echo htmlspecialchars($post['title']); ?>" class="blog-image">
              <div class="blog-date-badge">
                <?php echo date('d M', strtotime($post['created_at'])); ?>
              </div>
            </div>
            <div class="blog-content">
              <span class="blog-category">Real Estate</span>
              <h3 class="blog-title"><?php echo htmlspecialchars($post['title']); ?></h3>
              <p class="blog-excerpt"><?php echo htmlspecialchars(substr($post['content'], 0, 100)) . '...'; ?></p>
              <span class="blog-link">
                Read More <i class="fas fa-arrow-right"></i>
              </span>
            </div>
          </a>
        <?php endforeach; ?>
      </div>
    </div>
  </section>

  <?php include 'footer.php'; ?>
  
  <!-- Scroll To Top -->
  <a href="#" class="scrollToTop scroll-btn"><i class="far fa-arrow-up"></i></a>
  
  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <script src="assets/js/main.js"></script>
</body>

</html>
