<?php
require_once 'config.php';

echo "<!DOCTYPE html>
<html>
<head>
    <title>Database Status Check</title>
    <style>
        body { font-family: Arial; margin: 40px; background: #f5f5f5; }
        .container { max-width: 900px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; }
        h1 { color: #667eea; }
        .stat { padding: 15px; margin: 10px 0; background: #f8f9fa; border-left: 3px solid #667eea; border-radius: 5px; }
        .success { border-left-color: #28a745; background: #d4edda; }
        .number { font-size: 32px; font-weight: bold; color: #667eea; }
        code { background: #f4f4f4; padding: 3px 8px; border-radius: 3px; }
    </style>
</head>
<body>
<div class='container'>
    <h1>📊 Database Status</h1>";

try {
    // Count test data
    $stats = [];
    
    // Customers
    $result = $conn->query("SELECT COUNT(*) as count FROM customers");
    $stats['customers'] = $result->fetch_assoc()['count'];
    
    // Properties
    $result = $conn->query("SELECT COUNT(*) as count FROM properties WHERE status = 'active'");
    $stats['properties'] = $result->fetch_assoc()['count'];
    
    // Inquiries
    $result = $conn->query("SELECT COUNT(*) as count FROM inquiries WHERE status = 'pending'");
    $stats['pending_inquiries'] = $result->fetch_assoc()['count'];
    
    // Appointments
    $result = $conn->query("SELECT COUNT(*) as count FROM appointments WHERE status IN ('pending', 'scheduled')");
    $stats['appointments'] = $result->fetch_assoc()['count'];
    
    // Users (Staff)
    $result = $conn->query("SELECT COUNT(*) as count FROM users WHERE role = 'staff'");
    $stats['staff'] = $result->fetch_assoc()['count'];
    
    echo "<div class='stat success'><strong>👥 Customers:</strong> <div class='number'>{$stats['customers']}</div></div>";
    echo "<div class='stat success'><strong>🏠 Properties:</strong> <div class='number'>{$stats['properties']}</div></div>";
    echo "<div class='stat success'><strong>💬 Pending Inquiries:</strong> <div class='number'>{$stats['pending_inquiries']}</div></div>";
    echo "<div class='stat success'><strong>📅 Pending Appointments:</strong> <div class='number'>{$stats['appointments']}</div></div>";
    echo "<div class='stat success'><strong>👔 Staff Users:</strong> <div class='number'>{$stats['staff']}</div></div>";
    
    echo "<h2>🔑 Login Credentials:</h2>";
    echo "<div class='stat'><strong>Staff Dashboard:</strong><br>Email: <code>staff@Zemaraim.com</code><br>Password: <code>staff123</code></div>";
    
    echo "<h2>📍 Next Steps:</h2>";
    echo "<ol>";
    echo "<li>Go to <a href='staff-login.php'><strong>Staff Login</strong></a></li>";
    echo "<li>Login with staff@Zemaraim.com / staff123</li>";
    echo "<li>Navigate to <a href='dashboards/staff-dashboard.php'><strong>Staff Dashboard</strong></a></li>";
    echo "<li>View pending inquiries, appointments, and properties</li>";
    echo "</ol>";
    
} catch (Exception $e) {
    echo "<div class='stat' style='background: #f8d7da; border-left-color: #dc3545;'>";
    echo "<strong>❌ Error:</strong> " . $e->getMessage();
    echo "</div>";
}

echo "</div></body></html>";
?>
