<?php
require_once 'config.php';

// Handle form submission
$form_message = '';
$form_status = '';
$show_success = isset($_GET['success']) ? true : false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get form data
    $name = isset($_POST['name']) ? trim($_POST['name']) : '';
    $email = isset($_POST['email']) ? trim($_POST['email']) : '';
    $phone = isset($_POST['phone']) ? trim($_POST['phone']) : '';
    $subject = isset($_POST['subject']) ? trim($_POST['subject']) : '';
    $property_type = isset($_POST['property_type']) ? trim($_POST['property_type']) : '';
    $message = isset($_POST['message']) ? trim($_POST['message']) : '';

    // Validation
    if (!empty($name) && !empty($email) && !empty($message)) {
        // Insert into database
        $stmt = $conn->prepare("INSERT INTO contact_inquiries (name, email, phone, subject, property_type, message, status) VALUES (?, ?, ?, ?, ?, ?, 'new')");
        $stmt->bind_param("ssssss", $name, $email, $phone, $subject, $property_type, $message);
        
        if ($stmt->execute()) {
            // Redirect to same page with success parameter (POST-Redirect-GET pattern)
            header('Location: contact.php?success=1');
            exit;
        } else {
            $form_message = 'Sorry, there was an error submitting your form. Please try again.';
            $form_status = 'error';
        }
        $stmt->close();
    } else {
        $form_message = 'Please fill in all required fields (Name, Email, and Message).';
        $form_status = 'error';
    }
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Contact Us - Zemaraim Real Estate</title>
  <meta name="author" content="Zemaraim">
  <meta name="description" content="Get in touch with our real estate experts. Contact us for property inquiries, consultations, and more.">
  <meta name="keywords" content="contact, real estate, property inquiry, consultation">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <style>
    /* Contact Page Styles */
    .contact-section {
      padding: 20px 0;
      background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    }

    .contact-header {
      text-align: center;
      margin-bottom: 60px;
      animation: fadeInDown 0.6s ease-out;
    }

    .contact-header h2 {
      font-size: clamp(32px, 5vw, 52px);
      font-weight: 700;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
      margin-bottom: 15px;
    }

    .contact-header p {
      font-size: clamp(14px, 3vw, 18px);
      color: #666;
      max-width: 600px;
      margin: 0 auto;
    }

    /* Contact Container */
    .contact-container {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 50px;
      align-items: start;
    }

    /* Contact Info Section */
    .contact-info-section {
      display: flex;
      flex-direction: column;
      gap: 9px;
    }

    .contact-info-card {
      background: white;
      padding: 10px;
      border-radius: 15px;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
      transition: all 0.3s ease;
    }

    .contact-info-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 15px 40px rgba(102, 126, 234, 0.15);
    }

    .info-icon {
      width: 60px;
      height: 60px;
      border-radius: 12px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      display: flex;
      align-items: center;
      justify-content: center;
      color: white;
      font-size: 24px;
      margin-bottom: 15px;
    }

    .info-title {
      font-size: 18px;
      font-weight: 700;
      color: #222;
      margin-bottom: 8px;
    }

    .info-content {
      font-size: 15px;
      color: #666;
      line-height: 1.6;
    }

    .info-content a {
      color: #667eea;
      text-decoration: none;
      font-weight: 600;
    }

    .info-content a:hover {
      text-decoration: underline;
    }

    /* Contact Form Section */
    .contact-form-section {
      background: white;
      padding: 40px;
      border-radius: 15px;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    }

    .form-title {
      font-size: 24px;
      font-weight: 700;
      color: #222;
      margin-bottom: 10px;
    }

    .form-subtitle {
      font-size: 14px;
      color: #999;
      margin-bottom: 30px;
    }

    /* Form Status Messages */
    .form-status {
      padding: 15px 20px;
      border-radius: 8px;
      margin-bottom: 25px;
      font-size: 14px;
      font-weight: 600;
      animation: slideDown 0.4s ease-out;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .form-status.success {
      background: linear-gradient(135deg, #10b98115 0%, #059669 15%);
      color: #047857;
      border-left: 4px solid #059669;
    }

    .form-status.error {
      background: linear-gradient(135deg, #ef444415 0%, #dc2626 15%);
      color: #991b1b;
      border-left: 4px solid #dc2626;
    }

    .close-btn {
      background: none;
      border: none;
      font-size: 24px;
      cursor: pointer;
      color: inherit;
      padding: 0;
      margin-left: 15px;
      transition: transform 0.2s ease;
      flex-shrink: 0;
    }

    .close-btn:hover {
      transform: scale(1.2);
    }

    /* Form Fields */
    .form-group {
      margin-bottom: 25px;
    }

    .form-group label {
      display: block;
      font-size: 14px;
      font-weight: 600;
      color: #222;
      margin-bottom: 8px;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .form-group input,
    .form-group select,
    .form-group textarea {
      width: 100%;
      padding: 12px 16px;
      border: 2px solid #e5e5e5;
      border-radius: 8px;
      font-size: 14px;
      font-family: 'Poppins', sans-serif;
      transition: all 0.3s ease;
      background: white;
      color: #222;
    }

    .form-group input:focus,
    .form-group select:focus,
    .form-group textarea:focus {
      outline: none;
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
      background: linear-gradient(135deg, #667eea05 0%, #764ba205 100%);
    }

    .form-group textarea {
      resize: vertical;
      min-height: 120px;
    }

    .form-row {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 20px;
    }

    /* Submit Button */
    .submit-btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
      width: 100%;
      padding: 14px 30px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      border-radius: 8px;
      font-size: 16px;
      font-weight: 700;
      cursor: pointer;
      transition: all 0.3s ease;
      text-transform: uppercase;
      letter-spacing: 1px;
    }

    .submit-btn:hover {
      transform: translateY(-3px);
      box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
    }

    .submit-btn:active {
      transform: translateY(-1px);
    }

    /* Animations */
    @keyframes fadeInDown {
      from {
        opacity: 0;
        transform: translateY(-20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    @keyframes slideDown {
      from {
        opacity: 0;
        transform: translateY(-10px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    /* Responsive Design */
    @media (max-width: 768px) {
      .contact-section {
        padding: 50px 0;
      }

      .contact-container {
        grid-template-columns: 1fr;
        gap: 40px;
      }

      .contact-form-section {
        padding: 30px;
      }

      .form-row {
        grid-template-columns: 1fr;
      }

      .contact-header h2 {
        font-size: 32px;
      }
    }

    @media (max-width: 480px) {
      .contact-section {
        padding: 40px 0;
      }

      .contact-header h2 {
        font-size: 24px;
      }

      .contact-header p {
        font-size: 13px;
      }

      .contact-form-section {
        padding: 20px;
      }

      .form-title {
        font-size: 18px;
      }

      .contact-info-card {
        padding: 20px;
      }

      .info-icon {
        width: 50px;
        height: 50px;
        font-size: 20px;
      }

      .info-title {
        font-size: 16px;
      }

      .info-content {
        font-size: 13px;
      }
    }
  </style>
</head>

<body>
  <?php include 'header.php'; ?>
  
  <!-- Breadcrumb -->
  <div class="breadcrumb-wrapper" style="background-image: url('assets/img/bg/breadcrumb-bg.jpg')">
    <div class="breadcrumb-content">
      <h1 class="breadcrumb-title">Get In Touch</h1>
      <div class="breadcrumb-menu">
        <a href="index.php">Home</a>
        <span class="breadcrumb-separator">/</span>
        <span class="breadcrumb-current">Contact Us</span>
      </div>
    </div>
  </div>

  <!-- Contact Section -->
  <section class="contact-section">
    <div class="container">
      <!-- Section Header -->
      <div class="contact-header">
        <h2>Let's Connect</h2>
        <p>Have questions about finding your dream property? Reach out to our team and we'll help you every step of the way</p>
      </div>

      <!-- Contact Container -->
      <div class="contact-container">
        <!-- Left: Contact Information -->
        <div class="contact-info-section">
          <!-- Office Location -->
          <div class="contact-info-card">
            <div class="info-icon">
              <i class="fas fa-map-marker-alt"></i>
            </div>
            <h3 class="info-title">📍 Our Office</h3>
            <p class="info-content">
              123 Real Estate Avenue<br>
              New York, NY 10001<br>
              United States
            </p>
          </div>

          <!-- Phone -->
          <div class="contact-info-card">
            <div class="info-icon">
              <i class="fas fa-phone"></i>
            </div>
            <h3 class="info-title">📞 Call Us</h3>
            <p class="info-content">
              <a href="tel:+1-555-123-4567">+1 (555) 123-4567</a><br>
              <span style="font-size: 13px; color: #999;">Available Monday - Friday<br>9:00 AM - 6:00 PM EST</span>
            </p>
          </div>

          <!-- Email -->
          <div class="contact-info-card">
            <div class="info-icon">
              <i class="fas fa-envelope"></i>
            </div>
            <h3 class="info-title">✉️ Email Us</h3>
            <p class="info-content">
              <a href="mailto:info@Zemaraim.com">info@Zemaraim.com</a><br>
              <a href="mailto:support@Zemaraim.com">support@Zemaraim.com</a>
            </p>
          </div>

          <!-- Hours -->
          <div class="contact-info-card">
            <div class="info-icon">
              <i class="fas fa-clock"></i>
            </div>
            <h3 class="info-title">🕐 Business Hours</h3>
            <p class="info-content">
              Mon - Fri: 9:00 AM - 6:00 PM<br>
              Saturday: 10:00 AM - 4:00 PM<br>
              Sunday: Closed
            </p>
          </div>
        </div>

        <!-- Right: Contact Form -->
        <div class="contact-form-section">
          <h3 class="form-title">Send Us Your Inquiry</h3>
          <p class="form-subtitle">Fill out the form below and we'll get back to you shortly</p>

          <?php if ($show_success): ?>
            <div class="form-status success" id="success-message">
              <span>✓ Thank you! Your inquiry has been submitted successfully. We will contact you within 24 hours.</span>
              <button type="button" class="close-btn" onclick="closeSuccessMessage()">×</button>
            </div>
          <?php elseif (!empty($form_message)): ?>
            <div class="form-status <?php echo $form_status; ?>">
              ✗ <?php echo htmlspecialchars($form_message); ?>
            </div>
          <?php endif; ?>

          <form method="POST" action="">
            <!-- Name -->
            <div class="form-group">
              <label for="name">Full Name *</label>
              <input type="text" id="name" name="name" placeholder="Your full name" required value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>">
            </div>

            <!-- Row: Email & Phone -->
            <div class="form-row">
              <div class="form-group">
                <label for="email">Email Address *</label>
                <input type="email" id="email" name="email" placeholder="your@email.com" required value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>">
              </div>
              <div class="form-group">
                <label for="phone">Phone Number</label>
                <input type="tel" id="phone" name="phone" placeholder="+1 (555) 000-0000" value="<?php echo isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : ''; ?>">
              </div>
            </div>

            <!-- Row: Subject & Property Type -->
            <div class="form-row">
              <div class="form-group">
                <label for="subject">Subject</label>
                <input type="text" id="subject" name="subject" placeholder="What is this about?" value="<?php echo isset($_POST['subject']) ? htmlspecialchars($_POST['subject']) : ''; ?>">
              </div>
              <div class="form-group">
                <label for="property_type">Property Type</label>
                <select id="property_type" name="property_type">
                  <option value="">Select property type</option>
                  <option value="Residential" <?php echo (isset($_POST['property_type']) && $_POST['property_type'] == 'Residential') ? 'selected' : ''; ?>>Residential</option>
                  <option value="Commercial" <?php echo (isset($_POST['property_type']) && $_POST['property_type'] == 'Commercial') ? 'selected' : ''; ?>>Commercial</option>
                  <option value="Apartment" <?php echo (isset($_POST['property_type']) && $_POST['property_type'] == 'Apartment') ? 'selected' : ''; ?>>Apartment</option>
                  <option value="Villa" <?php echo (isset($_POST['property_type']) && $_POST['property_type'] == 'Villa') ? 'selected' : ''; ?>>Villa</option>
                  <option value="Land" <?php echo (isset($_POST['property_type']) && $_POST['property_type'] == 'Land') ? 'selected' : ''; ?>>Land</option>
                  <option value="Other" <?php echo (isset($_POST['property_type']) && $_POST['property_type'] == 'Other') ? 'selected' : ''; ?>>Other</option>
                </select>
              </div>
            </div>

            <!-- Message -->
            <div class="form-group">
              <label for="message">Message *</label>
              <textarea id="message" name="message" placeholder="Tell us more about your inquiry..." required><?php echo isset($_POST['message']) ? htmlspecialchars($_POST['message']) : ''; ?></textarea>
            </div>

            <!-- Submit Button -->
            <button type="submit" class="submit-btn">
              <i class="fas fa-paper-plane"></i> Send Inquiry
            </button>
          </form>
        </div>
      </div>
    </div>
  </section>

  <?php include 'footer.php'; ?>
  
  <!-- Scroll To Top -->
  <a href="#" class="scrollToTop scroll-btn"><i class="far fa-arrow-up"></i></a>

  <!-- Scripts -->
  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <script src="assets/js/main.js"></script>
</body>

</html>


