<?php
require_once 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || empty($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Get user info from session
$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'] ?? 'User';
$user_role = $_SESSION['user_role'] ?? 'customer';
$user_email = $_SESSION['user_email'] ?? '';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Dashboard - Real Estate</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <style>
    .dashboard-container {
      min-height: calc(100vh - 200px);
      padding: 40px 20px;
      background: linear-gradient(135deg, #f8f9fa 0%, #f0f1f5 100%);
    }

    .dashboard-header {
      margin-bottom: 40px;
    }

    .dashboard-header h1 {
      font-size: 36px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 10px;
      font-family: 'Playfair Display', serif;
    }

    .dashboard-header p {
      font-size: 16px;
      color: #666;
    }

    .dashboard-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
      gap: 30px;
      margin-bottom: 40px;
    }

    .card {
      background: white;
      border-radius: 10px;
      padding: 30px;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
      transition: all 0.3s ease;
    }

    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.12);
    }

    .card-icon {
      font-size: 40px;
      color: #667eea;
      margin-bottom: 15px;
    }

    .card h3 {
      font-size: 20px;
      font-weight: 600;
      color: #1a1a1a;
      margin-bottom: 10px;
    }

    .card p {
      color: #999;
      font-size: 14px;
      margin-bottom: 20px;
      line-height: 1.6;
    }

    .card-link {
      display: inline-block;
      color: #667eea;
      text-decoration: none;
      font-weight: 600;
      font-size: 13px;
      transition: color 0.3s ease;
    }

    .card-link:hover {
      color: #764ba2;
    }

    .card-link i {
      margin-left: 5px;
    }

    .profile-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
    }

    .profile-card .card-icon {
      color: white;
      font-size: 50px;
    }

    .profile-card h3 {
      color: white;
    }

    .profile-info {
      background: rgba(255, 255, 255, 0.1);
      padding: 15px;
      border-radius: 5px;
      margin: 15px 0;
      font-size: 14px;
    }

    .profile-info strong {
      display: block;
      opacity: 0.8;
      font-size: 12px;
      margin-bottom: 5px;
    }

    .profile-card .card-link {
      color: white;
      opacity: 0.9;
    }

    .profile-card .card-link:hover {
      opacity: 1;
    }

    .dashboard-section {
      margin-bottom: 50px;
    }

    .section-title {
      font-size: 24px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 25px;
      font-family: 'Playfair Display', serif;
      border-bottom: 3px solid #667eea;
      padding-bottom: 15px;
      display: inline-block;
    }

    .empty-state {
      text-align: center;
      padding: 60px 20px;
      background: white;
      border-radius: 10px;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    }

    .empty-state i {
      font-size: 60px;
      color: #ddd;
      margin-bottom: 20px;
    }

    .empty-state h3 {
      color: #1a1a1a;
      margin-bottom: 10px;
    }

    .empty-state p {
      color: #999;
      margin-bottom: 20px;
    }

    .btn-primary {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      padding: 10px 25px;
      border-radius: 5px;
      text-decoration: none;
      cursor: pointer;
      transition: all 0.3s ease;
      display: inline-block;
      font-weight: 600;
      font-size: 13px;
    }

    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
    }

    .welcome-banner {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 30px;
      border-radius: 10px;
      margin-bottom: 40px;
      box-shadow: 0 10px 30px rgba(102, 126, 234, 0.2);
    }

    .welcome-banner h2 {
      font-size: 28px;
      margin-bottom: 10px;
      font-family: 'Playfair Display', serif;
    }

    .welcome-banner p {
      opacity: 0.9;
      margin-bottom: 20px;
    }

    .quick-actions {
      display: flex;
      gap: 15px;
      flex-wrap: wrap;
    }

    .quick-actions a {
      background: white;
      color: #667eea;
      padding: 10px 20px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: 600;
      font-size: 13px;
      transition: all 0.3s ease;
    }

    .quick-actions a:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    @media (max-width: 768px) {
      .dashboard-container {
        padding: 20px 15px;
      }

      .dashboard-header h1 {
        font-size: 28px;
      }

      .dashboard-grid {
        grid-template-columns: 1fr;
        gap: 20px;
      }

      .welcome-banner {
        padding: 20px;
      }

      .welcome-banner h2 {
        font-size: 22px;
      }

      .quick-actions {
        gap: 10px;
      }

      .quick-actions a {
        padding: 8px 15px;
        font-size: 12px;
      }
    }
  </style>
</head>

<body>
  <div class="preloader">
    <button class="vs-btn preloaderCls">Cancel Preloader</button>
    <div class="preloader-inner">
      <img src="assets/img/logo.png" alt="Zemaraim">
      <span class="loader"></span>
    </div>
  </div>

  <?php include 'header.php'; ?>

  <div class="dashboard-container">
    <div style="max-width: 1200px; margin: 0 auto;">
      
      <div class="welcome-banner">
        <h2>Welcome, <?php echo htmlspecialchars($user_name); ?>! 👋</h2>
        <p>You're logged in as a <?php echo ucfirst($user_role); ?>. Here's your dashboard where you can manage your account and explore real estate opportunities.</p>
        <div class="quick-actions">
          <a href="properties.php"><i class="fas fa-home"></i> Browse Properties</a>
          <a href="appointment.php"><i class="fas fa-calendar"></i> My Appointments</a>
          <a href="#"><i class="fas fa-heart"></i> Favorites</a>
          <a href="logout.php" style="background: rgba(255,255,255,0.2); border: 1px solid white;"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
      </div>

      <div class="dashboard-header" style="margin-top: 40px;">
        <h1>Dashboard</h1>
        <p>Manage your real estate activities and preferences</p>
      </div>

      <div class="dashboard-grid">
        <div class="card profile-card">
          <div class="card-icon">
            <i class="fas fa-user-circle"></i>
          </div>
          <h3>My Profile</h3>
          <div class="profile-info">
            <strong>Name</strong>
            <?php echo htmlspecialchars($user_name); ?>
          </div>
          <div class="profile-info">
            <strong>Email</strong>
            <?php echo htmlspecialchars($user_email); ?>
          </div>
          <div class="profile-info">
            <strong>Role</strong>
            <?php echo ucfirst($user_role); ?>
          </div>
          <a href="#" class="card-link">Edit Profile <i class="fas fa-arrow-right"></i></a>
        </div>

        <div class="card">
          <div class="card-icon">
            <i class="fas fa-home"></i>
          </div>
          <h3>My Properties</h3>
          <p>View and manage your property listings or saved favorites.</p>
          <a href="properties.php" class="card-link">View Properties <i class="fas fa-arrow-right"></i></a>
        </div>

        <div class="card">
          <div class="card-icon">
            <i class="fas fa-calendar-alt"></i>
          </div>
          <h3>Appointments</h3>
          <p>Schedule and manage your property viewing appointments.</p>
          <a href="appointment.php" class="card-link">Manage Appointments <i class="fas fa-arrow-right"></i></a>
        </div>

        <div class="card">
          <div class="card-icon">
            <i class="fas fa-heart"></i>
          </div>
          <h3>Saved Favorites</h3>
          <p>Keep track of properties you're interested in.</p>
          <a href="#" class="card-link">View Favorites <i class="fas fa-arrow-right"></i></a>
        </div>

        <div class="card">
          <div class="card-icon">
            <i class="fas fa-comments"></i>
          </div>
          <h3>Messages</h3>
          <p>Communicate with brokers and agents about properties.</p>
          <a href="#" class="card-link">Check Messages <i class="fas fa-arrow-right"></i></a>
        </div>

        <div class="card">
          <div class="card-icon">
            <i class="fas fa-cog"></i>
          </div>
          <h3>Settings</h3>
          <p>Update your account settings and preferences.</p>
          <a href="#" class="card-link">Go to Settings <i class="fas fa-arrow-right"></i></a>
        </div>
      </div>

      <div class="dashboard-section">
        <h2 class="section-title">Recent Activity</h2>
        <div class="empty-state">
          <i class="fas fa-inbox"></i>
          <h3>No Recent Activity</h3>
          <p>Your recent activities will appear here.</p>
        </div>
      </div>

    </div>
  </div>

  <?php include 'footer.php'; ?>

  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <script src="assets/js/main.js"></script>
</body>

</html>
