<?php
/**
 * Agent Dashboard Removed
 * This role has been disabled
 */
header('Location: ../index.php');
exit;
?>
        .nav-header { background: white; padding: 20px; box-shadow: 0 2px 5px rgba(0,0,0,0.08); display: flex; justify-content: space-between; align-items: center; }
        .nav-header h1 { font-size: 24px; color: #667eea; }
        .user-menu { display: flex; align-items: center; gap: 20px; }
        .user-menu .avatar { width: 40px; height: 40px; border-radius: 50%; background: #667eea; color: white; display: flex; align-items: center; justify-content: center; }
        .logout-btn { background: #dc3545; color: white; border: none; padding: 8px 16px; border-radius: 5px; cursor: pointer; text-decoration: none; }
        .container { max-width: 1200px; margin: 0 auto; padding: 40px 20px; }
        h2 { font-size: 24px; color: #333; margin-bottom: 20px; }
        .stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 40px; }
        .stat-card { background: white; padding: 25px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-left: 4px solid #667eea; text-align: center; }
        .stat-card h3 { font-size: 12px; color: #999; text-transform: uppercase; margin-bottom: 10px; }
        .stat-card .number { font-size: 32px; font-weight: 700; color: #333; }
        .panel { background: white; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.08); padding: 25px; margin-bottom: 30px; }
        .btn { padding: 10px 20px; background: #667eea; color: white; border: none; border-radius: 5px; cursor: pointer; text-decoration: none; display: inline-block; }
        .btn:hover { background: #764ba2; }
        .btn-secondary { background: #999; }
        .table-responsive { overflow-x: auto; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #e0e0e0; }
        th { background: #f8f9fa; font-weight: 600; color: #333; }
        tr:hover { background: #f8f9fa; }
        .badge { padding: 4px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; }
        .badge-success { background: #d4edda; color: #155724; }
        .badge-warning { background: #fff3cd; color: #856404; }
        .badge-info { background: #d1ecf1; color: #0c5460; }
    </style>
</head>
<body>

    <!-- Header -->
    <div class="nav-header">
        <h1>🏢 Agent Dashboard</h1>
        <div class="user-menu">
            <span><?php echo htmlspecialchars($agent_name); ?></span>
            <div class="avatar"><?php echo strtoupper(substr($agent_name, 0, 1)); ?></div>
            <a href="../logout.php" class="logout-btn">Logout</a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container">

        <!-- Statistics -->
        <h2>📊 Your Performance</h2>
        <div class="stats-grid">
            <div class="stat-card">
                <h3>🏠 Total Properties</h3>
                <div class="number"><?php echo $stats['total_properties']; ?></div>
            </div>
            <div class="stat-card">
                <h3>💼 Active Inquiries</h3>
                <div class="number"><?php echo $stats['active_inquiries']; ?></div>
            </div>
            <div class="stat-card">
                <h3>✅ Completed Sales</h3>
                <div class="number"><?php echo $stats['completed_sales']; ?></div>
            </div>
            <div class="stat-card">
                <h3>💰 Commission Earned</h3>
                <div class="number" style="font-size: 24px;"><?php echo $stats['commission_earned']; ?></div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="panel">
            <h2>⚡ Quick Actions</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 10px;">
                <a href="#" class="btn">Add New Property</a>
                <a href="#" class="btn">View Inquiries</a>
                <a href="#" class="btn">Schedule Showing</a>
                <a href="#" class="btn">View Reports</a>
            </div>
        </div>

        <!-- Recent Properties -->
        <div class="panel">
            <h2>📋 My Recent Properties</h2>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Property Name</th>
                            <th>Location</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Luxury Modern Apartment</td>
                            <td>New York, NY</td>
                            <td>$2,500,000</td>
                            <td><span class="badge badge-success">Active</span></td>
                            <td><a href="#" class="btn" style="padding: 5px 10px; font-size: 12px;">Edit</a></td>
                        </tr>
                        <tr>
                            <td>Elegant Villa with Pool</td>
                            <td>Miami, FL</td>
                            <td>$3,200,000</td>
                            <td><span class="badge badge-warning">Pending</span></td>
                            <td><a href="#" class="btn" style="padding: 5px 10px; font-size: 12px;">Edit</a></td>
                        </tr>
                        <tr>
                            <td>Cozy Downtown Studio</td>
                            <td>Chicago, IL</td>
                            <td>$450,000</td>
                            <td><span class="badge badge-info">Under Offer</span></td>
                            <td><a href="#" class="btn" style="padding: 5px 10px; font-size: 12px;">Edit</a></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Recent Inquiries -->
        <div class="panel">
            <h2>💬 Recent Inquiries</h2>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Customer Name</th>
                            <th>Property</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>John Smith</td>
                            <td>Luxury Modern Apartment</td>
                            <td>Feb 10, 2026</td>
                            <td><span class="badge badge-success">Responded</span></td>
                            <td><a href="#" class="btn" style="padding: 5px 10px; font-size: 12px;">View</a></td>
                        </tr>
                        <tr>
                            <td>Sarah Johnson</td>
                            <td>Elegant Villa with Pool</td>
                            <td>Feb 11, 2026</td>
                            <td><span class="badge badge-warning">Pending</span></td>
                            <td><a href="#" class="btn" style="padding: 5px 10px; font-size: 12px;">View</a></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

    </div>

</body>
</html>
