<?php
session_start();
$_SESSION['user_id'] = 1;
$_SESSION['user_role'] = 'admin';

require_once 'config.php';

echo json_encode([
    'timestamp' => date('Y-m-d H:i:s'),
    'mysqli_defined' => isset($mysqli),
    'conn_defined' => isset($conn),
    'mysqli_ok' => !is_null($mysqli),
    'conn_ok' => !is_null($conn),
    'same_object' => $mysqli === $conn
], JSON_PRETTY_PRINT);

// Test get-properties
echo "\n\n=== Testing API ===\n";
$file = file_get_contents('http://localhost/Zemaraim/api/get-properties.php?page=1&per_page=5');
$data = json_decode($file, true);

if (isset($data['properties'])) {
    echo "✓ Properties fetched: " . count($data['properties']) . "\n";
    if (count($data['properties']) > 0) {
        echo "First property:\n";
        echo json_encode($data['properties'][0], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    }
} else {
    echo "✗ Error: ";
    echo json_encode($data, JSON_PRETTY_PRINT);
}
?>
