<?php
require_once 'config.php';

$is_logged_in = isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>My Favorites - Zemaraim</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <style>
    body { background: #f7f7f7; }
    .favorites-container { min-height: calc(100vh - 300px); }
    .favorites-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 40px 0; text-align: center; }
    .favorites-header h1 { font-size: 36px; font-weight: 700; margin: 0 0 10px 0; }
    .favorites-header p { font-size: 16px; opacity: 0.9; margin: 0; }
    
    .favorite-card { background: white; border-radius: 10px; overflow: hidden; box-shadow: 0 2px 15px rgba(0,0,0,0.08); transition: all 0.3s ease; display: flex; flex-direction: column; height: 100%; }
    .favorite-card:hover { transform: translateY(-5px); box-shadow: 0 10px 30px rgba(0,0,0,0.15); }
    .favorite-image { position: relative; overflow: hidden; height: 220px; background: #f0f0f0; }
    .favorite-image img { width: 100%; height: 100%; object-fit: cover; transition: transform 0.3s ease; }
    .favorite-card:hover .favorite-image img { transform: scale(1.1); }
    
    .favorite-content { padding: 20px; flex-grow: 1; display: flex; flex-direction: column; }
    .favorite-title { font-size: 18px; font-weight: 700; color: #1a1a1a; margin: 0 0 8px 0; }
    .favorite-address { color: #666; font-size: 13px; margin: 8px 0; }
    .favorite-meta { display: flex; gap: 15px; margin: 10px 0; font-size: 12px; color: #999; flex-wrap: wrap; }
    .favorite-meta i { color: #667eea; }
    .favorite-price { font-size: 20px; font-weight: 700; color: #667eea; margin: 10px 0; }
    .favorite-footer { display: flex; gap: 10px; margin-top: auto; }
    
    .view-btn, .remove-btn { flex: 1; padding: 10px; background: #f0f0f0; color: #667eea; text-decoration: none; text-align: center; border-radius: 5px; transition: all 0.3s ease; font-weight: 600; font-size: 12px; border: none; cursor: pointer; }
    .view-btn:hover { background: #667eea; color: white; text-decoration: none; }
    .remove-btn:hover { background: #ff4757; color: white; border-color: #ff4757; }
    
    .empty-favorites { text-align: center; padding: 80px 20px; }
    .empty-favorites i { font-size: 80px; color: #ddd; margin-bottom: 20px; display: block; }
    .empty-favorites h3 { color: #1a1a1a; margin-bottom: 10px; font-size: 24px; }
    .empty-favorites p { color: #999; margin-bottom: 30px; }
    .empty-btn { display: inline-block; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 12px 30px; border-radius: 5px; text-decoration: none; font-weight: 600; transition: all 0.3s ease; }
    .empty-btn:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(102,126,234,0.3); }

    @media (max-width: 992px) {
      .favorite-image { height: 180px; }
      .favorite-content { padding: 15px; }
      .favorites-header h1 { font-size: 28px; }
    }

    @media (max-width: 768px) {
      .favorite-image { height: 160px; }
      .favorite-content { padding: 12px; }
      .favorite-title { font-size: 16px; }
      .favorite-price { font-size: 18px; }
      .favorites-header h1 { font-size: 24px; }
      .favorites-header { padding: 30px 0; }
    }

    @media (max-width: 480px) {
      .favorite-image { height: 140px; }
      .favorite-content { padding: 10px; }
      .favorite-title { font-size: 14px; }
      .favorite-price { font-size: 16px; }
      .favorite-meta { font-size: 11px; gap: 8px; }
      .view-btn, .remove-btn { padding: 8px 10px; font-size: 11px; }
      .favorites-header h1 { font-size: 20px; }
      .favorites-header p { font-size: 14px; }
      .empty-btn { padding: 10px 20px; }
    }
  </style>
</head>

<body>
  <?php include 'header.php'; ?>

  <!-- Header -->
  <div class="favorites-header">
    <div class="container">
      <h1><i class="fas fa-heart"></i> My Favorite Properties</h1>
      <p>Your saved properties collection</p>
    </div>
  </div>

  <!-- Favorites Section -->
  <section class="vs-section-padding favorites-container">
    <div class="container">
      <div id="favorites-grid" class="row g-4"></div>
      
      <div id="empty-favorites" class="empty-favorites" style="display: none;">
        <i class="fas fa-heart-broken"></i>
        <h3>No Favorites Yet</h3>
        <p>You haven't added any properties to your favorites. Start exploring and save properties you love!</p>
        <a href="properties.php" class="empty-btn">
          <i class="fas fa-search"></i> Browse Properties
        </a>
      </div>
    </div>
  </section>

  <?php include 'footer.php'; ?>

  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/main.js"></script>

  <script>
    // Get favorites from localStorage
    function loadFavorites() {
      const favorites = JSON.parse(localStorage.getItem('favorites') || '[]');
      const grid = document.getElementById('favorites-grid');
      const emptyMsg = document.getElementById('empty-favorites');
      
      if (favorites.length === 0) {
        grid.innerHTML = '';
        emptyMsg.style.display = 'block';
        return;
      }

      emptyMsg.style.display = 'none';
      grid.innerHTML = '';

      // Fetch property data from server
      favorites.forEach(propId => {
        fetch(`api/get-property.php?id=${propId}`)
          .then(response => response.json())
          .then(data => {
            if (data.success) {
              const prop = data.property;
              const html = `
                <div class="col-md-6 col-lg-4">
                  <div class="favorite-card">
                    <div class="favorite-image">
                      <img src="${prop.image_url || 'assets/img/properties/properties-list-1.png'}" alt="${prop.title}">
                    </div>
                    <div class="favorite-content">
                      <h4 class="favorite-title">${prop.title}</h4>
                      <div class="favorite-address">
                        <i class="fas fa-map-marker-alt"></i>
                        ${prop.address}, ${prop.city}
                      </div>
                      <div class="favorite-meta">
                        <span><i class="fas fa-bed"></i> ${prop.bedrooms} Beds</span>
                        <span><i class="fas fa-bath"></i> ${prop.bathrooms} Baths</span>
                        <span><i class="fas fa-ruler-combined"></i> ${prop.area} sqft</span>
                      </div>
                      <div class="favorite-price">$${number_format(prop.price)}</div>
                      <div class="favorite-footer">
                        <a href="properties-details.php?id=${prop.id}" class="view-btn">
                          <i class="fas fa-eye"></i> View Details
                        </a>
                        <button class="remove-btn" onclick="removeFavorite(${prop.id})">
                          <i class="fas fa-trash"></i> Remove
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
              `;
              grid.insertAdjacentHTML('beforeend', html);
            }
          })
          .catch(error => console.log('Error loading property:', error));
      });
    }

    function removeFavorite(propId) {
      let favorites = JSON.parse(localStorage.getItem('favorites') || '[]');
      favorites = favorites.filter(id => id !== propId);
      localStorage.setItem('favorites', JSON.stringify(favorites));
      loadFavorites();
    }

    // Helper function for number formatting
    function number_format(num) {
      return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }

    // Load favorites on page load
    document.addEventListener('DOMContentLoaded', loadFavorites);
  </script>
</body>

</html>
