<?php
// Footer PHP - processed newsletter subscription here if needed
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['newsletter_email'])) {
    $email = filter_var($_POST['newsletter_email'], FILTER_SANITIZE_EMAIL);
    
    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // Check if email already subscribed
        $check_query = "SELECT * FROM newsletter_subscribers WHERE email = ?";
        $check_stmt = $conn->prepare($check_query);
        $check_stmt->bind_param("s", $email);
        $check_stmt->execute();
        $check_result = $check_stmt->get_result();
        
        if ($check_result->num_rows == 0) {
            // Insert new subscriber
            $insert_query = "INSERT INTO newsletter_subscribers (email, subscribed_at) VALUES (?, NOW())";
            $insert_stmt = $conn->prepare($insert_query);
            $insert_stmt->bind_param("s", $email);
            if ($insert_stmt->execute()) {
                $_SESSION['newsletter_success'] = "Thank you for subscribing to our newsletter!";
            } else {
                $_SESSION['newsletter_error'] = "Error subscribing. Please try again.";
            }
            $insert_stmt->close();
        } else {
            $_SESSION['newsletter_info'] = "This email is already subscribed.";
        }
        $check_stmt->close();
    } else {
        $_SESSION['newsletter_error'] = "Please enter a valid email address.";
    }
}
?>

<!--================================
    Footer Section
================================ -->
<footer class="footer-wrapper">
  <div class="footer-main">
    <div class="container">
      <div class="row">
        <!-- Column 1: About -->
        <div class="col-lg-3 col-md-6">
          <div class="footer-column">
            <h4 class="footer-title">About Us</h4>
            <div class="footer-logo">
              <img src="assets/img/logo_zem.png" alt="Zem Logo">
            </div>
            <p class="footer-about">
              Zemaraim is your trusted real estate partner, dedicated to helping you find your dream property and achieve your real estate goals with excellence and integrity.
            </p>
            <div class="social-links">
              <a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a>
              <a href="#" title="Twitter"><i class="fab fa-twitter"></i></a>
              <a href="#" title="LinkedIn"><i class="fab fa-linkedin-in"></i></a>
              <a href="#" title="Instagram"><i class="fab fa-instagram"></i></a>
            </div>
          </div>
        </div>

        <!-- Column 2: Quick Links -->
        <div class="col-lg-2 col-md-6">
          <div class="footer-column">
            <h4 class="footer-title">Quick Links</h4>
            <ul class="footer-list">
              <li><a href="index.php"><i class="fas fa-angle-right"></i> Home</a></li>
              <li><a href="properties.php"><i class="fas fa-angle-right"></i> Properties</a></li>
              <li><a href="agents.php"><i class="fas fa-angle-right"></i> Agents</a></li>
              <li><a href="service.php"><i class="fas fa-angle-right"></i> Services</a></li>
              <li><a href="blog.php"><i class="fas fa-angle-right"></i> Blog</a></li>
              <li><a href="about.php"><i class="fas fa-angle-right"></i> About Us</a></li>
            </ul>
          </div>
        </div>

        <!-- Column 3: Services -->
        <div class="col-lg-2 col-md-6">
          <div class="footer-column">
            <h4 class="footer-title">Services</h4>
            <ul class="footer-list">
              <li><a href="service.php"><i class="fas fa-angle-right"></i> Buy Property</a></li>
              <li><a href="service.php"><i class="fas fa-angle-right"></i> Sell Property</a></li>
              <li><a href="service.php"><i class="fas fa-angle-right"></i> Rent Property</a></li>
              <li><a href="service.php"><i class="fas fa-angle-right"></i> Property Valuation</a></li>
              <li><a href="service.php"><i class="fas fa-angle-right"></i> Legal Advice</a></li>
              <li><a href="service.php"><i class="fas fa-angle-right"></i> Mortgage Help</a></li>
            </ul>
          </div>
        </div>

        <!-- Column 4: Contact Info -->
        <div class="col-lg-2 col-md-6">
          <div class="footer-column">
            <h4 class="footer-title">Contact Info</h4>
            <div class="contact-item">
              <i class="fas fa-map-marker-alt"></i>
              <span>W7 Road Central Park<br>New York, USA</span>
            </div>
            <div class="contact-item">
              <i class="fas fa-phone-alt"></i>
              <a href="tel:+11234562228">+1 (123) 456-2228</a>
            </div>
            <div class="contact-item">
              <i class="fas fa-envelope"></i>
              <a href="mailto:info@zemaraim.com">info@zemaraim.com</a>
            </div>
          </div>
        </div>

        <!-- Column 5: Working Hours & Newsletter -->
        <div class="col-lg-3 col-md-6">
          <div class="footer-column">
            <h4 class="footer-title">Working Hours</h4>
            <div class="working-hours">
              <div class="hours-item">
                <span>Monday - Friday:</span>
                <span>09:00 AM - 05:00 PM</span>
              </div>
              <div class="hours-item">
                <span>Saturday:</span>
                <span>10:00 AM - 04:00 PM</span>
              </div>
              <div class="hours-item">
                <span>Sunday:</span>
                <span>Closed</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Footer Bottom -->
  <div class="footer-bottom">
    <div class="container">
      <div class="row align-items-center justify-content-between">
        <div class="col-lg-6 col-md-8">
          <p class="copyright-text">
            Copyright <i class="fal fa-copyright"></i> 2024 <a href="index.php">Zemaraim</a>. All Rights Reserved.
          </p>
        </div>
        <div class="col-lg-6 col-md-4 text-lg-end text-md-start">
          <div class="footer-links-bottom">
            <a href="#">Privacy Policy</a>
            <a href="#">Terms & Conditions</a>
            <a href="contact.php">Contact Us</a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Back to Top Button -->
  <a href="#" class="back-to-top scrollToTop" title="Back to Top"><i class="fas fa-arrow-up"></i></a>
</footer>

<style>
/* Footer Responsive Styles */
.footer-wrapper {
  background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
  color: #fff;
  padding: 20px 0 0;
  margin-top: 0px;
}

.footer-main {
  padding: 0px 0 0px;
  border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.footer-column {
  margin-bottom: 40px;
}

.footer-logo {
  margin-bottom: 20px;
}

.footer-logo img {
  max-height: 50px;
  margin-bottom: 15px;
  display: block;
}

.footer-about {
  font-size: 14px;
  line-height: 1.8;
  color: rgba(255, 255, 255, 0.7);
  margin-bottom: 25px;
}

.footer-title {
  font-size: 18px;
  font-weight: 700;
  color: #fff;
  margin-bottom: 25px;
  font-family: 'Playfair Display', serif;
  text-transform: uppercase;
  letter-spacing: 1px;
  position: relative;
  padding-bottom: 15px;
}

.footer-title::after {
  content: '';
  position: absolute;
  bottom: 0;
  left: 0;
  width: 40px;
  height: 3px;
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.footer-list {
  list-style: none;
  padding: 0;
  margin: 0;
}

.footer-list li {
  margin-bottom: 12px;
}

.footer-list a {
  color: rgba(255, 255, 255, 0.7);
  text-decoration: none;
  font-size: 14px;
  transition: all 0.3s ease;
  display: flex;
  align-items: center;
  gap: 8px;
}

.footer-list a:hover {
  color: #667eea;
  padding-left: 5px;
}

.contact-item {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  margin-bottom: 15px;
  font-size: 14px;
  color: rgba(255, 255, 255, 0.7);
}

.contact-item i {
  color: #667eea;
  font-size: 16px;
  margin-top: 3px;
  min-width: 20px;
}

.contact-item a {
  color: rgba(255, 255, 255, 0.7);
  text-decoration: none;
  transition: color 0.3s ease;
}

.contact-item a:hover {
  color: #667eea;
}

.working-hours {
  font-size: 14px;
  color: rgba(255, 255, 255, 0.7);
  line-height: 1.8;
}

.hours-item {
  display: flex;
  justify-content: space-between;
  margin-bottom: 8px;
  padding-bottom: 8px;
  border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.hours-item span:last-child {
  color: #667eea;
  font-weight: 600;
}

.newsletter-form {
  display: flex;
  gap: 8px;
  margin-bottom: 20px;
}

.newsletter-form input {
  flex: 1;
  padding: 12px 15px;
  border: 1px solid rgba(255, 255, 255, 0.2);
  border-radius: 5px;
  background: rgba(255, 255, 255, 0.1);
  color: #fff;
  font-size: 14px;
  font-family: 'Poppins', sans-serif;
  transition: all 0.3s ease;
}

.newsletter-form input::placeholder {
  color: rgba(255, 255, 255, 0.5);
}

.newsletter-form input:focus {
  outline: none;
  border-color: #667eea;
  background: rgba(102, 126, 234, 0.1);
}

.newsletter-form button {
  padding: 12px 20px;
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  border: none;
  border-radius: 5px;
  color: #fff;
  cursor: pointer;
  font-weight: 600;
  transition: all 0.3s ease;
}

.newsletter-form button:hover {
  transform: translateY(-2px);
  box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
}

.newsletter-text {
  font-size: 12px;
  color: rgba(255, 255, 255, 0.6);
  line-height: 1.6;
}

.social-links {
  display: flex;
  gap: 12px;
  margin-top: 20px;
}

.social-links a {
  width: 40px;
  height: 40px;
  border-radius: 50%;
  background: rgba(255, 255, 255, 0.1);
  border: 1px solid rgba(255, 255, 255, 0.2);
  display: flex;
  align-items: center;
  justify-content: center;
  color: #fff;
  text-decoration: none;
  transition: all 0.3s ease;
  font-size: 14px;
}

.social-links a:hover {
  background: #667eea;
  border-color: #667eea;
  transform: translateY(-3px);
}

.footer-bottom {
  background: rgba(0, 0, 0, 0.3);
  padding: 25px 0;
  border-top: 1px solid rgba(255, 255, 255, 0.1);
}

.copyright-text {
  font-size: 13px;
  color: rgba(255, 255, 255, 0.6);
  margin: 0;
}

.copyright-text a {
  color: #667eea;
  text-decoration: none;
  transition: color 0.3s ease;
}

.copyright-text a:hover {
  color: #fff;
}

.footer-links-bottom {
  display: flex;
  gap: 25px;
  flex-wrap: wrap;
}

.footer-links-bottom a {
  color: rgba(255, 255, 255, 0.6);
  text-decoration: none;
  font-size: 13px;
  transition: color 0.3s ease;
}

.footer-links-bottom a:hover {
  color: #667eea;
}

.back-to-top {
  display: none;
  position: fixed;
  bottom: 30px;
  right: 30px;
  align-items: center;
  justify-content: center;
  width: 40px;
  height: 40px;
  border-radius: 50%;
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  color: #fff;
  text-decoration: none;
  transition: all 0.3s ease;
  cursor: pointer;
  z-index: 999;
}

.back-to-top:hover {
  transform: translateY(-3px);
  box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
}

@media (max-width: 768px) {
  .footer-wrapper {
    padding: 40px 0 0;
    margin-top: 40px;
  }

  .footer-main {
    padding: 40px 0 30px;
  }

  .footer-column {
    margin-bottom: 30px;
  }

  .footer-title {
    font-size: 16px;
    margin-bottom: 20px;
    padding-bottom: 12px;
  }

  .footer-title::after {
    width: 30px;
    height: 2px;
  }

  .newsletter-form {
    flex-direction: column;
  }

  .newsletter-form button {
    width: 100%;
  }

  .footer-links-bottom {
    gap: 15px;
  }
}

@media (max-width: 480px) {
  .footer-wrapper {
    padding: 30px 0 0;
    margin-top: 30px;
  }

  .footer-main {
    padding: 0px 0 20px;
  }

  .footer-column {
    margin-bottom: 25px;
  }

  .footer-title {
    font-size: 14px;
    margin-bottom: 18px;
    padding-bottom: 10px;
  }

  .footer-about {
    font-size: 13px;
    margin-bottom: 20px;
  }

  .footer-list a {
    font-size: 13px;
    margin-bottom: 10px;
  }

  .contact-item {
    font-size: 13px;
    margin-bottom: 12px;
  }

  .working-hours {
    font-size: 13px;
  }

  .hours-item {
    margin-bottom: 6px;
    padding-bottom: 6px;
  }

  .newsletter-form input {
    padding: 10px 12px;
    font-size: 13px;
  }

  .newsletter-form button {
    padding: 10px 15px;
    font-size: 13px;
  }

  .social-links {
    gap: 10px;
    margin-top: 15px;
  }

  .social-links a {
    width: 36px;
    height: 36px;
    font-size: 12px;
  }

  .footer-bottom {
    padding: 20px 0;
  }

  .copyright-text {
    font-size: 12px;
    text-align: center;
  }

  .footer-links-bottom {
    gap: 12px;
    justify-content: center;
  }

  .footer-links-bottom a {
    font-size: 12px;
  }
}
</style>
