<?php
require_once 'config.php';

// Check if user already logged in
if ($is_logged_in) {
    header("Location: dashboards/customer-dashboard.php");
    exit();
}

$success = $_GET['success'] ?? '';
$info = $_GET['info'] ?? '';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Forgot Password - Real Estate</title>
  <meta name="author" content="vecuro">
  <meta name="description" content="Zemaraim HTML Template">
  <meta name="keywords" content="Zemaraim HTML Template">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <style>
    .password-reset-section {
      min-height: 100vh;
      display: flex;
      align-items: center;
      background: #f8f9fa;
      padding: 40px 20px;
    }

    .password-reset-container {
      width: 100%;
      max-width: 1000px;
      margin: 0 auto;
    }

    .password-reset-grid {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 40px;
      align-items: center;
      background: white;
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
    }

    .reset-image {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      padding: 60px 40px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      min-height: 809px;
      color: white;
      text-align: center;
    }

    .reset-image-content h2 {
      font-size: 32px;
      font-weight: 700;
      margin-bottom: 20px;
      font-family: 'Playfair Display', serif;
    }

    .reset-image-content p {
      font-size: 16px;
      line-height: 1.6;
      margin-bottom: 30px;
      opacity: 0.9;
    }

    .reset-icon {
      font-size: 60px;
      margin-bottom: 20px;
      opacity: 0.8;
    }

    .reset-steps {
      list-style: none;
      padding: 0;
      text-align: left;
      display: inline-block;
    }

    .reset-steps li {
      margin-bottom: 15px;
      font-size: 14px;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .reset-steps i {
      font-size: 16px;
      background: rgba(255, 255, 255, 0.2);
      width: 30px;
      height: 30px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .reset-form {
      padding: 50px 40px;
    }

    .reset-header {
      margin-bottom: 30px;
    }

    .reset-header h1 {
      font-size: 28px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 8px;
      font-family: 'Playfair Display', serif;
    }

    .reset-header p {
      color: #999;
      font-size: 14px;
    }

    .back-link {
      display: inline-block;
      margin-bottom: 20px;
      color: #667eea;
      text-decoration: none;
      font-size: 13px;
      transition: color 0.3s ease;
    }

    .back-link:hover {
      color: #764ba2;
    }

    .back-link i {
      margin-right: 5px;
    }

    .form-group {
      margin-bottom: 20px;
    }

    .form-group label {
      display: block;
      margin-bottom: 8px;
      color: #1a1a1a;
      font-weight: 600;
      font-size: 14px;
    }

    .form-group input,
    .form-group select {
      width: 100%;
      padding: 12px 15px;
      border: 1px solid #e0e0e0;
      border-radius: 5px;
      font-size: 14px;
      transition: all 0.3s ease;
      font-family: 'Poppins', sans-serif;
    }

    .form-group input:focus,
    .form-group select:focus {
      outline: none;
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .form-description {
      font-size: 13px;
      color: #999;
      margin-top: 8px;
    }

    .reset-btn {
      width: 100%;
      padding: 12px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      border-radius: 5px;
      font-weight: 600;
      font-size: 14px;
      cursor: pointer;
      transition: all 0.3s ease;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      font-family: 'Poppins', sans-serif;
    }

    .reset-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
    }

    .reset-btn:active {
      transform: translateY(0);
    }

    .reset-btn:disabled {
      opacity: 0.6;
      cursor: not-allowed;
      transform: none;
    }

    .alert {
      padding: 12px 15px;
      border-radius: 5px;
      margin-bottom: 20px;
      font-size: 14px;
    }

    .alert-danger {
      background: rgba(255, 71, 87, 0.1);
      color: #ff4757;
      border: 1px solid rgba(255, 71, 87, 0.2);
    }

    .alert-success {
      background: rgba(46, 213, 115, 0.1);
      color: #2ed573;
      border: 1px solid rgba(46, 213, 115, 0.2);
    }

    .alert-info {
      background: rgba(52, 152, 219, 0.1);
      color: #3498db;
      border: 1px solid rgba(52, 152, 219, 0.2);
    }

    .auth-footer {
      text-align: center;
      color: #666;
      font-size: 14px;
      margin-top: 20px;
    }

    .auth-footer a {
      color: #667eea;
      text-decoration: none;
      font-weight: 600;
      transition: color 0.3s ease;
    }

    .auth-footer a:hover {
      color: #764ba2;
    }

    .loading-spinner {
      display: none;
      width: 20px;
      height: 20px;
      border: 2px solid rgba(255, 255, 255, 0.3);
      border-top-color: white;
      border-radius: 50%;
      animation: spin 0.8s linear infinite;
      margin-left: 10px;
      vertical-align: middle;
    }

    @keyframes spin {
      to { transform: rotate(360deg); }
    }

    @media (max-width: 992px) {
      .password-reset-grid {
        grid-template-columns: 1fr;
        gap: 0;
      }

      .reset-image {
        min-height: auto;
        padding: 40px 30px;
      }

      .reset-image-content h2 {
        font-size: 24px;
      }

      .reset-form {
        padding: 40px 30px;
      }

      .reset-header h1 {
        font-size: 24px;
      }
    }

    @media (max-width: 768px) {
      .password-reset-section {
        padding: 20px 15px;
      }

      .password-reset-grid {
        border-radius: 8px;
      }

      .reset-image {
        padding: 30px 25px;
      }

      .reset-image-content h2 {
        font-size: 22px;
      }

      .reset-image-content p {
        font-size: 14px;
      }

      .reset-form {
        padding: 30px 25px;
      }

      .reset-header h1 {
        font-size: 22px;
      }

      .form-group input,
      .form-group select {
        padding: 10px 12px;
        font-size: 13px;
      }
    }

    @media (max-width: 480px) {
      .password-reset-section {
        padding: 15px;
      }

      .reset-image {
        display: none;
      }

      .reset-form {
        padding: 20px 15px;
      }

      .reset-header h1 {
        font-size: 20px;
      }

      .form-group input,
      .form-group select {
        padding: 10px;
        font-size: 12px;
      }

      .reset-btn {
        padding: 10px;
        font-size: 12px;
      }

      .reset-icon {
        font-size: 40px;
      }
    }
  </style>
</head>

<body>
  <!-- header -->
  <?php include 'header.php'; ?>
  
  <section class="password-reset-section">
    <div class="password-reset-container">
      <div class="password-reset-grid">
        
        <div class="reset-image">
          <div class="reset-image-content">
            <div class="reset-icon">🔐</div>
            <h2>Account Recovery</h2>
            <p>Secure Password Reset</p>
            <ul class="reset-steps">
              <li><i class="fas fa-envelope"></i> Enter your registered email</li>
              <li><i class="fas fa-code"></i> Receive OTP verification code</li>
              <li><i class="fas fa-lock"></i> Set your new password</li>
              <li><i class="fas fa-check-circle"></i> Regain access to your account</li>
            </ul>
          </div>
        </div>

        <div class="reset-form">
          <a href="login.php" class="back-link">
            <i class="fas fa-arrow-left"></i> Back to Login
          </a>

          <div class="reset-header">
            <h1>Forgot Password?</h1>
            <p>Enter your email to reset your password</p>
          </div>

          <?php if ($success): ?>
            <div class="alert alert-success">
              <i class="fas fa-check-circle"></i> <?php echo htmlspecialchars($success); ?>
            </div>
          <?php endif; ?>

          <?php if ($info): ?>
            <div class="alert alert-info">
              <i class="fas fa-info-circle"></i> <?php echo htmlspecialchars($info); ?>
            </div>
          <?php endif; ?>

          <form method="POST" action="process-forgot-password.php" id="forgotPasswordForm">
            <div class="form-group">
              <label for="email">Email Address</label>
              <input 
                type="email" 
                id="email" 
                name="email" 
                placeholder="Enter your registered email" 
                required
                autocomplete="email"
              >
              <div class="form-description">
                <i class="fas fa-info-circle"></i> We'll send a verification code to this email
              </div>
            </div>

            <button type="submit" class="reset-btn" id="submitBtn">
              <span>Send Reset Code</span>
              <span class="loading-spinner" id="spinner"></span>
            </button>
          </form>

          <div class="auth-footer">
            Remember your password? <a href="login.php">Login here</a>
          </div>

          <div class="auth-footer">
            Don't have an account? <a href="register.php">Register here</a>
          </div>
        </div>

      </div>
    </div>
  </section>

  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <script src="assets/js/main.js"></script>

  <script>
    document.getElementById('forgotPasswordForm').addEventListener('submit', function(e) {
      const submitBtn = document.getElementById('submitBtn');
      const spinner = document.getElementById('spinner');
      const emailInput = document.getElementById('email');
      
      // Validate email
      if (!emailInput.value || !emailInput.checkValidity()) {
        e.preventDefault();
        alert('Please enter a valid email address');
        return false;
      }

      // Show loading spinner
      submitBtn.disabled = true;
      spinner.style.display = 'inline-block';
    });
  </script>
</body>

</html>
<?php include 'footer.php'; ?>
