<?php
require_once 'config.php';

// Check if user is logged in
$is_logged_in = isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
$user_name = isset($_SESSION['user_name']) ? $_SESSION['user_name'] : '';
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : '';
$dashboard_url = 'dashboard.php';

if ($is_logged_in) {
    switch ($user_role) {
        case 'admin':
            $dashboard_url = 'dashboards/admin-dashboard.php';
            break;
        case 'broker':
            $dashboard_url = 'dashboards/broker-dashboard.php';
            break;
        case 'staff':
            $dashboard_url = 'dashboards/staff-dashboard.php';
            break;
        case 'agent':
            $dashboard_url = 'dashboards/agent-dashboard.php';
            break;
        case 'customer':
            $dashboard_url = 'dashboards/customer-dashboard.php';
            break;
    }
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Real Estate</title>
  <meta name="author" content="vecuro">
  <meta name="description" content="Zemaraim HTML Template">
  <meta name="keywords" content="Zemaraim HTML Template">
  <meta name="robots" content="INDEX,FOLLOW">
  <!-- Mobile Specific Metas -->
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <!-- Favicons -->
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <!--==============================
	  Google Fonts
	============================== -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <!--==============================
	    All CSS File
	============================== -->
  <!-- Bootstrap -->
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <!-- Fontawesome Icon -->
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <!-- Magnific Popup -->
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <!-- Slick Slider -->
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <!-- Theme Custom CSS -->
  <link rel="stylesheet" href="assets/css/style.css">
</head>

<body>
  <!--[if lte IE 9]>
    	<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
  <![endif]-->

  <!--==============================
     Preloader
    ==============================-->
  <div class="preloader">
    <button class="vs-btn preloaderCls">Cancel Preloader </button>
    <div class="preloader-inner">
      <img src="assets/img/logo.png" alt="Zemaraim">
      <span class="loader"></span>
    </div>
  </div>
  
  <!--==============================
    Header Area - Responsive Design
    ==============================-->
  <header class="vs-header header-responsive">
    
    <!-- TOP HEADER: WELCOME MESSAGE (Hidden on Mobile) -->
    <div class="header-welcome d-none d-md-block">
      <div class="container">
        <div class="row align-items-center justify-content-between">
          <div class="col-auto">
            <p class="welcome-text">
              <i class="fas fa-heart"></i> Welcome to Zemaraim - Your Premium Real Estate Platform
            </p>
          </div>
          <div class="col-auto">
            <div class="welcome-social">
              <a href="#"><i class="fab fa-facebook-f"></i></a>
              <a href="#"><i class="fab fa-twitter"></i></a>
              <a href="#"><i class="fab fa-linkedin-in"></i></a>
              <a href="#"><i class="fab fa-pinterest-p"></i></a>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- MIDDLE HEADER: CONTACT STRIP (Hidden on Mobile) -->
    <div class="header-contact d-none d-md-block">
      <div class="container">
        <div class="row align-items-center justify-content-between">
          <div class="col-auto">
            <div class="contact-info">
              <span class="contact-item">
                <i class="fas fa-map-marker-alt"></i> W7 Road Central Park, New York
              </span>
              <span class="contact-item">
                <i class="far fa-envelope"></i> <a href="mailto:info@example.com">info@example.com</a>
              </span>
              <span class="contact-item">
                <i class="far fa-phone-alt"></i> <a href="tel:++11234562228">+1 123 456 2228</a>
              </span>
            </div>
          </div>
          <div class="col-auto">
            <div class="auth-buttons">
              <?php if ($is_logged_in): ?>
                <div class="user-profile-dropdown" style="position: relative; display: inline-block;">
                  <button class="user-profile-btn" style="
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    color: white;
                    border: none;
                    padding: 10px 20px;
                    border-radius: 5px;
                    cursor: pointer;
                    font-weight: 600;
                    font-size: 14px;
                    display: flex;
                    align-items: center;
                    gap: 8px;
                    transition: all 0.3s ease;
                  ">
                    <i class="fas fa-user-circle"></i>
                    <span><?php echo htmlspecialchars(explode(' ', $user_name)[0]); ?></span>
                    <i class="fas fa-chevron-down" style="font-size: 12px;"></i>
                  </button>

                  <div class="user-profile-submenu" style="
                    position: absolute;
                    top: 100%;
                    right: 0;
                    background: white;
                    border: 1px solid #e0e0e0;
                    border-radius: 8px;
                    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
                    min-width: 200px;
                    opacity: 0;
                    visibility: hidden;
                    transform: translateY(-10px);
                    transition: all 0.3s ease;
                    z-index: 1000;
                    margin-top: 5px;
                  ">
                    <div style="padding: 15px 0; border-bottom: 1px solid #f0f0f0;">
                      <p style="margin: 0; padding: 0 15px; color: #1a1a1a; font-weight: 600; font-size: 14px;">
                        <?php echo htmlspecialchars($user_name); ?>
                      </p>
                      <p style="margin: 5px 0 0 0; padding: 0 15px; color: #999; font-size: 12px;">
                        <?php echo ucfirst($user_role); ?> Account
                      </p>
                    </div>

                    <a href="<?php echo $dashboard_url; ?>" style="
                      display: flex;
                      align-items: center;
                      gap: 10px;
                      padding: 12px 15px;
                      color: #1a1a1a;
                      text-decoration: none;
                      transition: all 0.3s ease;
                      border-bottom: 1px solid #f0f0f0;
                    " onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#667eea';" onmouseout="this.style.backgroundColor='transparent'; this.style.color='#1a1a1a';">
                      <i class="fas fa-tachometer-alt" style="color: #667eea; min-width: 16px;"></i>
                      <span>Dashboard</span>
                    </a>

                    
                    <a href="logout.php" style="
                      display: flex;
                      align-items: center;
                      gap: 10px;
                      padding: 12px 15px;
                      color: #ff4757;
                      text-decoration: none;
                      transition: all 0.3s ease;
                    " onmouseover="this.style.backgroundColor='#fff5f7'; this.style.color='#ff4757';" onmouseout="this.style.backgroundColor='transparent'; this.style.color='#ff4757';">
                      <i class="fas fa-sign-out-alt" style="color: #ff4757; min-width: 16px;"></i>
                      <span>Logout</span>
                    </a>
                  </div>
                </div>

                <style>
                  .user-profile-dropdown:hover .user-profile-submenu {
                    opacity: 1 !important;
                    visibility: visible !important;
                    transform: translateY(0) !important;
                  }

                  .user-profile-btn:hover {
                    transform: translateY(-2px);
                    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
                  }

                  @media (max-width: 768px) {
                    .user-profile-dropdown {
                      position: relative !important;
                    }

                    .user-profile-submenu {
                      position: absolute !important;
                      top: 100% !important;
                      right: 0 !important;
                      min-width: 180px !important;
                    }

                    .user-profile-btn {
                      padding: 8px 15px !important;
                      font-size: 13px !important;
                    }

                    .user-profile-submenu a,
                    .user-profile-submenu div {
                      padding: 10px 12px !important;
                      font-size: 13px !important;
                    }

                    .user-profile-btn span {
                      display: none;
                    }

                    .user-profile-btn i:last-child {
                      display: none;
                    }
                  }

                  @media (max-width: 480px) {
                    .user-profile-dropdown {
                      position: relative !important;
                    }

                    .user-profile-submenu {
                      position: fixed !important;
                      top: auto !important;
                      bottom: 0 !important;
                      left: 0 !important;
                      right: 0 !important;
                      width: 100% !important;
                      min-width: 100% !important;
                      border-radius: 15px 15px 0 0 !important;
                      max-height: 70vh !important;
                      overflow-y: auto !important;
                    }

                    .user-profile-btn {
                      width: 100%;
                      padding: 10px 15px !important;
                      font-size: 13px !important;
                      justify-content: center;
                    }

                    .user-profile-submenu a,
                    .user-profile-submenu div {
                      padding: 12px 15px !important;
                      font-size: 14px !important;
                      border-bottom: 1px solid #f0f0f0 !important;
                    }
                  }
                </style>
              <?php else: ?>
                <a href="login.php" class="auth-btn login-btn">
                  <i class="fas fa-sign-in-alt"></i> Login
                </a>
                <a href="register.php" class="auth-btn register-btn">
                  <i class="fas fa-user-plus"></i> Register
                </a>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- STICKY HEADER (Visible on All Devices) -->
    <div class="header-sticky sticky-top">
      <div class="container">
        <div class="row align-items-center justify-content-between">
          
          <!-- LOGO -->
          <div class="col-auto">
            <div class="header-logo">
              <a href="index.php"><img src="assets/img/logo_zem.png" alt="Zem Logo"></a>
            </div>
          </div>

          <!-- DESKTOP NAVIGATION (Hidden on Mobile/Tablet) -->
          <div class="col d-none d-lg-block">
            <nav class="main-navigation">
              <ul class="nav-menu">
                <li class="nav-item-dropdown">
                  <a href="index.php">Home</a>
                </li>
                <!--about-->
                <li class="nav-item-dropdown">
                  <a href="about.php">About</a>
                </li>
                <!--property-->
                <li class="nav-item-dropdown">
                  <a href="properties.php">Properties</a>
                  <ul class="dropdown-menu-nav">
                    <li><a href="properties-details.php">Properties Details</a></li>
                  </ul>
                </li>
                <?php if ($is_logged_in): ?>
                <!--favorites-->
                <!-- <li class="nav-item-dropdown">
                  <a href="favorites.php" style="color: #764ba2; font-weight: 600;">
                    <i class="fas fa-heart" style="margin-right: 5px;"></i> Favorites
                  </a>
                </li> -->
                <?php endif; ?>
                <!--services-->
                <li class="nav-item-dropdown">
                  <a href="service.php">Services</a>
                  <ul class="dropdown-menu-nav">
                    <li><a href="service-details.php">Services Details</a></li>
                  </ul>
                </li>
                <!--agents-->
                <li class="nav-item-dropdown">
                  <a href="agents.php">Agents</a>
                  <ul class="dropdown-menu-nav">
                    <li><a href="agent-details.php">Agent Details</a></li>
                  </ul>
                </li>
                <!--blog -->
                <li class="nav-item-dropdown">
                  <a href="blog.php">Blog</a>
                  <ul class="dropdown-menu-nav">
                    <li><a href="blog-details.php">Blog Details</a></li>
                  </ul>
                </li>
                <!--contact-->
                <li class="nav-item-dropdown">
                  <a href="contact.php">Contact</a>
                </li>
              </ul>
            </nav>
          </div>

          <!-- RIGHT SIDE: LANGUAGE & CTA (Desktop Only) -->
          <div class="col-auto d-none d-lg-flex align-items-center gap-3">
            <a href="appointment.php" class="vs-btn style2">MAKE AN APPOINTMENT</a>
          </div>

          <!-- MOBILE: HAMBURGER MENU & LANGUAGE (Visible on Mobile/Tablet) -->
          <div class="col-auto d-lg-none">
            <div class="mobile-header-actions d-flex align-items-center gap-2">
              
              <button class="mobile-menu-toggle" id="mobileMenuToggle">
                <i class="fal fa-bars"></i>
              </button>
            </div>
          </div>

        </div>
      </div>
    </div>

  </header>

  <!-- MOBILE MENU SIDEBAR (Hidden by Default) -->
  <div class="mobile-menu-sidebar d-lg-none" id="mobileMenuSidebar">
    <div class="mobile-menu-header">
      <button class="close-mobile-menu" id="closeMobileMenu">
        <i class="fal fa-times"></i>
      </button>
    </div>
    <div class="mobile-menu-content">
      <?php if (!$is_logged_in): ?>
        <div class="mobile-auth-buttons">
          <a href="login.php" class="mobile-login-btn">Login</a>
          <a href="register.php" class="mobile-register-btn">Register</a>
        </div>
      <?php else: ?>
        <div class="mobile-profile-label">
          <span>Your Account</span>
        </div>
        <div class="mobile-user-profile">
          <button class="mobile-profile-header" id="mobileProfileToggle" type="button" aria-expanded="false">
            <div class="mobile-profile-avatar"><?php echo strtoupper(substr($user_name, 0, 1)); ?></div>
            <div class="mobile-profile-info">
              <p class="mobile-profile-name"><?php echo htmlspecialchars($user_name); ?></p>
              <p class="mobile-profile-email"><?php echo htmlspecialchars($_SESSION['user_email'] ?? ''); ?></p>
            </div>
            <span class="mobile-profile-dropdown-btn" id="mobileProfileDropdownBtn">
              <i class="fas fa-chevron-down"></i>
            </span>
          </button>
          <div class="mobile-profile-dropdown" id="mobileProfileDropdown">
            <a href="<?php echo $dashboard_url; ?>"><i class="fas fa-chart-line"></i> Dashboard</a>
            <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
          </div>
        </div>
      <?php endif; ?>

      <nav class="mobile-navigation">
        <ul class="mobile-nav-menu">
          <li class="mobile-nav-item">
            <a href="index.php">Home</a>
          </li>
          <li class="mobile-nav-item">
            <a href="about.php">About</a>
          </li>

          <li class="mobile-nav-item">
            <a href="properties.php">Properties</a>
            <button class="submenu-toggle"><i class="fas fa-chevron-down"></i></button>
            <ul class="mobile-submenu" style="display: none;">
              <li><a href="properties-details.php">Properties Details</a></li>
            </ul>
          </li>

          <li class="mobile-nav-item">
            <a href="service.php">Services</a>
            <button class="submenu-toggle"><i class="fas fa-chevron-down"></i></button>
            <ul class="mobile-submenu" style="display: none;">
              <li><a href="service-details.php">Services Details</a></li>
            </ul>
          </li>

          <li class="mobile-nav-item">
            <a href="agents.php">Agents</a>
            <button class="submenu-toggle"><i class="fas fa-chevron-down"></i></button>
            <ul class="mobile-submenu" style="display: none;">
              <li><a href="agent-details.php">Agent Details</a></li>
            </ul>
          </li>

          <li class="mobile-nav-item">
            <a href="blog.php">Blog</a>
            <button class="submenu-toggle"><i class="fas fa-chevron-down"></i></button>
            <ul class="mobile-submenu" style="display: none;">
              <li><a href="blog-details.php">Blog Details</a></li>
            </ul>
          </li>
          <li class="mobile-nav-item">
            <a href="contact.php">Contact</a>
          </li>

        </ul>
      </nav>
      <div class="mobile-menu-footer">
        <a href="appointment.php" class="vs-btn style2 w-100">MAKE AN APPOINTMENT</a>
      </div>
    </div>
  </div>

  <!-- MOBILE MENU OVERLAY -->
  <div class="mobile-menu-overlay d-lg-none" id="mobileMenuOverlay">

  </div>
