<?php
require_once 'config.php';

// Fetch hero slider content from database
$query_hero = "SELECT * FROM hero_sliders WHERE status = 'active' ORDER BY display_order ASC";
$result_hero = $conn->query($query_hero);
$hero_slides = [];
if ($result_hero) {
    while ($row = $result_hero->fetch_assoc()) {
        $hero_slides[] = $row;
    }
}

// If no hero slides exist, create default ones
if (empty($hero_slides)) {
    $hero_slides = [
        [
            'id' => 1,
            'tag' => 'Premium Properties',
            'title' => 'Find Your Dream Apartment Today',
            'subtitle' => 'Discover luxury apartments in prime locations with verified documents and expert guidance for secure investments.',
            'button1_text' => 'Explore Properties',
            'button1_url' => 'properties.php',
            'button2_text' => 'Contact Us',
            'button2_url' => 'contact.php',
            'image_url' => 'assets/img/hero/Copilot_20260219_135217.png',
            'stat1_icon' => 'fas fa-check-circle',
            'stat1_text' => '22K+ Properties Listed',
            'stat2_icon' => 'fas fa-users',
            'stat2_text' => '140K+ Happy Customers'
        ]
    ];
}

// Fetch properties for index slider
$query_properties = "SELECT * FROM properties WHERE status = 'active' ORDER BY created_at DESC LIMIT 12";
$result_properties = $conn->query($query_properties);
$featured_properties = [];
while ($row = $result_properties->fetch_assoc()) {
    $featured_properties[] = $row;
}

// Fetch blog posts for index slider
$query_blog = "SELECT * FROM blog_posts ORDER BY created_at DESC LIMIT 6";
$result_blog = $conn->query($query_blog);
$featured_blog = [];
while ($row = $result_blog->fetch_assoc()) {
    $featured_blog[] = $row;
}

// Fetch services for index slider
$query_services = "SELECT * FROM services ORDER BY id ASC LIMIT 8";
$result_services = $conn->query($query_services);
$featured_services = [];
while ($row = $result_services->fetch_assoc()) {
    $featured_services[] = $row;
}

// Get unique property types for filter
$types_query = "SELECT DISTINCT type FROM properties WHERE status = 'active' ORDER BY type";
$types_result = $conn->query($types_query);
$property_types = [];
while ($row = $types_result->fetch_assoc()) {
    $property_types[] = $row['type'];
}

// Get unique locations for filter
$locations_query = "SELECT DISTINCT city FROM properties WHERE status = 'active' ORDER BY city";
$locations_result = $conn->query($locations_query);
$property_locations = [];
while ($row = $locations_result->fetch_assoc()) {
    $property_locations[] = $row['city'];
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Real Estate - Zemaraim</title>
  <meta name="author" content="vecuro">
  <meta name="description" content="Zemaraim HTML Template">
  <meta name="keywords" content="Zemaraim HTML Template">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <style>
    /* Dynamic Property, Blog, Service Styles */
    .property-filter { margin-bottom: 30px; display: flex; gap: 15px; flex-wrap: wrap; }
    .filter-group { display: flex; gap: 10px; flex-wrap: wrap; align-items: center; }
    .filter-select { padding: 8px 12px; border: 1px solid #e0e0e0; border-radius: 5px; font-size: 13px; background: white; }
    .filter-btn { padding: 8px 15px; border: 1px solid #e0e0e0; background: white; border-radius: 5px; cursor: pointer; transition: all 0.3s ease; font-size: 13px; font-weight: 600; }
    .filter-btn.active { background: #667eea; color: white; border-color: #667eea; }
    .filter-btn:hover { border-color: #667eea; color: #667eea; }

    /* Property Slider Styles - Responsive Design */
    .property-section { padding: 20px 0; background: #f8f9fa; }
    .property-section-header { text-align: center; margin-bottom: 60px; }
    .property-section-header h2 { font-size: 42px; font-weight: 700; color: #1a1a1a; margin-bottom: 15px; font-family: 'Playfair Display', serif; }
    .property-section-header p { font-size: 16px; color: #666; max-width: 600px; margin: 0 auto; }

    .property-slider-wrapper { margin-bottom: 80px; position: relative; }
    .property-slider { width: 100%; margin: 0 auto; }
    .property-slider .slick-list { margin: 0 -15px; }
    .property-slider .slick-slide { margin: 0 15px; }
    .property-card-slider { background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 2px 15px rgba(0,0,0,0.08); transition: all 0.3s ease; height: 100%; }
    .property-card-slider:hover { transform: translateY(-8px); box-shadow: 0 10px 35px rgba(0,0,0,0.15); }
    .property-slider-img { width: 100%; height: 220px; object-fit: cover; display: block; }
    .property-slider-content { padding: 20px; }
    .property-slider-title { font-size: 18px; font-weight: 700; color: #1a1a1a; margin-bottom: 12px; min-height: 50px; display: flex; align-items: center; }
    .property-slider-btn { width: 100%; padding: 12px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; text-align: center; border-radius: 8px; text-decoration: none; font-weight: 600; transition: all 0.3s ease; display: block; border: none; cursor: pointer; }
    .property-slider-btn:hover { transform: translateY(-2px); box-shadow: 0 8px 20px rgba(102,126,234,0.3); }

    /* Blog Slider Styles - Responsive Design */
    .blog-section { padding: 80px 0; background: #f8f9fa; }
    .blog-section-header { text-align: center; margin-bottom: 60px; }
    .blog-section-header h2 { font-size: 42px; font-weight: 700; color: #1a1a1a; margin-bottom: 15px; font-family: 'Playfair Display', serif; }
    .blog-section-header p { font-size: 16px; color: #666; max-width: 600px; margin: 0 auto; }

    .blog-slider-wrapper { margin-bottom: 80px; position: relative; }
    .blog-slider { width: 100%; margin: 0 auto; }
    .blog-slider .slick-list { margin: 0 -15px; }
    .blog-slider .slick-slide { margin: 0 15px; }
    .blog-card-slider { background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 2px 15px rgba(0,0,0,0.08); text-decoration: none; color: inherit; transition: all 0.3s ease; height: 100%; display: flex; flex-direction: column; }
    .blog-card-slider:hover { transform: translateY(-8px); box-shadow: 0 10px 35px rgba(0,0,0,0.15); }
    .blog-slider-img-wrapper { position: relative; height: 200px; overflow: hidden; }
    .blog-slider-img { width: 100%; height: 100%; object-fit: cover; transition: transform 0.3s ease; display: block; }
    .blog-card-slider:hover .blog-slider-img { transform: scale(1.05); }
    .blog-date-badge-slider { position: absolute; top: 12px; right: 12px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 6px 12px; border-radius: 6px; font-size: 12px; font-weight: 600; }
    .blog-slider-content { padding: 20px; flex-grow: 1; display: flex; flex-direction: column; }
    .blog-slider-title { font-size: 16px; font-weight: 700; color: #1a1a1a; margin-bottom: 10px; line-height: 1.3; min-height: 45px; display: flex; align-items: center; }
    .blog-slider-date { font-size: 13px; color: #999; margin-bottom: 10px; }
    .blog-slider-btn { display: inline-flex; align-items: center; gap: 5px; color: #667eea; font-weight: 600; font-size: 14px; text-decoration: none; margin-top: auto; }
    .blog-slider-btn:hover { gap: 8px; color: #764ba2; }

    /* Service Slider Styles - Responsive Design */
    .service-section { padding: 80px 0; background: #f8f9fa; }
    .service-section-header { text-align: center; margin-bottom: 60px; }
    .service-section-header h2 { font-size: 42px; font-weight: 700; color: #1a1a1a; margin-bottom: 15px; font-family: 'Playfair Display', serif; }
    .service-section-header p { font-size: 16px; color: #666; max-width: 600px; margin: 0 auto; }

    .service-slider-wrapper { margin-bottom: 80px; position: relative; }
    .service-slider { width: 100%; margin: 0 auto; }
    .service-slider .slick-list { margin: 0 -15px; }
    .service-slider .slick-slide { margin: 0 15px; }
    .service-card-slider { background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 2px 15px rgba(0,0,0,0.08); transition: all 0.3s ease; text-decoration: none; color: inherit; display: flex; flex-direction: column; height: 100%; }
    .service-card-slider:hover { transform: translateY(-8px); box-shadow: 0 10px 35px rgba(0,0,0,0.15); }
    .service-slider-icon-wrapper { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 35px 20px; text-align: center; color: white; }
    .service-slider-icon-wrapper i { font-size: 48px; margin-bottom: 10px; display: inline-block; }
    .service-slider-content { padding: 20px; flex-grow: 1; display: flex; flex-direction: column; }
    .service-slider-title { font-size: 18px; font-weight: 700; color: #1a1a1a; margin-bottom: 12px; }
    .service-slider-desc { font-size: 14px; color: #666; margin-bottom: 15px; display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; flex-grow: 1; }
    .service-slider-btn { display: inline-flex; align-items: center; gap: 5px; color: #667eea; font-weight: 600; font-size: 14px; text-decoration: none; margin-top: auto; }
    .service-slider-btn:hover { gap: 8px; color: #764ba2; }

    /* Slick Slider Adjustments */
    .slick-slider { position: relative; display: block; box-sizing: border-box; user-select: none; -webkit-user-select: none; -moz-user-select: none; }
    .slick-list { position: relative; display: block; overflow: hidden; margin: 0; padding: 0; }
    .slick-track { display: flex !important; margin-left: -15px; margin-right: -15px; }
    .slick-slide { display: block !important; float: none !important; height: auto; min-height: 1px; outline: none; }
    .slick-arrow { position: absolute; display: block; height: 45px; width: 45px; line-height: 45px; font-size: 20px; cursor: pointer; background: white; color: #667eea; top: 50%; margin-top: -22px; padding: 0; border: none; border-radius: 8px; z-index: 10; box-shadow: 0 2px 10px rgba(0,0,0,0.1); transition: all 0.3s ease; font-weight: bold; }
    .slick-arrow:hover { background: #667eea; color: white; box-shadow: 0 4px 15px rgba(102,126,234,0.3); transform: scale(1.05); }
    .slick-prev { left: -60px; }
    .slick-next { right: -60px; }
    .slick-prev:before { content: '‹'; font-size: 32px; }
    .slick-next:before { content: '›'; font-size: 32px; }
    .slick-dots { position: absolute; bottom: -50px; display: block; width: 100%; padding: 0; margin: 0; list-style: none; text-align: center; }
    .slick-dots li { position: relative; display: inline-block; width: 12px; height: 12px; margin: 0 6px; padding: 0; cursor: pointer; }
    .slick-dots li button { font-size: 0; line-height: 0; display: block; width: 12px; height: 12px; padding: 0; cursor: pointer; color: transparent; border: 2px solid #667eea; border-radius: 50%; background: transparent; outline: none; transition: all 0.3s ease; }
    .slick-dots li.slick-active button { background: #667eea; border-color: #667eea; }
    .slick-dots li button:hover { border-color: #667eea; }
    
    /* Responsive - Desktop (1201px+) */
    @media (min-width: 1201px) {
      .property-section, .service-section, .blog-section { padding: 10px 0; }
      .property-section-header h2, .service-section-header h2, .blog-section-header h2 { font-size: 42px; }
      .property-section-header p, .service-section-header p, .blog-section-header p { font-size: 16px; }
      .property-slider-img { height: 220px; }
      .blog-slider-img-wrapper { height: 200px; }
      .service-slider-icon-wrapper { padding: 35px 20px; }
      .service-slider-icon-wrapper i { font-size: 48px; }
      .slick-prev { left: -60px; }
      .slick-next { right: -60px; }
    }

    /* Responsive - Large Tablet (1200px) */
    @media (max-width: 1200px) {
      .property-section, .service-section, .blog-section { padding: 70px 0; }
      .property-section-header h2, .service-section-header h2, .blog-section-header h2 { font-size: 36px; }
      .property-section-header p, .service-section-header p, .blog-section-header p { font-size: 15px; }
      .property-slider-img { height: 200px; }
      .blog-slider-img-wrapper { height: 180px; }
      .service-slider-icon-wrapper { padding: 30px 18px; }
      .service-slider-icon-wrapper i { font-size: 44px; }
    }

    /* Responsive - Tablet (992px) */
    @media (max-width: 992px) {
      .property-section, .service-section, .blog-section { padding: 60px 0; }
      .property-section-header, .service-section-header, .blog-section-header { margin-bottom: 50px; }
      .property-section-header h2, .service-section-header h2, .blog-section-header h2 { font-size: 32px; }
      .property-section-header p, .service-section-header p, .blog-section-header p { font-size: 14px; }
      .property-slider-img { height: 180px; }
      .blog-slider-img-wrapper { height: 160px; }
      .property-slider-content { padding: 16px; }
      .property-slider-title { font-size: 16px; }
      .blog-slider-content { padding: 16px; }
      .blog-slider-title { font-size: 15px; }
      .service-slider-icon-wrapper { padding: 28px 16px; }
      .service-slider-icon-wrapper i { font-size: 42px; }
      .service-slider-content { padding: 16px; }
      .service-slider-title { font-size: 16px; }
      .service-slider-desc { font-size: 13px; }
      .slick-prev { left: -50px; }
      .slick-next { right: -50px; }
      .slick-arrow { width: 42px; height: 42px; line-height: 42px; margin-top: -21px; font-size: 18px; }
      .slick-prev:before, .slick-next:before { font-size: 28px; }
    }

    /* Responsive - Mobile (768px) */
    @media (max-width: 768px) {
      .property-section, .service-section, .blog-section { padding: 50px 0; }
      .property-section-header, .service-section-header, .blog-section-header { margin-bottom: 40px; }
      .property-section-header h2, .service-section-header h2, .blog-section-header h2 { font-size: 28px; margin-bottom: 12px; }
      .property-section-header p, .service-section-header p, .blog-section-header p { font-size: 13px; }
      .property-slider-wrapper { margin-bottom: 60px; }
      .blog-slider-wrapper { margin-bottom: 60px; }
      .service-slider-wrapper { margin-bottom: 60px; }
      .property-slider-img { height: 160px; }
      .blog-slider-img-wrapper { height: 140px; }
      .blog-date-badge-slider { font-size: 11px; padding: 5px 10px; top: 10px; right: 10px; }
      .property-slider-content { padding: 14px; }
      .property-slider-title { font-size: 15px; min-height: 40px; }
      .property-slider-btn { padding: 10px; font-size: 13px; }
      .blog-slider-content { padding: 14px; }
      .blog-slider-title { font-size: 14px; min-height: 35px; }
      .blog-slider-date { font-size: 12px; }
      .blog-slider-btn { font-size: 13px; }
      .service-slider-icon-wrapper { padding: 25px 14px; }
      .service-slider-icon-wrapper i { font-size: 40px; }
      .service-slider-content { padding: 14px; }
      .service-slider-title { font-size: 15px; }
      .service-slider-desc { font-size: 12px; -webkit-line-clamp: 2; }
      .service-slider-btn { font-size: 13px; }
      .slick-prev { left: 10px; }
      .slick-next { right: 10px; }
      .slick-arrow { width: 40px; height: 40px; line-height: 40px; margin-top: -20px; font-size: 16px; }
      .slick-prev:before, .slick-next:before { font-size: 24px; }
      .slick-dots { bottom: -45px; }
      .slick-dots li { width: 10px; height: 10px; margin: 0 5px; }
      .slick-dots li button { width: 10px; height: 10px; }
    }

    /* Responsive - Small Mobile (576px) */
    @media (max-width: 575px) {
      .property-section, .service-section, .blog-section { padding: 40px 0; }
      .property-section-header, .service-section-header, .blog-section-header { margin-bottom: 30px; }
      .property-section-header h2, .service-section-header h2, .blog-section-header h2 { font-size: 24px; margin-bottom: 10px; }
      .property-section-header p, .service-section-header p, .blog-section-header p { font-size: 12px; }
      .property-slider-wrapper { margin-bottom: 50px; }
      .blog-slider-wrapper { margin-bottom: 50px; }
      .service-slider-wrapper { margin-bottom: 50px; }
      .property-slider-img { height: 140px; }
      .blog-slider-img-wrapper { height: 120px; }
      .property-slider-content { padding: 12px; }
      .property-slider-title { font-size: 13px; min-height: 35px; margin-bottom: 8px; }
      .property-slider-btn { padding: 9px; font-size: 12px; }
      .blog-slider-content { padding: 12px; }
      .blog-slider-title { font-size: 13px; min-height: 30px; margin-bottom: 6px; }
      .blog-slider-date { font-size: 11px; }
      .blog-slider-btn { font-size: 12px; }
      .blog-date-badge-slider { font-size: 10px; padding: 4px 8px; }
      .service-slider-icon-wrapper { padding: 20px 12px; }
      .service-slider-icon-wrapper i { font-size: 36px; margin-bottom: 8px; }
      .service-slider-content { padding: 12px; }
      .service-slider-title { font-size: 14px; }
      .service-slider-desc { font-size: 11px; -webkit-line-clamp: 1; margin-bottom: 10px; }
      .service-slider-btn { font-size: 12px; }
      .slick-prev { left: 8px; }
      .slick-next { right: 8px; }
      .slick-arrow { width: 36px; height: 36px; line-height: 36px; margin-top: -18px; font-size: 14px; }
      .slick-prev:before, .slick-next:before { font-size: 20px; }
      .slick-dots { bottom: -40px; }
      .slick-dots li { width: 9px; height: 9px; margin: 0 4px; }
      .slick-dots li button { width: 9px; height: 9px; }
    }
    /* Hero Slider Styles */
    .hero-slider-wrapper { width: 100%; position: relative; margin: 0; padding: 0; overflow: hidden; }
    .hero-slider-item {
      position: relative !important;
      width: 100% !important;
      height: 600px;
      background-size: cover !important;
      background-position: center !important;
      display: flex !important;
      align-items: center;
      justify-content: center;
      overflow: hidden;
    }
    .hero-slider-item .container {
      position: relative !important;
      z-index: 2 !important;
      width: 100%;
      max-width: 1400px;
      margin: 0 auto;
      padding-left: 15px;
      padding-right: 15px;
    }
    .hero-slider-item .row {
      display: flex;
      flex-wrap: wrap;
      margin-left: -12px;
      margin-right: -12px;
    }
    .hero-slider-item .col-lg-8 {
      flex: 0 0 100%;
      padding-left: 12px;
      padding-right: 12px;
      display: flex;
      justify-content: center;
    }
    .hero-slider-item::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: rgba(0, 0, 0, 0.35);
      z-index: 1;
      width: 100%;
      height: 100%;
    }
    .hero-slider-content {
      position: relative;
      z-index: 2;
      padding: 40px 20px;
      max-width: 812px;
      color: white;
      width: 100%;
      text-align: center;
    }
    @keyframes slideInLeft {
      from {
        opacity: 0;
        transform: translateX(-50px);
      }
      to {
        opacity: 1;
        transform: translateX(0);
      }
    }
    .hero-slider-tag {
      display: inline-block;
      background: rgba(102, 126, 234, 0.9);
      color: white;
      padding: 8px 20px;
      border-radius: 25px;
      font-size: 12px;
      font-weight: 600;
      margin-bottom: 20px;
      text-transform: uppercase;
      letter-spacing: 1px;
    }
    .hero-slider-title {
      font-size: 35px;
      font-weight: 500;
      line-height: 1.2;
      margin-bottom: 15px;
      font-family: 'Playfair Display', serif;
    }
    .hero-slider-subtitle {
      font-size: 18px;
      font-weight: 400;
      margin-bottom: 25px;
      opacity: 0.95;
      line-height: 1.6;
    }
    .hero-slider-cta {
      display: inline-flex;
      gap: 15px;
      flex-wrap: wrap;
    }
    .hero-slider-btn {
      padding: 14px 35px;
      text-decoration: none;
      border-radius: 5px;
      font-weight: 600;
      font-size: 14px;
      transition: all 0.3s ease;
      border: 2px solid transparent;
      display: inline-block;
      cursor: pointer;
    }
    .hero-slider-btn.primary {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
    }
    .hero-slider-btn.primary:hover {
      transform: translateY(-3px);
      box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
    }
    .hero-slider-btn.secondary {
      background: transparent;
      color: white;
      border-color: white;
    }
    .hero-slider-btn.secondary:hover {
      background: white;
      color: #667eea;
    }
    .hero-slider-arrow {
      position: absolute;
      top: 50%;
      transform: translateY(-50%);
      width: 50px;
      height: 50px;
      background: rgba(255, 255, 255, 0.2);
      border: none;
      color: white;
      font-size: 24px;
      cursor: pointer;
      z-index: 10;
      border-radius: 5px;
      transition: all 0.3s ease;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    .hero-slider-arrow:hover {
      background: rgba(102, 126, 234, 0.9);
      transform: translateY(-50%) scale(1.1);
    }
    .hero-slider-prev { left: 30px; }
    .hero-slider-next { right: 30px; }
    .hero-slider-dots {
      position: absolute;
      bottom: 30px;
      left: 50%;
      transform: translateX(-50%);
      display: flex;
      gap: 12px;
      z-index: 10;
    }
    .hero-slider-dot {
      width: 12px;
      height: 12px;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.5);
      cursor: pointer;
      transition: all 0.3s ease;
      border: 2px solid transparent;
    }
    .hero-slider-dot.active {
      background: white;
      width: 30px;
      border-radius: 6px;
    }
    .hero-stats {
      display: flex;
      gap: 30px;
      margin-top: 30px;
      flex-wrap: wrap;
      justify-content: center;
    }
    .hero-stat-item {
      display: flex;
      align-items: center;
      gap: 12px;
    }
    .hero-stat-icon {
      width: 40px;
      height: 40px;
      background: rgba(255, 255, 255, 0.2);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      flex-shrink: 0;
    }
    .hero-stat-text {
      font-size: 13px;
      opacity: 0.9;
    }
    /* Responsive Design */
    @media (max-width: 1200px) {
      .hero-slider-item { height: 500px; }
      .hero-slider-title { font-size: 40px; }
      .hero-slider-subtitle { font-size: 16px; }
      .hero-slider-wrapper .slick-prev { left: 15px; }
      .hero-slider-wrapper .slick-next { right: 15px; }
    }
    @media (max-width: 992px) {
      .hero-slider-item { height: 420px; }
      .hero-slider-title { font-size: 32px; }
      .hero-slider-subtitle { font-size: 14px; }
      .hero-slider-content { max-width: 100%; padding: 30px 20px; }
      .hero-stats { gap: 20px; }
      .hero-slider-wrapper .slick-arrow { width: 40px; height: 40px; font-size: 18px; }
      .hero-slider-wrapper .slick-prev:before { font-size: 24px; }
      .hero-slider-wrapper .slick-next:before { font-size: 24px; }
      .hero-slider-wrapper .slick-dots { bottom: 18px; gap: 10px; }
      .hero-slider-wrapper .slick-dots li { width: 10px; height: 10px; }
      .hero-slider-wrapper .slick-dots li button { width: 10px; height: 10px; }
      .hero-slider-wrapper .slick-dots li.slick-active button { width: 26px; }
    }
    @media (max-width: 768px) {
      .hero-slider-item { height: 350px; }
      .hero-slider-title { font-size: 26px; }
      .hero-slider-subtitle { font-size: 13px; }
      .hero-slider-btn { padding: 10px 25px; font-size: 12px; }
      .hero-slider-wrapper .slick-arrow { width: 40px; height: 40px; font-size: 16px; }
      .hero-slider-wrapper .slick-prev { left: 10px; }
      .hero-slider-wrapper .slick-next { right: 10px; }
      .hero-slider-wrapper .slick-prev:before { font-size: 20px; }
      .hero-slider-wrapper .slick-next:before { font-size: 20px; }
      .hero-slider-cta { gap: 10px; }
      .hero-stats { gap: 15px; font-size: 12px; }
      .hero-slider-wrapper .slick-dots { bottom: 15px; gap: 8px; }
      .hero-slider-wrapper .slick-dots li { width: 9px; height: 9px; }
      .hero-slider-wrapper .slick-dots li button { width: 9px; height: 9px; }
      .hero-slider-wrapper .slick-dots li.slick-active button { width: 22px; }
    }
    @media (max-width: 576px) {
      .hero-slider-item { height: 280px; }
      .hero-slider-title { font-size: 22px; margin-bottom: 10px; }
      .hero-slider-subtitle { font-size: 12px; margin-bottom: 15px; }
      .hero-slider-tag { padding: 6px 15px; font-size: 10px; margin-bottom: 12px; }
      .hero-slider-btn { padding: 8px 20px; font-size: 11px; }
      .hero-slider-wrapper .slick-arrow { width: 36px; height: 36px; font-size: 14px; }
      .hero-slider-wrapper .slick-prev { left: 8px; }
      .hero-slider-wrapper .slick-next { right: 8px; }
      .hero-slider-wrapper .slick-prev:before { font-size: 18px; }
      .hero-slider-wrapper .slick-next:before { font-size: 18px; }
      .hero-slider-wrapper .slick-dots { bottom: 12px; gap: 6px; }
      .hero-slider-wrapper .slick-dots li { width: 8px; height: 8px; }
      .hero-slider-wrapper .slick-dots li button { width: 8px; height: 8px; }
      .hero-slider-wrapper .slick-dots li.slick-active button { width: 20px; }
      .hero-stats { gap: 10px; margin-top: 15px; }
      .hero-stat-icon { width: 30px; height: 30px; font-size: 14px; }
      .hero-stat-text { font-size: 11px; }
      .hero-slider-content { padding: 20px 0px; max-width: 77%; }
    }
    
    /* Slick Slider Custom Hero Styles */
    .hero-slider-wrapper {
      overflow: hidden;
    }
    .hero-slider-wrapper .slick-slide {
      display: flex !important;
      height: auto;
      width: 100%;
      margin: 0;
      padding: 0;
      float: left;
    }
    .hero-slider-wrapper .slick-list {
      margin: 0 !important;
      padding: 0 !important;
      height: auto;
      overflow: hidden !important;
      position: relative;
      width: 100%;
    }
    .hero-slider-wrapper .slick-track {
      display: flex !important;
      margin: 0 !important;
      padding: 0;
      width: 100%;
    }
    .hero-slider-wrapper .slick-arrow {
      position: absolute;
      top: 50%;
      transform: translateY(-50%);
      width: 50px;
      height: 50px;
      background: rgba(255, 255, 255, 0.2);
      border: none;
      color: white;
      font-size: 24px;
      cursor: pointer;
      z-index: 10;
      border-radius: 5px;
      transition: all 0.3s ease;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 0;
    }
    .hero-slider-wrapper .slick-arrow:hover {
      background: rgba(102, 126, 234, 0.9);
      transform: translateY(-50%) scale(1.1);
    }
    .hero-slider-wrapper .slick-prev {
      left: 30px;
    }
    .hero-slider-wrapper .slick-next {
      right: 30px;
    }
    .hero-slider-wrapper .slick-prev:before {
      content: '‹';
      font-size: 32px;
      color: white;
    }
    .hero-slider-wrapper .slick-next:before {
      content: '›';
      font-size: 32px;
      color: white;
    }
    .hero-slider-wrapper .slick-dots {
      position: absolute;
      bottom: 10px;
      left: 50% !important;
      transform: translateX(-50%) !important;
      display: flex !important;
      justify-content: center;
      gap: 10px;
      z-index: 15;
      list-style: none;
      margin: 0 !important;
      padding: 0 !important;
      width: auto;
    }
    .hero-slider-wrapper .slick-dots li {
      display: inline-block !important;
      width: 12px;
      height: 12px;
      margin: 0 !important;
      padding: 0 !important;
      cursor: pointer;
    }
    .hero-slider-wrapper .slick-dots li button {
      width: 12px;
      height: 12px;
      padding: 0 !important;
      border: 2px solid white;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.4);
      cursor: pointer;
      transition: all 0.3s ease;
      font-size: 0;
      line-height: 0;
      display: block;
      color: transparent;
      outline: none;
    }
    .hero-slider-wrapper .slick-dots li.slick-active button {
      background: white;
      width: 12px;
      border-radius: 6px;
    }
    .hero-slider-wrapper .slick-dots li button:hover {
      border-color: white;
      background: rgba(255, 255, 255, 0.7);
    }
  </style>
</head>

<body>
  <div class="preloader">
    <button class="vs-btn preloaderCls">Cancel Preloader </button>
    <div class="preloader-inner">
      <img src="assets/img/logo.png" alt="Zemaraim">
      <span class="loader"></span>
    </div>
  </div>

  <!-- Include Header -->
  <?php include 'header.php'; ?>

  <!--==============================
Hero Slider Area
==============================-->
  <section class="hero-slider-wrapper" id="heroSlider">
    <?php if (!empty($hero_slides)): ?>
      <?php foreach ($hero_slides as $slide): ?>
    <div class="hero-slider-item" style="background-image: url(<?php echo htmlspecialchars($slide['image_url'] ?? 'assets/img/bg/hero-bg-2.jpg'); ?>);">
      <div class="container" style="position: relative; z-index: 2;">
        <div class="row align-items-center">
          <div class="col-lg-8">
            <div class="hero-slider-content">
              <span class="hero-slider-tag"><?php echo htmlspecialchars($slide['tag'] ?? ''); ?></span>
              <h1 class="hero-slider-title"><?php echo htmlspecialchars($slide['title'] ?? ''); ?></h1>
              <p class="hero-slider-subtitle"><?php echo htmlspecialchars($slide['subtitle'] ?? ''); ?></p>
              <div class="hero-slider-cta">
                <?php if (!empty($slide['button1_text']) && !empty($slide['button1_url'])): ?>
                <a href="<?php echo htmlspecialchars($slide['button1_url']); ?>" class="hero-slider-btn primary"><?php echo htmlspecialchars($slide['button1_text']); ?></a>
                <?php endif; ?>
                <?php if (!empty($slide['button2_text']) && !empty($slide['button2_url'])): ?>
                <a href="<?php echo htmlspecialchars($slide['button2_url']); ?>" class="hero-slider-btn secondary"><?php echo htmlspecialchars($slide['button2_text']); ?></a>
                <?php endif; ?>
              </div>
              <div class="hero-stats">
                <?php if (!empty($slide['stat1_text'])): ?>
                <div class="hero-stat-item">
                  <div class="hero-stat-icon"><i class="<?php echo htmlspecialchars($slide['stat1_icon'] ?? 'fas fa-check-circle'); ?>"></i></div>
                  <span class="hero-stat-text"><?php echo htmlspecialchars($slide['stat1_text']); ?></span>
                </div>
                <?php endif; ?>
                <?php if (!empty($slide['stat2_text'])): ?>
                <div class="hero-stat-item">
                  <div class="hero-stat-icon"><i class="<?php echo htmlspecialchars($slide['stat2_icon'] ?? 'fas fa-users'); ?>"></i></div>
                  <span class="hero-stat-text"><?php echo htmlspecialchars($slide['stat2_text']); ?></span>
                </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
      <?php endforeach; ?>
    <?php endif; ?>
  </section>
  <!--==============================
Category Area
==============================-->
    <!--==============================
Why Choose Zemaraim Section
==============================-->
  <section class="why-choose-section">
    <div class="container">
      <div class="section-header text-center">
        <small class="section-tag">Why Choose Us</small>
        <h2>Your Trusted Real Estate Partner</h2>
        <p>We provide comprehensive real estate solutions with transparency, expertise, and customer satisfaction at the core</p>
      </div>

      <div class="why-choose-grid">
        <!-- Feature 1 -->
        <div class="why-choose-card">
          <div class="why-choose-icon">
            <i class="fas fa-certificate"></i>
          </div>
          <h3>Verified Properties</h3>
          <p>100% legally verified properties with complete documentation and clear ownership titles for complete peace of mind</p>
        </div>

        <!-- Feature 2 -->
        <div class="why-choose-card">
          <div class="why-choose-icon">
            <i class="fas fa-handshake"></i>
          </div>
          <h3>Expert Guidance</h3>
          <p>Our experienced real estate consultants provide personalized guidance to help you make the right investment decisions</p>
        </div>

        <!-- Feature 3 -->
        <div class="why-choose-card">
          <div class="why-choose-icon">
            <i class="fas fa-lock"></i>
          </div>
          <h3>Secure Transactions</h3>
          <p>Safe and transparent transactions with legal support, escrow services, and complete buyer protection</p>
        </div>

        <!-- Feature 4 -->
        <div class="why-choose-card">
          <div class="why-choose-icon">
            <i class="fas fa-globe"></i>
          </div>
          <h3>Prime Locations</h3>
          <p>Access to premium properties in high-growth areas with excellent ROI potential and future appreciation</p>
        </div>

        <!-- Feature 5 -->
        <div class="why-choose-card">
          <div class="why-choose-icon">
            <i class="fas fa-calculator"></i>
          </div>
          <h3>Flexible Financing</h3>
          <p>Easy loan arrangements and documentation support with partnerships with leading financial institutions</p>
        </div>

        <!-- Feature 6 -->
        <div class="why-choose-card">
          <div class="why-choose-icon">
            <i class="fas fa-users"></i>
          </div>
          <h3>Customer Support</h3>
          <p>24/7 customer support team ready to assist you at every step of your property journey</p>
        </div>
      </div>
    </div>
  </section>

  <!--==============================
Statistics Section
==============================-->
  <section class="stats-showcase-section">
    <div class="container">
      <div class="stats-grid">
        <div class="stat-item">
          <div class="stat-number">22K+</div>
          <div class="stat-label">Properties Listed</div>
        </div>
        <div class="stat-item">
          <div class="stat-number">15K+</div>
          <div class="stat-label">Properties Sold</div>
        </div>
        <div class="stat-item">
          <div class="stat-number">500+</div>
          <div class="stat-label">Active Projects</div>
        </div>
        <div class="stat-item">
          <div class="stat-number">140K+</div>
          <div class="stat-label">Happy Customers</div>
        </div>
      </div>
    </div>
  </section>

  <!--==============================
CTA Section
==============================-->
  <section class="cta-section">
    <div class="container">
      <div class="cta-wrapper">
        <div class="cta-content">
          <h2>Ready to Find Your Dream Property?</h2>
          <p>Start your real estate journey with Zemaraim. Explore thousands of verified properties across prime locations</p>
          <div class="cta-buttons">
            <a href="properties.php" class="cta-btn primary">
              <i class="fas fa-search"></i> Explore Properties
            </a>
            <a href="contact.php" class="cta-btn secondary">
              <i class="fas fa-phone"></i> Contact Us
            </a>
          </div>
        </div>
      </div>
    </div>
  </section>

  <style>
    /* Why Choose Section */
    .why-choose-section {
      padding: 20px 0;
      background: #f8f9fa;
    }

    .section-header {
      margin-bottom: 20px;
    }

    .section-tag {
      display: inline-block;
      background: rgba(102, 126, 234, 0.1);
      color: #667eea;
      padding: 8px 20px;
      border-radius: 25px;
      font-size: 12px;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 1px;
      margin-bottom: 15px;
    }

    .section-header h2 {
      font-size: 42px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 15px;
      font-family: 'Playfair Display', serif;
    }

    .section-header p {
      font-size: 16px;
      color: #666;
      max-width: 600px;
      margin: 0 auto;
      line-height: 1.6;
    }

    .why-choose-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
      gap: 30px;
    }

    .why-choose-card {
      background: white;
      padding: 40px 30px;
      border-radius: 12px;
      box-shadow: 0 2px 15px rgba(0, 0, 0, 0.08);
      text-align: center;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }

    .why-choose-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 10px 30px rgba(102, 126, 234, 0.15);
    }

    .why-choose-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 4px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      transform: scaleX(0);
      transform-origin: left;
      transition: transform 0.3s ease;
    }

    .why-choose-card:hover::before {
      transform: scaleX(1);
    }

    .why-choose-icon {
      width: 70px;
      height: 70px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 20px;
      font-size: 32px;
      color: white;
      transition: transform 0.3s ease;
    }

    .why-choose-card:hover .why-choose-icon {
      transform: scale(1.1) rotate(10deg);
    }

    .why-choose-card h3 {
      font-size: 20px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 12px;
    }

    .why-choose-card p {
      font-size: 14px;
      color: #666;
      line-height: 1.6;
      margin: 0;
    }

    /* Statistics Section */
    .stats-showcase-section {
      padding: 70px 0;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
    }

    .stats-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
      gap: 40px;
      text-align: center;
    }

    .stat-item {
      padding: 30px 20px;
    }

    .stat-number {
      font-size: 48px;
      font-weight: 700;
      margin-bottom: 10px;
      display: block;
    }

    .stat-label {
      font-size: 16px;
      font-weight: 500;
      opacity: 0.9;
    }

    /* CTA Section */
    .cta-section {
      padding: 20px 0;
      background: white;
    }

    .cta-wrapper {
      background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
      border: 2px solid rgba(102, 126, 234, 0.2);
      border-radius: 15px;
      padding: 20px 29px;
      text-align: center;
    }

    .cta-content h2 {
      font-size: 40px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 15px;
      font-family: 'Playfair Display', serif;
    }

    .cta-content p {
      font-size: 16px;
      color: #666;
      margin-bottom: 30px;
      max-width: 600px;
      margin-left: auto;
      margin-right: auto;
      line-height: 1.6;
    }

    .cta-buttons {
      display: flex;
      gap: 20px;
      justify-content: center;
      flex-wrap: wrap;
    }

    .cta-btn {
      padding: 14px 35px;
      border-radius: 8px;
      font-weight: 600;
      font-size: 14px;
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      gap: 10px;
      transition: all 0.3s ease;
      border: 2px solid transparent;
    }

    .cta-btn.primary {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
    }

    .cta-btn.primary:hover {
      transform: translateY(-3px);
      box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
    }

    .cta-btn.secondary {
      background: white;
      color: #667eea;
      border-color: #667eea;
    }

    .cta-btn.secondary:hover {
      background: #667eea;
      color: white;
    }

    /* Responsive Design */
    @media (max-width: 1200px) {
      .why-choose-section {
        padding: 20px 0;
      }

      .section-header {
        margin-bottom: 50px;
      }

      .section-header h2 {
        font-size: 36px;
      }

      .why-choose-grid {
        gap: 25px;
      }

      .why-choose-card {
        padding: 35px 25px;
      }

      .stats-grid {
        gap: 30px;
      }

      .stat-number {
        font-size: 42px;
      }

      .cta-wrapper {
        padding: 50px 30px;
      }

      .cta-content h2 {
        font-size: 36px;
      }
    }

    @media (max-width: 992px) {
      .why-choose-section {
        padding: 50px 0;
      }

      .section-header h2 {
        font-size: 32px;
      }

      .section-header p {
        font-size: 15px;
      }

      .why-choose-grid {
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 20px;
      }

      .why-choose-card {
        padding: 30px 20px;
      }

      .why-choose-icon {
        width: 60px;
        height: 60px;
        font-size: 28px;
      }

      .why-choose-card h3 {
        font-size: 18px;
      }

      .why-choose-card p {
        font-size: 13px;
      }

      .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 20px;
      }

      .stat-item {
        padding: 25px 15px;
      }

      .stat-number {
        font-size: 36px;
      }

      .stat-label {
        font-size: 14px;
      }

      .cta-wrapper {
        padding: 40px 25px;
      }

      .cta-content h2 {
        font-size: 30px;
      }

      .cta-content p {
        font-size: 15px;
        margin-bottom: 25px;
      }

      .cta-buttons {
        gap: 15px;
      }

      .cta-btn {
        padding: 12px 30px;
        font-size: 13px;
      }
    }

    @media (max-width: 768px) {
      .why-choose-section {
        padding: 40px 0;
      }

      .section-header {
        margin-bottom: 40px;
      }

      .section-header h2 {
        font-size: 28px;
      }

      .section-header p {
        font-size: 14px;
      }

      .section-tag {
        font-size: 11px;
        padding: 6px 15px;
      }

      .why-choose-grid {
        grid-template-columns: 1fr;
        gap: 15px;
      }

      .why-choose-card {
        padding: 25px 20px;
      }

      .why-choose-icon {
        width: 55px;
        height: 55px;
        font-size: 26px;
        margin-bottom: 15px;
      }

      .why-choose-card h3 {
        font-size: 16px;
        margin-bottom: 10px;
      }

      .why-choose-card p {
        font-size: 12px;
      }

      .stats-showcase-section {
        padding: 50px 0;
      }

      .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 15px;
      }

      .stat-item {
        padding: 20px 10px;
      }

      .stat-number {
        font-size: 32px;
      }

      .stat-label {
        font-size: 13px;
      }

      .cta-section {
        padding: 50px 0;
      }

      .cta-wrapper {
        padding: 35px 20px;
      }

      .cta-content h2 {
        font-size: 26px;
      }

      .cta-content p {
        font-size: 14px;
        margin-bottom: 20px;
      }

      .cta-buttons {
        flex-direction: column;
        gap: 12px;
      }

      .cta-btn {
        width: 100%;
        justify-content: center;
        padding: 12px 20px;
        font-size: 12px;
      }
    }

    @media (max-width: 576px) {
      .why-choose-section {
        padding: 30px 0;
      }

      .section-header {
        margin-bottom: 30px;
      }

      .section-header h2 {
        font-size: 24px;
      }

      .section-header p {
        font-size: 13px;
      }

      .why-choose-card {
        padding: 20px 15px;
      }

      .why-choose-icon {
        width: 50px;
        height: 50px;
        font-size: 24px;
        margin-bottom: 12px;
      }

      .why-choose-card h3 {
        font-size: 15px;
      }

      .why-choose-card p {
        font-size: 11px;
      }

      .stats-showcase-section {
        padding: 40px 0;
      }

      .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 12px;
      }

      .stat-item {
        padding: 15px 8px;
      }

      .stat-number {
        font-size: 28px;
      }

      .stat-label {
        font-size: 11px;
      }

      .cta-section {
        padding: 35px 0;
      }

      .cta-wrapper {
        padding: 25px 15px;
      }

      .cta-content h2 {
        font-size: 22px;
      }

      .cta-content p {
        font-size: 12px;
        margin-bottom: 15px;
      }

      .cta-buttons {
        gap: 10px;
      }

      .cta-btn {
        padding: 10px 18px;
        font-size: 11px;
      }

      .cta-btn i {
        font-size: 12px;
      }
    }
  </style>

  <!--==============================
Properties Area - Dynamic with Slider
==============================-->
  <section class="property-section">
  <div class="container">

    <!-- TITLE -->
    <div class="property-section-header text-center">
      <small class="section-tag">Properties</small>
      <h2>Discover Premium Living Spaces</h2>
      <p>Explore luxury apartments, smart villas, and investment-ready commercial properties</p>
    </div>

    <!-- PROPERTY SLIDER -->
    <div class="property-slider-wrapper">
      <div class="property-slider" id="propertySlider">
        <?php if (!empty($featured_properties)): ?>
          <?php foreach ($featured_properties as $property): ?>
            <div class="property-card-slider" 
                 data-type="<?php echo htmlspecialchars($property['type'] ?? ''); ?>"
                 data-location="<?php echo htmlspecialchars($property['city'] ?? ''); ?>">
              <img src="<?php echo htmlspecialchars($property['image_url'] ?? 'assets/img/properties/default.jpg'); ?>" 
                   alt="<?php echo htmlspecialchars($property['title'] ?? ''); ?>" 
                   class="property-slider-img">
              <div class="property-slider-content">
                <h4 class="property-slider-title"><?php echo htmlspecialchars(substr($property['title'] ?? 'Property', 0, 20)); ?>...</h4>
                <!-- <p class="property-slider-price">$<?php echo number_format($property['price'] ?? 0); ?></p>
                <div class="property-slider-meta">
                  <span><i class="fas fa-expand"></i> <?php echo $property['area'] ?? 'N/A'; ?> Sqft</span>
                  <span><i class="fas fa-bed"></i> <?php echo $property['bedrooms'] ?? '0'; ?> Bed</span>
                  <span><i class="fas fa-map-marker-alt"></i> <?php echo htmlspecialchars($property['city'] ?? 'N/A'); ?></span>
                </div> -->
                <a href="properties-details.php?id=<?php echo $property['id']; ?>" class="property-slider-btn">View Details</a>
              </div>
            </div>
          <?php endforeach; ?>
        <?php else: ?>
          <div style="padding: 40px; text-align: center; color: #999;">No properties available</div>
        <?php endif; ?>
      </div>
    </div>

  </div>

</section>
  <!--==============================
Service Area - Dynamic with Slider
==============================-->
  <section class="service-section">
  <div class="container">

    <!-- TITLE -->
    <div class="service-section-header text-center">
      <small class="section-tag">Our Services</small>
      <h2>Explore Our Services</h2>
      <p>Professional real estate services tailored to your needs</p>
    </div>

    <!-- SERVICE SLIDER -->
    <div class="service-slider-wrapper">
      <div class="service-slider" id="serviceSlider">
        <?php if (!empty($featured_services)): ?>
          <?php foreach ($featured_services as $service): ?>
            <div class="service-card-slider">
              <div class="service-slider-icon-wrapper">
                <?php if (!empty($service['icon'])): ?>
                  <i class="<?php echo htmlspecialchars($service['icon']); ?>"></i>
                <?php else: ?>
                  <i class="fas fa-briefcase"></i>
                <?php endif; ?>
              </div>
              <div class="service-slider-content">
                <h4 class="service-slider-title"><?php echo htmlspecialchars($service['title'] ?? 'Service'); ?></h4>
                <p class="service-slider-desc"><?php echo htmlspecialchars($service['short_description'] ?? $service['full_description'] ?? 'Service description'); ?></p>
                <a href="service-details.php?id=<?php echo $service['id']; ?>" class="service-slider-btn">
                  Learn More <i class="fas fa-arrow-right"></i>
                </a>
              </div>
            </div>
          <?php endforeach; ?>
        <?php else: ?>
          <div style="padding: 40px; text-align: center; color: #999;">No services available</div>
        <?php endif; ?>
      </div>
    </div>

  </div>

</section>

  <!--==============================
News Area - Dynamic Blog with Slider
==============================-->
  <section class="blog-section">
  <div class="container">

    <!-- TITLE -->
    <div class="blog-section-header text-center">
      <small class="section-tag">Our  Recent Blog</small>
      <h2>Latest Real Estate Insights</h2>
      <p>Stay updated with market trends, investment tips and property news</p>
    </div>

    <!-- BLOG SLIDER -->
    <div class="blog-slider-wrapper">
      <div class="blog-slider" id="blogSlider">
        <?php if (!empty($featured_blog)): ?>
          <?php foreach ($featured_blog as $blog): ?>
            <a href="blog-details.php?id=<?php echo $blog['id']; ?>" class="blog-card-slider">
              <div class="blog-slider-img-wrapper">
                <img src="<?php echo htmlspecialchars($blog['featured_image'] ?? 'assets/img/blog/default.jpg'); ?>" 
                     alt="<?php echo htmlspecialchars($blog['title'] ?? ''); ?>" 
                     class="blog-slider-img">
                <span class="blog-date-badge-slider">
                  <?php echo date('d M', strtotime($blog['created_at'] ?? date('Y-m-d'))); ?>
                </span>
              </div>
              <div class="blog-slider-content">
                <h4 class="blog-slider-title"><?php echo htmlspecialchars(substr($blog['title'] ?? 'Blog Post', 0, 50)); ?></h4>
                <p class="blog-slider-date"><?php echo date('F j, Y', strtotime($blog['created_at'] ?? date('Y-m-d'))); ?></p>
                <span class="blog-slider-btn">
                  Read More <i class="fas fa-arrow-right"></i>
                </span>
              </div>
            </a>
          <?php endforeach; ?>
        <?php else: ?>
          <div style="padding: 40px; text-align: center; color: #999;">No blog posts available</div>
        <?php endif; ?>
      </div>
    </div>

  </div>

</section>

  <!-- Include Footer -->
  <?php include 'footer.php'; ?>

  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  
  <!-- Initialize Slick Sliders after library is loaded -->
  <script>
    $(document).ready(function(){
      // Initialize Hero Slider with Slick
      $('#heroSlider').slick({
        infinite: true,
        slidesToShow: 1,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 5000,
        speed: 600,
        arrows: true,
        dots: true,
        pauseOnHover: true,
        variableWidth: false,
        fade: false,
        cssEase: 'ease-in-out',
        responsive: [
          {
            breakpoint: 1200,
            settings: {
              arrows: true,
              dots: true
            }
          },
          {
            breakpoint: 992,
            settings: {
              arrows: true,
              dots: true
            }
          },
          {
            breakpoint: 768,
            settings: {
              arrows: true,
              dots: true
            }
          },
          {
            breakpoint: 576,
            settings: {
              arrows: true,
              dots: true
            }
          }
        ]
      });
      
      // Initialize Property Slider
      $('#propertySlider').slick({
        infinite: true,
        slidesToShow: 3,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 3000,
        speed: 500,
        arrows: true,
        dots: true,
        pauseOnHover: true,
        variableWidth: false,
        responsive: [
          {
            breakpoint: 1201,
            settings: {
              slidesToShow: 2,
              slidesToScroll: 1
            }
          },
          {
            breakpoint: 769,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1
            }
          }
        ]
      });

      // Initialize Service Slider
      $('#serviceSlider').slick({
        infinite: true,
        slidesToShow: 3,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 3000,
        speed: 500,
        arrows: true,
        dots: true,
        pauseOnHover: true,
        variableWidth: false,
        responsive: [
          {
            breakpoint: 1201,
            settings: {
              slidesToShow: 2,
              slidesToScroll: 1
            }
          },
          {
            breakpoint: 993,
            settings: {
              slidesToShow: 2,
              slidesToScroll: 1
            }
          },
          {
            breakpoint: 769,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1
            }
          }
        ]
      });

      // Initialize Blog Slider
      $('#blogSlider').slick({
        infinite: true,
        slidesToShow: 3,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 3000,
        speed: 500,
        arrows: true,
        dots: true,
        pauseOnHover: true,
        variableWidth: false,
        responsive: [
          {
            breakpoint: 1201,
            settings: {
              slidesToShow: 2,
              slidesToScroll: 1
            }
          },
          {
            breakpoint: 769,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1
            }
          }
        ]
      });
    });
  </script>

  <script src="assets/js/main.js"></script>
</body>

</html>
