<?php
require_once 'config.php';

// Check if user already logged in
if ($is_logged_in) {
    header("Location: dashboards/customer-dashboard.php");
    exit();
}

// Check for error from process-login.php
$error = $_GET['error'] ?? '';
$success = $_GET['success'] ?? '';

?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Login - Real Estate</title>
  <meta name="author" content="vecuro">
  <meta name="description" content="Zemaraim HTML Template">
  <meta name="keywords" content="Zemaraim HTML Template">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <style>
    .login-section {
      min-height: 100vh;
      display: flex;
      align-items: center;
      background: #f8f9fa;
      padding: 40px 20px;
    }

    .login-container {
      width: 100%;
      max-width: 1000px;
      margin: 0 auto;
    }

    .login-grid {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 40px;
      align-items: center;
      background: white;
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
    }

    .login-image {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      padding: 60px 40px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      min-height: 809px;
      color: white;
      text-align: center;
    }

    .login-image-content h2 {
      font-size: 32px;
      font-weight: 700;
      margin-bottom: 20px;
      font-family: 'Playfair Display', serif;
    }

    .login-image-content p {
      font-size: 16px;
      line-height: 1.6;
      margin-bottom: 30px;
      opacity: 0.9;
    }

    .feature-list {
      list-style: none;
      padding: 0;
      text-align: left;
      display: inline-block;
    }

    .feature-list li {
      margin-bottom: 15px;
      font-size: 14px;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .feature-list i {
      font-size: 16px;
    }

    .login-form {
      padding: 50px 40px;
    }

    .login-header {
      margin-bottom: 30px;
    }

    .login-header h1 {
      font-size: 28px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 8px;
      font-family: 'Playfair Display', serif;
    }

    .login-header p {
      color: #999;
      font-size: 14px;
    }

    .back-link {
      display: inline-block;
      margin-bottom: 20px;
      color: #667eea;
      text-decoration: none;
      font-size: 13px;
      transition: color 0.3s ease;
    }

    .back-link:hover {
      color: #764ba2;
    }

    .back-link i {
      margin-right: 5px;
    }

    .form-group {
      margin-bottom: 20px;
    }

    .form-group label {
      display: block;
      margin-bottom: 8px;
      color: #1a1a1a;
      font-weight: 600;
      font-size: 14px;
    }

    .form-group input,
    .form-group select {
      width: 100%;
      padding: 12px 15px;
      border: 1px solid #e0e0e0;
      border-radius: 5px;
      font-size: 14px;
      transition: all 0.3s ease;
      font-family: 'Poppins', sans-serif;
    }

    .form-group input:focus,
    .form-group select:focus {
      outline: none;
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .remember-forgot {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 25px;
      font-size: 13px;
      flex-wrap: wrap;
      gap: 10px;
    }

    .remember-forgot label {
      margin: 0;
      font-weight: 500;
      color: #666;
      display: flex;
      align-items: center;
    }

    .remember-forgot input[type="checkbox"] {
      margin-right: 5px;
      cursor: pointer;
    }

    .remember-forgot a {
      color: #667eea;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .remember-forgot a:hover {
      color: #764ba2;
    }

    .login-btn {
      width: 100%;
      padding: 12px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      border-radius: 5px;
      font-weight: 600;
      font-size: 14px;
      cursor: pointer;
      transition: all 0.3s ease;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      font-family: 'Poppins', sans-serif;
    }

    .login-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
    }

    .login-btn:active {
      transform: translateY(0);
    }

    .auth-divider {
      text-align: center;
      margin: 20px 0;
      position: relative;
    }

    .auth-divider::before {
      content: '';
      position: absolute;
      top: 50%;
      left: 0;
      right: 0;
      height: 1px;
      background: #e0e0e0;
    }

    .auth-divider span {
      background: white;
      padding: 0 10px;
      color: #999;
      position: relative;
      font-size: 12px;
    }

    .social-login {
      display: flex;
      gap: 12px;
      margin-bottom: 20px;
    }

    .social-btn {
      flex: 1;
      padding: 10px;
      border: 1px solid #e0e0e0;
      border-radius: 5px;
      text-decoration: none;
      color: #666;
      text-align: center;
      transition: all 0.3s ease;
      font-size: 13px;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 6px;
    }

    .social-btn:hover {
      border-color: #667eea;
      color: #667eea;
    }

    .social-btn i {
      font-size: 14px;
    }

    .auth-footer {
      text-align: center;
      color: #666;
      font-size: 14px;
      margin-top: 20px;
    }

    .auth-footer a {
      color: #667eea;
      text-decoration: none;
      font-weight: 600;
      transition: color 0.3s ease;
    }

    .auth-footer a:hover {
      color: #764ba2;
    }

    .alert {
      padding: 12px 15px;
      border-radius: 5px;
      margin-bottom: 20px;
      font-size: 14px;
    }

    .alert-danger {
      background: rgba(255, 71, 87, 0.1);
      color: #ff4757;
      border: 1px solid rgba(255, 71, 87, 0.2);
    }

    .alert-success {
      background: rgba(46, 213, 115, 0.1);
      color: #2ed573;
      border: 1px solid rgba(46, 213, 115, 0.2);
    }

    @media (max-width: 992px) {
      .login-grid {
        grid-template-columns: 1fr;
        gap: 0;
      }

      .login-image {
        min-height: auto;
        padding: 40px 30px;
      }

      .login-image-content h2 {
        font-size: 24px;
      }

      .login-form {
        padding: 40px 30px;
      }

      .login-header h1 {
        font-size: 24px;
      }
    }

    @media (max-width: 768px) {
      .login-section {
        padding: 20px 15px;
      }

      .login-grid {
        border-radius: 8px;
      }

      .login-image {
        padding: 30px 25px;
      }

      .login-image-content h2 {
        font-size: 22px;
      }

      .login-image-content p {
        font-size: 14px;
      }

      .login-form {
        padding: 30px 25px;
      }

      .login-header h1 {
        font-size: 22px;
      }

      .form-group input,
      .form-group select {
        padding: 10px 12px;
        font-size: 13px;
      }

      .remember-forgot {
        flex-direction: column;
        align-items: flex-start;
      }

      .social-login {
        gap: 10px;
      }

      .social-btn {
        font-size: 12px;
      }
    }

    @media (max-width: 480px) {
      .login-section {
        padding: 15px;
      }

      .login-image {
        display: none;
      }

      .login-form {
        padding: 20px 15px;
      }

      .login-header h1 {
        font-size: 20px;
      }

      .form-group input,
      .form-group select {
        padding: 10px;
        font-size: 12px;
      }

      .login-btn {
        padding: 10px;
        font-size: 12px;
      }

      .social-login {
        gap: 8px;
        margin-bottom: 15px;
      }

      .social-btn {
        font-size: 11px;
        padding: 8px;
      }

      .social-btn i {
        font-size: 12px;
      }
    }
  </style>
</head>

<body>
<!--header-->
 <?php include 'header.php'; ?>
  
  <section class="login-section">
    <div class="login-container">
      <div class="login-grid">
        
        <div class="login-image">
          <div class="login-image-content">
            <h2>Welcome to Zemaraim</h2>
            <p>Your Premium Real Estate Platform</p>
            <ul class="feature-list">
              <li><i class="fas fa-check-circle"></i> Find your dream property</li>
              <li><i class="fas fa-check-circle"></i> Connect with agents & brokers</li>
              <li><i class="fas fa-check-circle"></i> Manage listings & inquiries</li>
              <li><i class="fas fa-check-circle"></i> Secure transactions</li>
            </ul>
          </div>
        </div>

        <div class="login-form">
          <a href="index.php" class="back-link">
            <i class="fas fa-arrow-left"></i> Back to Home
          </a>

          <div class="login-header">
            <h1>Customer Login</h1>
            <p>Access your account</p>
          </div>

          <?php if ($success): ?>
            <div class="alert alert-success"><i class="fas fa-check-circle"></i> <?php echo htmlspecialchars($success); ?></div>
          <?php endif; ?>

          <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
          <?php endif; ?>

          <form method="POST" action="process-login.php">

            <div class="social-login">
              <a href="#" class="social-btn" onclick="alert('Social login coming soon'); return false;">
                <i class="fab fa-google"></i> Google
              </a>
              <a href="#" class="social-btn" onclick="alert('Social login coming soon'); return false;">
                <i class="fab fa-facebook-f"></i> Facebook
              </a>
            </div>

            <div class="auth-divider">
              <span>Or login with email</span>
            </div>

            <div class="form-group">
              <label for="email">Email Address</label>
              <input type="email" id="email" name="email" placeholder="Enter your email" required>
            </div>

            <div class="form-group">
              <label for="password">Password</label>
              <input type="password" id="password" name="password" placeholder="Enter your password" required>
            </div>

            <div class="remember-forgot">
              <label>
                <input type="checkbox" name="remember"> Remember me
              </label>
              <a href="forgot-password.php">Forgot Password?</a>
            </div>

            <button type="submit" class="login-btn">Sign In</button>
          </form>

          <div class="auth-footer">
            Don't have an account? <a href="register.php">Register here</a>
          </div>
        </div>

      </div>
    </div>
  </section>

  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <script src="assets/js/main.js"></script>
</body>

</html>
<?php include 'footer.php'; ?>