<?php
require_once 'config.php';

// Sample image URLs for different property types
$images = [
    'house' => [
        'https://images.unsplash.com/photo-1570129477492-45a003537e1f?w=400&h=300&fit=crop',
        'https://images.unsplash.com/photo-1512621776951-a57141f2eefd?w=400&h=300&fit=crop',
        'https://images.unsplash.com/photo-1568605114967-8130f3a36994?w=400&h=300&fit=crop',
    ],
    'apartment' => [
        'https://images.unsplash.com/photo-1502672260266-1c1ef2d93688?w=400&h=300&fit=crop',
        'https://images.unsplash.com/photo-1545324418-cc51a28b6662?w=400&h=300&fit=crop',
        'https://images.unsplash.com/photo-1522708323590-d24dbb6b0267?w=400&h=300&fit=crop',
    ],
    'condo' => [
        'https://images.unsplash.com/photo-1493857671505-72967e2e2760?w=400&h=300&fit=crop',
        'https://images.unsplash.com/photo-1512217687669-46e7d9f41c88?w=400&h=300&fit=crop',
    ],
    'villa' => [
        'https://images.unsplash.com/photo-1600585152220-90363fe7e115?w=400&h=300&fit=crop',
        'https://images.unsplash.com/photo-1576678927484-cc099b694e3e?w=400&h=300&fit=crop',
    ]
];

// Get all properties
$result = $mysqli->query("SELECT id, type FROM properties WHERE image_url IS NULL OR image_url = ''");
if ($result && $result->num_rows > 0) {
    $count = 0;
    while ($row = $result->fetch_assoc()) {
        $type = strtolower($row['type']) ?: 'house';
        $imageList = $images[$type] ?? $images['house'];
        $randomImage = $imageList[array_rand($imageList)];
        
        $stmt = $mysqli->prepare("UPDATE properties SET image_url = ? WHERE id = ?");
        $stmt->bind_param("si", $randomImage, $row['id']);
        $stmt->execute();
        $stmt->close();
        $count++;
    }
    echo json_encode([
        'success' => true,
        'message' => "Updated $count properties with images",
        'properties_updated' => $count
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'No properties to update'
    ]);
}

$mysqli->close();
?>
