<?php
require_once 'config.php';

$sample_services = [
    [
        'title' => 'Property Buying',
        'description' => 'Professional guidance in finding and purchasing your perfect property. We help with market analysis, negotiation, and documentation.',
        'icon' => 'fas fa-home',
        'price' => 5000,
        'status' => 'active'
    ],
    [
        'title' => 'Property Selling',
        'description' => 'Complete property selling assistance including valuation, marketing, buyer matching, and closing support.',
        'icon' => 'fas fa-handshake',
        'price' => 7500,
        'status' => 'active'
    ],
    [
        'title' => 'Rental Management',
        'description' => 'Full-service rental property management including tenant screening, rent collection, and maintenance coordination.',
        'icon' => 'fas fa-building',
        'price' => 3000,
        'status' => 'active'
    ],
    [
        'title' => 'Investment Consulting',
        'description' => 'Expert advice on real estate investment opportunities, portfolio diversification, and wealth building strategies.',
        'icon' => 'fas fa-chart-line',
        'price' => 10000,
        'status' => 'active'
    ],
    [
        'title' => 'Property Valuation',
        'description' => 'Professional appraisal and valuation services for insurance, taxation, and transaction purposes.',
        'icon' => 'fas fa-calculator',
        'price' => 2000,
        'status' => 'active'
    ],
    [
        'title' => 'Legal Documentation',
        'description' => 'Complete legal documentation support for property transactions including contracts and deed transfers.',
        'icon' => 'fas fa-file-contract',
        'price' => 1500,
        'status' => 'active'
    ],
    [
        'title' => 'Interior Design',
        'description' => 'Professional interior design services to enhance your property value and aesthetic appeal.',
        'icon' => 'fas fa-palette',
        'price' => 8000,
        'status' => 'active'
    ],
    [
        'title' => 'Property Inspection',
        'description' => 'Comprehensive property inspection and report including structural assessment and recommendations.',
        'icon' => 'fas fa-magnifying-glass',
        'price' => 1000,
        'status' => 'active'
    ]
];

echo json_encode([
    'timestamp' => date('Y-m-d H:i:s'),
    'action' => 'Populating sample services...'
]);

$count = 0;
$errors = [];

foreach ($sample_services as $service) {
    $stmt = $mysqli->prepare("INSERT INTO services (title, description, icon, price, status) VALUES (?, ?, ?, ?, ?)");
    
    if (!$stmt) {
        $errors[] = "Prepare failed: " . $mysqli->error;
        continue;
    }
    
    $stmt->bind_param('sssds', 
        $service['title'],
        $service['description'],
        $service['icon'],
        $service['price'],
        $service['status']
    );
    
    if ($stmt->execute()) {
        $count++;
    } else {
        $errors[] = "Failed to insert: " . $service['title'] . " - " . $stmt->error;
    }
    
    $stmt->close();
}

// Get current count
$total = $mysqli->query("SELECT COUNT(*) as c FROM services")->fetch_assoc()['c'];

echo json_encode([
    'success' => true,
    'timestamp' => date('Y-m-d H:i:s'),
    'inserted' => $count,
    'total_services' => $total,
    'errors' => $errors
], JSON_PRETTY_PRINT);

$mysqli->close();
?>
