<?php
require_once 'config.php';

// Get properties directly from DB (same way admin dashboard gets them)
$query = "SELECT id, title, type, price, address, city, bedrooms, bathrooms, status, image_url FROM properties ORDER BY created_at DESC LIMIT 5";
$result = $mysqli->query($query);
$admin_properties = [];
while ($row = $result->fetch_assoc()) {
    $admin_properties[] = $row;
}

// Count total
$total_result = $mysqli->query("SELECT COUNT(*) as c FROM properties");
$total = $total_result->fetch_assoc()['c'];

// Get active only (like properties.php)
$active_query = "SELECT id, title, type, price, address, city, bedrooms, bathrooms, status, image_url FROM properties WHERE status = 'active' ORDER BY created_at DESC LIMIT 5";
$active_result = $mysqli->query($active_query);
$active_properties = [];
while ($row = $active_result->fetch_assoc()) {
    $active_properties[] = $row;
}

$active_count = $mysqli->query("SELECT COUNT(*) as c FROM properties WHERE status = 'active'")->fetch_assoc()['c'];
?>
<!DOCTYPE html>
<html>
<head>
    <title>Properties Comparison</title>
    <style>
        body { font-family: Arial; background: #f5f5f5; padding: 20px; }
        .container { max-width: 1400px; margin: 0 auto; }
        .section { background: white; padding: 20px; margin: 20px 0; border-radius: 5px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1 { color: #333; }
        h2 { color: #667eea; border-bottom: 2px solid #667eea; padding-bottom: 10px; }
        .stats { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin-bottom: 20px; }
        .stat { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 5px; text-align: center; }
        .stat-number { font-size: 32px; font-weight: bold; }
        .stat-label { font-size: 12px; opacity: 0.9; }
        .grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px; }
        .card { border: 1px solid #ddd; border-radius: 5px; overflow: hidden; }
        .card-image { width: 100%; height: 200px; background: #eee; display: flex; align-items: center; justify-content: center; }
        .card-image img { width: 100%; height: 100%; object-fit: cover; }
        .card-content { padding: 15px; }
        .card-title { font-weight: bold; font-size: 16px; margin-bottom: 10px; }
        .card-meta { font-size: 13px; color: #666; margin: 5px 0; }
        .status { display: inline-block; padding: 3px 8px; border-radius: 3px; font-size: 11px; font-weight: bold; }
        .status-active { background: #d4edda; color: #155724; }
        .status-inactive { background: #f8d7da; color: #721c24; }
        .comparison { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        @media (max-width: 1200px) {
            .comparison { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>📊 Properties Data Comparison & Status</h1>
        
        <div class="stats">
            <div class="stat">
                <div class="stat-number"><?php echo $total; ?></div>
                <div class="stat-label">Total Properties</div>
            </div>
            <div class="stat">
                <div class="stat-number"><?php echo $active_count; ?></div>
                <div class="stat-label">Active Properties</div>
            </div>
            <div class="stat">
                <div class="stat-number"><?php 
                $img_count = $mysqli->query("SELECT COUNT(*) as c FROM properties WHERE image_url IS NOT NULL AND image_url != ''")->fetch_assoc()['c'];
                echo $img_count; 
                ?></div>
                <div class="stat-label">With Images</div>
            </div>
            <div class="stat">
                <div class="stat-number"><?php echo count($admin_properties); ?></div>
                <div class="stat-label">Sample Size</div>
            </div>
        </div>

        <div class="comparison">
            <div class="section">
                <h2>📋 All Properties (Admin View)</h2>
                <p style="color: #666; font-size: 13px;">These are properties displayed in admin dashboard (all statuses)</p>
                <div class="grid">
                    <?php foreach ($admin_properties as $prop): ?>
                        <div class="card">
                            <div class="card-image">
                                <?php if ($prop['image_url']): ?>
                                    <img src="<?php echo htmlspecialchars($prop['image_url']); ?>" alt="<?php echo htmlspecialchars($prop['title']); ?>" onerror="this.src='https://via.placeholder.com/400x300?text=Image+Error'">
                                <?php else: ?>
                                    <div style="text-align: center; color: #999;">
                                        <span>No Image</span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="card-content">
                                <div class="card-title"><?php echo htmlspecialchars($prop['title']); ?></div>
                                <div class="card-meta">📍 <?php echo htmlspecialchars($prop['city']); ?></div>
                                <div class="card-meta">💰 $<?php echo number_format($prop['price']); ?></div>
                                <div class="card-meta">🛏️ <?php echo $prop['bedrooms']; ?> Beds | 🚿 <?php echo $prop['bathrooms']; ?> Baths</div>
                                <div style="margin-top: 10px;">
                                    <span class="status status-<?php echo $prop['status']; ?>"><?php echo strtoupper($prop['status']); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="section">
                <h2>🟢 Active Properties (Customer View)</h2>
                <p style="color: #666; font-size: 13px;">These are properties shown on properties.php (only active)</p>
                <div class="grid">
                    <?php foreach ($active_properties as $prop): ?>
                        <div class="card">
                            <div class="card-image">
                                <?php if ($prop['image_url']): ?>
                                    <img src="<?php echo htmlspecialchars($prop['image_url']); ?>" alt="<?php echo htmlspecialchars($prop['title']); ?>" onerror="this.src='https://via.placeholder.com/400x300?text=Image+Error'">
                                <?php else: ?>
                                    <div style="text-align: center; color: #999;">
                                        <span>No Image</span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="card-content">
                                <div class="card-title"><?php echo htmlspecialchars($prop['title']); ?></div>
                                <div class="card-meta">📍 <?php echo htmlspecialchars($prop['city']); ?></div>
                                <div class="card-meta">💰 $<?php echo number_format($prop['price']); ?></div>
                                <div class="card-meta">🛏️ <?php echo $prop['bedrooms']; ?> Beds | 🚿 <?php echo $prop['bathrooms']; ?> Baths</div>
                                <div style="margin-top: 10px;">
                                    <span class="status status-<?php echo $prop['status']; ?>"><?php echo strtoupper($prop['status']); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <div class="section">
            <h2>✅ Integration Status</h2>
            <p><strong>✓ Database Connected:</strong> Yes</p>
            <p><strong>✓ Total Records:</strong> <?php echo $total; ?></p>
            <p><strong>✓ Active Records:</strong> <?php echo $active_count; ?></p>
            <p><strong>✓ Images Status:</strong> <?php echo $img_count > 0 ? "✓ Images populated" : "⚠ No images yet"; ?></p>
            <p><strong>✓ API Endpoints:</strong> Functional</p>
            <p><strong>Next Step:</strong> 
                <?php if ($total == 0): ?>
                    🟡 Add sample properties
                <?php elseif ($img_count == 0): ?>
                    🟡 Run populate-images.php to add images
                <?php else: ?>
                    ✅ Everything ready! Go to admin-dashboard.php?section=properties
                <?php endif; ?>
            </p>
        </div>
    </div>
</body>
</html>
