<?php
require_once 'config.php';

// Check if email is provided and OTP was verified
$email = $_GET['email'] ?? '';
$isVerified = $_SESSION['otp_verified'] ?? false;

if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL) || !$isVerified) {
    header("Location: forgot-password.php");
    exit();
}

$error = $_GET['error'] ?? '';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Reset Password - Real Estate</title>
  <meta name="author" content="vecuro">
  <meta name="description" content="Zemaraim HTML Template">
  <meta name="keywords" content="Zemaraim HTML Template">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <style>
    .password-reset-section {
      min-height: 100vh;
      display: flex;
      align-items: center;
      background: #f8f9fa;
      padding: 40px 20px;
    }

    .password-reset-container {
      width: 100%;
      max-width: 1000px;
      margin: 0 auto;
    }

    .password-reset-grid {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 40px;
      align-items: center;
      background: white;
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
    }

    .reset-image {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      padding: 60px 40px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      min-height: 809px;
      color: white;
      text-align: center;
    }

    .reset-image-content h2 {
      font-size: 32px;
      font-weight: 700;
      margin-bottom: 20px;
      font-family: 'Playfair Display', serif;
    }

    .reset-image-content p {
      font-size: 16px;
      line-height: 1.6;
      margin-bottom: 30px;
      opacity: 0.9;
    }

    .reset-icon {
      font-size: 60px;
      margin-bottom: 20px;
      opacity: 0.8;
    }

    .security-features {
      list-style: none;
      padding: 0;
      text-align: left;
      display: inline-block;
    }

    .security-features li {
      margin-bottom: 15px;
      font-size: 14px;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .security-features i {
      font-size: 16px;
    }

    .reset-form {
      padding: 50px 40px;
    }

    .reset-header {
      margin-bottom: 30px;
    }

    .reset-header h1 {
      font-size: 28px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 8px;
      font-family: 'Playfair Display', serif;
    }

    .reset-header p {
      color: #999;
      font-size: 14px;
    }

    .form-group {
      margin-bottom: 20px;
    }

    .form-group label {
      display: block;
      margin-bottom: 8px;
      color: #1a1a1a;
      font-weight: 600;
      font-size: 14px;
    }

    .password-input-wrapper {
      position: relative;
    }

    .form-group input {
      width: 100%;
      padding: 12px 15px;
      padding-right: 40px;
      border: 1px solid #e0e0e0;
      border-radius: 5px;
      font-size: 14px;
      transition: all 0.3s ease;
      font-family: 'Poppins', sans-serif;
    }

    .form-group input:focus {
      outline: none;
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .toggle-password {
      position: absolute;
      right: 12px;
      top: 50%;
      transform: translateY(-50%);
      cursor: pointer;
      color: #999;
      background: none;
      border: none;
      font-size: 16px;
      padding: 5px;
    }

    .toggle-password:hover {
      color: #667eea;
    }

    .password-strength {
      margin-top: 8px;
      font-size: 12px;
    }

    .strength-bar {
      width: 100%;
      height: 4px;
      background: #e0e0e0;
      border-radius: 2px;
      overflow: hidden;
      margin-bottom: 8px;
    }

    .strength-bar-fill {
      height: 100%;
      width: 0;
      border-radius: 2px;
      transition: all 0.3s ease;
    }

    .strength-text {
      color: #999;
    }

    .strength-text.weak {
      color: #ff6b6b;
    }

    .strength-text.medium {
      color: #ffa502;
    }

    .strength-text.strong {
      color: #2ed573;
    }

    .strength-bar-fill.weak {
      background: #ff6b6b;
      width: 33%;
    }

    .strength-bar-fill.medium {
      background: #ffa502;
      width: 66%;
    }

    .strength-bar-fill.strong {
      background: #2ed573;
      width: 100%;
    }

    .password-requirements {
      background: #f8f9fa;
      padding: 15px;
      border-radius: 5px;
      margin-top: 15px;
      border: 1px solid #e0e0e0;
    }

    .requirement {
      font-size: 13px;
      color: #999;
      display: flex;
      align-items: center;
      gap: 8px;
      margin-bottom: 8px;
    }

    .requirement:last-child {
      margin-bottom: 0;
    }

    .requirement.met {
      color: #2ed573;
    }

    .requirement i {
      font-size: 12px;
      width: 16px;
      text-align: center;
    }

    .reset-btn {
      width: 100%;
      padding: 12px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      border-radius: 5px;
      font-weight: 600;
      font-size: 14px;
      cursor: pointer;
      transition: all 0.3s ease;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      font-family: 'Poppins', sans-serif;
      margin-top: 10px;
    }

    .reset-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
    }

    .reset-btn:disabled {
      opacity: 0.6;
      cursor: not-allowed;
      transform: none;
    }

    .alert {
      padding: 12px 15px;
      border-radius: 5px;
      margin-bottom: 20px;
      font-size: 14px;
    }

    .alert-danger {
      background: rgba(255, 71, 87, 0.1);
      color: #ff4757;
      border: 1px solid rgba(255, 71, 87, 0.2);
    }

    .back-link {
      display: inline-block;
      margin-bottom: 20px;
      color: #999;
      text-decoration: none;
      font-size: 13px;
      transition: color 0.3s ease;
    }

    .back-link:hover {
      color: #667eea;
    }

    .back-link i {
      margin-right: 5px;
    }

    @media (max-width: 992px) {
      .password-reset-grid {
        grid-template-columns: 1fr;
        gap: 0;
      }

      .reset-image {
        min-height: auto;
        padding: 40px 30px;
      }

      .reset-image-content h2 {
        font-size: 24px;
      }

      .reset-form {
        padding: 40px 30px;
      }

      .reset-header h1 {
        font-size: 24px;
      }
    }

    @media (max-width: 768px) {
      .password-reset-section {
        padding: 20px 15px;
      }

      .password-reset-grid {
        border-radius: 8px;
      }

      .reset-image {
        padding: 30px 25px;
      }

      .reset-image-content h2 {
        font-size: 22px;
      }

      .reset-image-content p {
        font-size: 14px;
      }

      .reset-form {
        padding: 30px 25px;
      }

      .reset-header h1 {
        font-size: 22px;
      }

      .form-group input {
        padding: 10px 12px;
        font-size: 13px;
      }

      .password-requirements {
        padding: 12px;
        font-size: 12px;
      }

      .requirement {
        margin-bottom: 6px;
      }
    }

    @media (max-width: 480px) {
      .password-reset-section {
        padding: 15px;
      }

      .reset-image {
        display: none;
      }

      .reset-form {
        padding: 20px 15px;
      }

      .reset-header h1 {
        font-size: 20px;
      }

      .form-group input {
        padding: 10px;
        font-size: 12px;
      }

      .reset-btn {
        padding: 10px;
        font-size: 12px;
      }

      .reset-icon {
        font-size: 40px;
      }

      .password-requirements {
        padding: 10px;
      }

      .requirement {
        font-size: 11px;
      }
    }
  </style>
</head>

<body>
  <!-- header -->
  <?php include 'header.php'; ?>
  
  <section class="password-reset-section">
    <div class="password-reset-container">
      <div class="password-reset-grid">
        
        <div class="reset-image">
          <div class="reset-image-content">
            <div class="reset-icon">🔑</div>
            <h2>Create New Password</h2>
            <p>Secure Your Account</p>
            <ul class="security-features">
              <li><i class="fas fa-shield-alt"></i> Strong password protection</li>
              <li><i class="fas fa-lock"></i> Encrypted data transmission</li>
              <li><i class="fas fa-check-circle"></i> Instant access restoration</li>
              <li><i class="fas fa-user-check"></i> Your security is our priority</li>
            </ul>
          </div>
        </div>

        <div class="reset-form">
          <a href="login.php" class="back-link">
            <i class="fas fa-arrow-left"></i> Back to Login
          </a>

          <div class="reset-header">
            <h1>Set New Password</h1>
            <p>Create a strong password to secure your account</p>
          </div>

          <?php if ($error): ?>
            <div class="alert alert-danger">
              <i class="fas fa-exclamation-circle"></i> <?php echo htmlspecialchars($error); ?>
            </div>
          <?php endif; ?>

          <form method="POST" action="process-reset-password.php" id="resetPasswordForm">
            <input type="hidden" name="email" value="<?php echo htmlspecialchars($email); ?>">

            <div class="form-group">
              <label for="password">New Password</label>
              <div class="password-input-wrapper">
                <input 
                  type="password" 
                  id="password" 
                  name="password" 
                  placeholder="Enter new password"
                  required
                  autocomplete="new-password"
                >
                <button type="button" class="toggle-password" data-target="password">
                  <i class="fas fa-eye"></i>
                </button>
              </div>
              <div class="password-strength">
                <div class="strength-bar">
                  <div class="strength-bar-fill" id="strengthBar"></div>
                </div>
                <div class="strength-text" id="strengthText">No password</div>
              </div>
            </div>

            <div class="form-group">
              <label for="confirm_password">Confirm Password</label>
              <div class="password-input-wrapper">
                <input 
                  type="password" 
                  id="confirm_password" 
                  name="confirm_password" 
                  placeholder="Confirm your password"
                  required
                  autocomplete="new-password"
                >
                <button type="button" class="toggle-password" data-target="confirm_password">
                  <i class="fas fa-eye"></i>
                </button>
              </div>
            </div>

            <div class="password-requirements">
              <div class="requirement" id="req-length">
                <i class="fas fa-times-circle" style="color: #ff6b6b;"></i> At least 8 characters
              </div>
              <div class="requirement" id="req-uppercase">
                <i class="fas fa-times-circle" style="color: #ff6b6b;"></i> One uppercase letter (A-Z)
              </div>
              <div class="requirement" id="req-lowercase">
                <i class="fas fa-times-circle" style="color: #ff6b6b;"></i> One lowercase letter (a-z)
              </div>
              <div class="requirement" id="req-number">
                <i class="fas fa-times-circle" style="color: #ff6b6b;"></i> One number (0-9)
              </div>
              <div class="requirement" id="req-match">
                <i class="fas fa-times-circle" style="color: #ff6b6b;"></i> Passwords match
              </div>
            </div>

            <button type="submit" class="reset-btn" id="resetBtn" disabled>
              Reset Password
            </button>
          </form>
        </div>

      </div>
    </div>
  </section>

  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <script src="assets/js/main.js"></script>

  <script>
    const passwordInput = document.getElementById('password');
    const confirmInput = document.getElementById('confirm_password');
    const resetBtn = document.getElementById('resetBtn');
    const toggleButtons = document.querySelectorAll('.toggle-password');
    const strengthBar = document.getElementById('strengthBar');
    const strengthText = document.getElementById('strengthText');

    // Toggle password visibility
    toggleButtons.forEach(btn => {
      btn.addEventListener('click', function(e) {
        e.preventDefault();
        const targetId = this.getAttribute('data-target');
        const input = document.getElementById(targetId);
        const icon = this.querySelector('i');
        
        if (input.type === 'password') {
          input.type = 'text';
          icon.classList.remove('fa-eye');
          icon.classList.add('fa-eye-slash');
        } else {
          input.type = 'password';
          icon.classList.remove('fa-eye-slash');
          icon.classList.add('fa-eye');
        }
      });
    });

    // Password strength checker
    function checkPasswordStrength(password) {
      let strength = 0;
      let feedback = [];

      // Check length
      const lengthReq = document.getElementById('req-length');
      if (password.length >= 8) {
        strength += 25;
        lengthReq.classList.add('met');
        lengthReq.querySelector('i').className = 'fas fa-check-circle';
      } else {
        lengthReq.classList.remove('met');
        lengthReq.querySelector('i').className = 'fas fa-times-circle';
      }

      // Check uppercase
      const uppercaseReq = document.getElementById('req-uppercase');
      if (/[A-Z]/.test(password)) {
        strength += 25;
        uppercaseReq.classList.add('met');
        uppercaseReq.querySelector('i').className = 'fas fa-check-circle';
      } else {
        uppercaseReq.classList.remove('met');
        uppercaseReq.querySelector('i').className = 'fas fa-times-circle';
      }

      // Check lowercase
      const lowercaseReq = document.getElementById('req-lowercase');
      if (/[a-z]/.test(password)) {
        strength += 25;
        lowercaseReq.classList.add('met');
        lowercaseReq.querySelector('i').className = 'fas fa-check-circle';
      } else {
        lowercaseReq.classList.remove('met');
        lowercaseReq.querySelector('i').className = 'fas fa-times-circle';
      }

      // Check number
      const numberReq = document.getElementById('req-number');
      if (/[0-9]/.test(password)) {
        strength += 25;
        numberReq.classList.add('met');
        numberReq.querySelector('i').className = 'fas fa-check-circle';
      } else {
        numberReq.classList.remove('met');
        numberReq.querySelector('i').className = 'fas fa-times-circle';
      }

      // Update strength bar
      if (password.length === 0) {
        strengthBar.className = 'strength-bar-fill';
        strengthBar.style.width = '0';
        strengthText.textContent = 'No password';
        strengthText.className = 'strength-text';
      } else if (strength < 50) {
        strengthBar.className = 'strength-bar-fill weak';
        strengthText.textContent = 'Weak password';
        strengthText.className = 'strength-text weak';
      } else if (strength < 75) {
        strengthBar.className = 'strength-bar-fill medium';
        strengthText.textContent = 'Medium password';
        strengthText.className = 'strength-text medium';
      } else {
        strengthBar.className = 'strength-bar-fill strong';
        strengthText.textContent = 'Strong password';
        strengthText.className = 'strength-text strong';
      }

      return strength >= 75;
    }

    // Check password match
    function checkPasswordMatch() {
      const matchReq = document.getElementById('req-match');
      if (passwordInput.value && confirmInput.value && passwordInput.value === confirmInput.value) {
        matchReq.classList.add('met');
        matchReq.querySelector('i').className = 'fas fa-check-circle';
        return true;
      } else if (passwordInput.value || confirmInput.value) {
        matchReq.classList.remove('met');
        matchReq.querySelector('i').className = 'fas fa-times-circle';
        return false;
      }
      return false;
    }

    // Update validation on input
    passwordInput.addEventListener('input', function() {
      const isStrong = checkPasswordStrength(this.value);
      checkPasswordMatch();
      updateSubmitButton();
    });

    confirmInput.addEventListener('input', function() {
      checkPasswordMatch();
      updateSubmitButton();
    });

    function updateSubmitButton() {
      const isStrongPassword = checkPasswordStrength(passwordInput.value);
      const isMatching = passwordInput.value && confirmInput.value && passwordInput.value === confirmInput.value;
      
      resetBtn.disabled = !(isStrongPassword && isMatching);
    }

    // Form submission
    document.getElementById('resetPasswordForm').addEventListener('submit', function(e) {
      if (!passwordInput.value || !confirmInput.value) {
        e.preventDefault();
        alert('Please fill in all fields');
      } else if (passwordInput.value !== confirmInput.value) {
        e.preventDefault();
        alert('Passwords do not match');
      }
    });
  </script>
</body>

</html>
<?php include 'footer.php'; ?>
