<?php
require_once 'config.php';

// Get service ID from URL
$service_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($service_id <= 0) {
    header('Location: service.php');
    exit;
}

// Get service details
$query = "SELECT * FROM services WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param('i', $service_id);
$stmt->execute();
$result = $stmt->get_result();
$service = $result->fetch_assoc();

if (!$service) {
    header('Location: service.php');
    exit;
}

// Resolve service image path safely for local and external URLs
$service_image_url = 'assets/img/service/sr-d-1-1.jpg';
if (!empty($service['image_url'])) {
    $raw_image_url = trim($service['image_url']);

    if (preg_match('/^https?:\/\//i', $raw_image_url) || strpos($raw_image_url, '//') === 0) {
        $service_image_url = $raw_image_url;
    } else {
        $local_image_path = ltrim(str_replace('\\', '/', $raw_image_url), '/');
        if (file_exists(__DIR__ . '/' . $local_image_path)) {
            $service_image_url = $local_image_path;
        }
    }
}

// Get all services for sidebar
$all_services_query = "SELECT id, title, icon FROM services ORDER BY id ASC";
$all_services_result = $conn->query($all_services_query);
$all_services = [];
while ($row = $all_services_result->fetch_assoc()) {
    $all_services[] = $row;
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title><?php echo htmlspecialchars($service['title']); ?> - Zemaraim</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  
  <style>
    body { background: #f7f7f7; }
    
    /* Breadcrumb */
    .details-breadcrumb { 
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
      padding: 30px 0; 
      color: white;
    }
    .breadcrumb-link { color: white; text-decoration: none; }
    .breadcrumb-link:hover { color: #ddd; }
    .breadcrumb-separator { margin: 0 10px; opacity: 0.7; }
    
    /* Header Section */
    .service-header { 
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 50px 0;
      margin-bottom: 40px;
    }
    .service-header h1 { font-size: 42px; font-weight: 700; margin: 0; }
    .service-header p { font-size: 18px; margin: 10px 0 0 0; opacity: 0.95; }
    
    /* Main Content */
    .service-details-section { padding: 40px 0; }
    .service-content { background: white; padding: 40px; border-radius: 12px; box-shadow: 0 2px 15px rgba(0,0,0,0.08); }
    .service-image { width: 100%; max-height: 400px; object-fit: cover; border-radius: 10px; margin-bottom: 30px; }
    
    .section-title { 
      font-size: 28px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 20px;
      padding-bottom: 10px;
      border-bottom: 3px solid #667eea;
    }
    
    .description-text { 
      color: #555;
      font-size: 16px;
      line-height: 1.8;
      margin-bottom: 30px;
    }
    
    .benefits-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 20px;
      margin-bottom: 40px;
    }
    
    .benefit-item {
      background: #f8f9fa;
      padding: 20px;
      border-radius: 8px;
      border-left: 4px solid #667eea;
      transition: all 0.3s ease;
    }
    
    .benefit-item:hover {
      background: white;
      box-shadow: 0 5px 15px rgba(102,126,234,0.1);
      transform: translateY(-3px);
    }
    
    .benefit-title{
      font-size: 16px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 8px;
    }
    
    /* CTA Section */
    .service-cta {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 30px;
      border-radius: 10px;
      text-align: center;
      margin: 40px 0;
    }
    
    .cta-text { font-size: 18px; margin-bottom: 15px; }
    .cta-btn {
      display: inline-block;
      background: white;
      color: #667eea;
      padding: 12px 30px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: 600;
      transition: all 0.3s ease;
    }
    
    .cta-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0,0,0,0.2);
    }
    
    /* Sidebar */
    .sidebar-widget {
      background: white;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 2px 15px rgba(0,0,0,0.08);
      margin-bottom: 30px;
    }
    
    .sidebar-title {
      font-size: 20px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 20px;
      padding-bottom: 10px;
      border-bottom: 2px solid #667eea;
    }
    
    .related-services-list {
      list-style: none;
      padding: 0;
      margin: 0;
    }
    
    .related-services-list li {
      margin-bottom: 12px;
    }
    
    .related-services-list a {
      display: flex;
      align-items: center;
      gap: 12px;
      padding: 10px 12px;
      background: #f8f9fa;
      border-radius: 6px;
      text-decoration: none;
      color: #666;
      transition: all 0.3s ease;
      border-left: 3px solid transparent;
    }
    
    .related-services-list a:hover {
      background: #f0f4ff;
      color: #667eea;
      border-left-color: #667eea;
    }
    
    .related-services-list i {
      font-size: 16px;
      color: #667eea;
    }
    
    /* Contact Widget */
    .contact-widget {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 25px;
      border-radius: 10px;
      text-align: center;
    }
    
    .contact-icon {
      font-size: 40px;
      margin-bottom: 15px;
    }
    
    .contact-widget h3 {
      margin: 15px 0 10px 0;
    }
    
    .contact-widget p {
      margin: 5px 0;
      font-size: 14px;
      opacity: 0.95;
    }
    
    .contact-link {
      display: inline-block;
      background: white;
      color: #667eea;
      padding: 10px 20px;
      border-radius: 5px;
      text-decoration: none;
      font-weight: 600;
      margin-top: 10px;
      transition: all 0.3s ease;
    }
    
    .contact-link:hover {
      transform: scale(1.05);
    }
    
    /* Responsive Design */
    @media (max-width: 992px) {
      .service-header h1 { font-size: 36px; }
      .service-header p { font-size: 16px; }
      .service-header { padding: 40px 0; }
      .section-title { font-size: 24px; }
      .service-image { max-height: 300px; }
      .description-text { font-size: 15px; }
    }
    
    @media (max-width: 768px) {
      .service-details-section { padding: 30px 0; }
      .service-content { padding: 25px; }
      .service-header h1 { font-size: 28px; }
      .service-header p { font-size: 15px; }
      .service-header { padding: 30px 0; margin-bottom: 30px; }
      .section-title { font-size: 22px; margin-bottom: 15px; }
      .description-text { font-size: 14px; margin-bottom: 20px; }
      .benefits-grid { gap: 15px; }
      .benefit-item { padding: 15px; }
      .benefit-title { font-size: 15px; }
      .service-cta { padding: 25px; margin: 30px 0; }
      .cta-text { font-size: 16px; }
      .details-breadcrumb { padding: 20px 0; }
    }
    
    @media (max-width: 480px) {
      .service-details-section { padding: 20px 0; }
      .service-content { padding: 15px; margin-bottom: 20px; }
      .service-header h1 { font-size: 22px; }
      .service-header p { font-size: 14px; }
      .service-header { padding: 20px 0; margin-bottom: 20px; }
      .section-title { font-size: 20px; margin-bottom: 12px; }
      .description-text { font-size: 13px; line-height: 1.6; margin-bottom: 15px; }
      .benefits-grid { grid-template-columns: 1fr; gap: 12px; }
      .benefit-item { padding: 12px; border-left-width: 3px; }
      .benefit-title { font-size: 14px; margin-bottom: 6px; }
      .service-cta { padding: 20px; margin: 20px 0; }
      .cta-text { font-size: 14px; margin-bottom: 12px; }
      .cta-btn { padding: 10px 20px; font-size: 13px; }
      .sidebar-widget { padding: 20px; }
      .sidebar-title { font-size: 18px; margin-bottom: 15px; }
      .related-services-list a { gap: 10px; padding: 8px 10px; font-size: 13px; }
      .contact-widget { padding: 20px; }
      .contact-icon { font-size: 36px; margin-bottom: 10px; }
      .contact-widget h3 { font-size: 16px; margin: 10px 0 8px 0; }
      .contact-widget p { font-size: 13px; }
      .contact-link { padding: 8px 15px; font-size: 12px; margin-top: 8px; }
      .details-breadcrumb { padding: 15px 0; font-size: 12px; }
    }
  </style>
</head>

<body>
  <?php include 'header.php'; ?>
  
  <!-- Breadcrumb -->
  <div class="details-breadcrumb">
    <div class="container">
      <a href="index.php" class="breadcrumb-link"><i class="fas fa-home"></i> Home</a>
      <span class="breadcrumb-separator">/</span>
      <a href="service.php" class="breadcrumb-link">Services</a>
      <span class="breadcrumb-separator">/</span>
      <span><?php echo htmlspecialchars($service['title']); ?></span>
    </div>
  </div>

  <!-- Service Header -->
  <div class="service-header">
    <div class="container">
      <h1><?php echo htmlspecialchars($service['title']); ?></h1>
      <p><?php echo htmlspecialchars($service['short_description']); ?></p>
    </div>
  </div>

  <!-- Service Details -->
  <section class="service-details-section">
    <div class="container">
      <div class="row g-4">
        <!-- Main Content -->
        <div class="col-lg-8">
          <!-- Service Content -->
          <div class="service-content">
            <!-- Service Image -->
            <img src="<?php echo htmlspecialchars($service_image_url); ?>" alt="<?php echo htmlspecialchars($service['title']); ?>" class="service-image">

            <!-- Full Description -->
            <h2 class="section-title"><i class="fas fa-align-left"></i> About This Service</h2>
            <p class="description-text">
              <?php echo htmlspecialchars($service['full_description']); ?>
            </p>

            <!-- Benefits Section -->
            <?php if (!empty($service['benefits'])): ?>
              <h2 class="section-title"><i class="fas fa-check-circle"></i> Key Benefits</h2>
              <div class="benefits-grid">
                <?php 
                  $benefits = explode(',', $service['benefits']);
                  foreach ($benefits as $benefit): 
                    $benefit = trim($benefit);
                ?>
                  <div class="benefit-item">
                    <div class="benefit-title"><i class="fas fa-star" style="color: #667eea; margin-right: 8px;"></i><?php echo htmlspecialchars($benefit); ?></div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php endif; ?>

            <!-- CTA Section -->
            <div class="service-cta">
              <div class="cta-text">Ready to get started with this service?</div>
              <a href="contact.php" class="cta-btn">
                <i class="fas fa-envelope"></i> Contact Us Today
              </a>
            </div>
          </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
          <!-- Related Services -->
          <div class="sidebar-widget">
            <h3 class="sidebar-title"><i class="fas fa-list"></i> Our Services</h3>
            <ul class="related-services-list">
              <?php foreach ($all_services as $service_item): ?>
                <li>
                  <a href="service-details.php?id=<?php echo $service_item['id']; ?>">
                    <i class="<?php echo !empty($service_item['icon']) ? htmlspecialchars($service_item['icon']) : 'fas fa-star'; ?>"></i>
                    <?php echo htmlspecialchars($service_item['title']); ?>
                  </a>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>

          <!-- Contact Widget -->
          <div class="contact-widget">
            <div class="contact-icon">
              <i class="fas fa-headset"></i>
            </div>
            <h3>Need Help?</h3>
            <p>Our expert team is here to assist you</p>
            <p><strong>Call:</strong> +1 (555) 123-4567</p>
            <p><strong>Email:</strong> info@Zemaraim.com</p>
            <a href="contact.php" class="contact-link">Send Message</a>
          </div>
        </div>
      </div>
    </div>
  </section>

  <?php include 'footer.php'; ?>
  
  <!-- Scroll To Top -->
  <a href="#" class="scrollToTop scroll-btn"><i class="far fa-arrow-up"></i></a>
  
  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <script src="assets/js/main.js"></script>
</body>

</html>
