<?php
require_once 'config.php';

// Get all services from database
$query = "SELECT * FROM services ORDER BY created_at DESC";
$result = $mysqli->query($query);
$services = [];
while ($row = $result->fetch_assoc()) {
    $services[] = $row;
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Our Services - Zemaraim Real Estate</title>
  <meta name="author" content="Zemaraim">
  <meta name="description" content="Real estate services including property buying, selling, rental management, and investment consulting">
  <meta name="keywords" content="real estate services, property management, investment consulting">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  
  <style>
    body { background: #f7f7f7; }
    
    /* Breadcrumb */
    .services-breadcrumb { 
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
      padding: 40px 0; 
      color: white; 
    }
    .breadcrumb-link { color: white; text-decoration: none; transition: all 0.3s ease; }
    .breadcrumb-link:hover { color: #ddd; }
    .breadcrumb-separator { margin: 0 10px; opacity: 0.7; }
    
    /* Services Section */
    .services-section { padding: 60px 0; }
    .services-header { text-align: center; margin-bottom: 50px; }
    .services-header h1 { font-size: 42px; font-weight: 700; color: #1a1a1a; margin-bottom: 15px; }
    .services-header p { font-size: 18px; color: #666; max-width: 600px; margin: 0 auto; }
    .section-underline { width: 60px; height: 4px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); margin: 20px auto; border-radius: 2px; }
    
    /* Services Grid */
    .services-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 30px; }
    
    /* Service Card */
    .service-card { 
      background: white; 
      border-radius: 12px; 
      overflow: hidden; 
      box-shadow: 0 2px 15px rgba(0,0,0,0.08); 
      transition: all 0.3s ease;
      cursor: pointer;
      text-decoration: none;
      color: inherit;
      display: flex;
      flex-direction: column;
      height: 100%;
    }
    .service-card:hover { 
      transform: translateY(-8px);
      box-shadow: 0 10px 30px rgba(102,126,234,0.2);
    }
    
    .service-icon-section { 
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      padding: 40px 20px;
      text-align: center;
      color: white;
    }
    .service-icon { 
      font-size: 48px;
      margin-bottom: 15px;
      display: inline-block;
    }
    
    .service-content { 
      padding: 25px;
      flex-grow: 1;
      display: flex;
      flex-direction: column;
    }
    .service-title { 
      font-size: 20px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 12px;
    }
    .service-description { 
      color: #666;
      font-size: 14px;
      line-height: 1.6;
      margin-bottom: 20px;
      flex-grow: 1;
    }
    
    .service-link { 
      display: inline-flex;
      align-items: center;
      gap: 8px;
      color: #667eea;
      font-weight: 600;
      font-size: 14px;
      transition: all 0.3s ease;
    }
    .service-card:hover .service-link {
      gap: 12px;
      color: #764ba2;
    }
    
    .service-link i { 
      transition: transform 0.3s ease;
    }
    .service-card:hover .service-link i {
      transform: translateX(3px);
    }
    
    /* Responsive Design */
    @media (max-width: 992px) {
      .services-header h1 { font-size: 36px; }
      .services-header p { font-size: 16px; }
      .services-grid { gap: 25px; }
      .service-icon-section { padding: 35px 20px; }
      .service-icon { font-size: 42px; }
    }
    
    @media (max-width: 768px) {
      .services-section { padding: 40px 0; }
      .services-header { margin-bottom: 40px; }
      .services-header h1 { font-size: 28px; }
      .services-header p { font-size: 15px; }
      .services-grid { grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 20px; }
      .service-icon-section { padding: 30px 15px; }
      .service-icon { font-size: 38px; }
      .service-content { padding: 20px; }
      .service-title { font-size: 18px; }
      .service-description { font-size: 13px; }
      .services-breadcrumb { padding: 30px 0; }
    }
    
    @media (max-width: 480px) {
      .services-section { padding: 30px 0; }
      .services-header { margin-bottom: 30px; }
      .services-header h1 { font-size: 24px; }
      .services-header p { font-size: 14px; }
      .services-grid { grid-template-columns: 1fr; gap: 15px; }
      .service-icon-section { padding: 25px 15px; }
      .service-icon { font-size: 36px; margin-bottom: 10px; }
      .service-content { padding: 15px; }
      .service-title { font-size: 16px; margin-bottom: 10px; }
      .service-description { font-size: 12px; margin-bottom: 15px; }
      .services-breadcrumb { padding: 20px 0; font-size: 13px; }
    }
  </style>
</head>

<body>
  <?php include 'header.php'; ?>
  
  <!-- Breadcrumb -->
  <div class="services-breadcrumb">
    <div class="container">
      <a href="index.php" class="breadcrumb-link"><i class="fas fa-home"></i> Home</a>
      <span class="breadcrumb-separator">/</span>
      <span>Services</span>
    </div>
  </div>

  <!-- Services Section -->
  <section class="services-section">
    <div class="container">
      <!-- Header -->
      <div class="services-header">
        <h1>Our Real Estate Services</h1>
        <div class="section-underline"></div>
        <p>Comprehensive property solutions for buying, selling, investing, and property management</p>
      </div>

      <!-- Services Grid -->
      <div class="services-grid">
        <?php foreach ($services as $service): ?>
          <a href="service-details.php?id=<?php echo $service['id']; ?>" class="service-card">
            <div class="service-icon-section">
              <div class="service-icon">
                <i class="<?php echo !empty($service['icon']) ? htmlspecialchars($service['icon']) : 'fas fa-star'; ?>"></i>
              </div>
            </div>
            <div class="service-content">
              <h3 class="service-title"><?php echo htmlspecialchars($service['title']); ?></h3>
              <p class="service-description"><?php echo htmlspecialchars($service['short_description']); ?></p>
              <span class="service-link">
                Learn More <i class="fas fa-arrow-right"></i>
              </span>
            </div>
          </a>
        <?php endforeach; ?>
      </div>
    </div>
  </section>

  <?php include 'footer.php'; ?>
  
  <!-- Scroll To Top -->
  <a href="#" class="scrollToTop scroll-btn"><i class="far fa-arrow-up"></i></a>
  
  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <script src="assets/js/main.js"></script>
</body>

</html>
