<?php
require_once 'config.php';

// Create hero_sliders table
$sql = "CREATE TABLE IF NOT EXISTS `hero_sliders` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `tag` VARCHAR(100) NOT NULL,
  `title` VARCHAR(255) NOT NULL,
  `subtitle` TEXT NOT NULL,
  `button1_text` VARCHAR(100),
  `button1_url` VARCHAR(255),
  `button2_text` VARCHAR(100),
  `button2_url` VARCHAR(255),
  `image_url` VARCHAR(255),
  `stat1_icon` VARCHAR(100),
  `stat1_text` VARCHAR(255),
  `stat2_icon` VARCHAR(100),
  `stat2_text` VARCHAR(255),
  `display_order` INT DEFAULT 0,
  `status` ENUM('active', 'inactive') DEFAULT 'active',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($sql) === TRUE) {
    echo "✓ hero_sliders table created successfully<br>";
} else {
    echo "✗ Error creating table: " . $conn->error . "<br>";
}

// Insert sample data
$insert_sql = "INSERT INTO `hero_sliders` 
(`tag`, `title`, `subtitle`, `button1_text`, `button1_url`, `button2_text`, `button2_url`, `image_url`, 
`stat1_icon`, `stat1_text`, `stat2_icon`, `stat2_text`, `display_order`, `status`) VALUES
(
  'Premium Properties',
  'Find Your Dream Apartment Today',
  'Discover luxury apartments in prime locations with verified documents and expert guidance for secure investments.',
  'Explore Properties',
  'properties.html',
  'Contact Us',
  'contact.php',
  'assets/img/hero/Copilot_20260219_135217.png',
  'fas fa-check-circle',
  '22K+ Properties Listed',
  'fas fa-users',
  '140K+ Happy Customers',
  1,
  'active'
),
(
  'Luxury Living',
  'Private Villas With Smart Security',
  'Own your exclusive villa in peaceful neighborhoods with premium amenities and a strong investment value.',
  'View Villas',
  'properties.html',
  'Schedule Visit',
  'contact.php',
  'assets/img/hero/hero2.png',
  'fas fa-home',
  '500+ Ongoing Projects',
  'fas fa-chart-line',
  'High ROI Guaranteed',
  2,
  'active'
),
(
  'Business Opportunities',
  'Business Ready Commercial Hubs',
  'Prime commercial spaces in strategic locations perfect for retail, offices, and enterprise growth.',
  'Explore Commercial',
  'properties.html',
  'Get Quote',
  'contact.php',
  'assets/img/hero/hero3.png',
  'fas fa-building',
  '15K+ Properties Sold',
  'fas fa-handshake',
  '90% Client Satisfaction',
  3,
  'active'
),
(
  'Smart Investments',
  'Real Estate Investment Made Easy',
  'Access verified properties with legal documentation, loan assistance, and expert investment consultation.',
  'Start Investing',
  'properties.html',
  'Consult Expert',
  'contact.php',
  'assets/img/hero/hero4.png',
  'fas fa-shield-alt',
  '100% Legal Verified',
  'fas fa-map-marker-alt',
  'Prime Locations Only',
  4,
  'active'
)";

if ($conn->query($insert_sql) === TRUE) {
    echo "✓ Sample hero slider data inserted successfully<br>";
    echo "✓ You can now edit hero sliders from the database<br>";
} else {
    echo "✗ Error inserting data: " . $conn->error . "<br>";
}

// Display current hero sliders
$result = $conn->query("SELECT * FROM hero_sliders WHERE status = 'active' ORDER BY display_order ASC");

if ($result && $result->num_rows > 0) {
    echo "<hr>";
    echo "<h2>Current Hero Sliders:</h2>";
    while($row = $result->fetch_assoc()) {
        echo "<div style='border: 1px solid #ddd; padding: 15px; margin: 10px 0; border-radius: 5px;'>";
        echo "<h3>" . htmlspecialchars($row['title']) . "</h3>";
        echo "<p><strong>Tag:</strong> " . htmlspecialchars($row['tag']) . "</p>";
        echo "<p><strong>Order:</strong> " . $row['display_order'] . "</p>";
        echo "<p><strong>Image URL:</strong> " . htmlspecialchars($row['image_url']) . "</p>";
        echo "<small>ID: " . $row['id'] . " | Created: " . $row['created_at'] . "</small>";
        echo "</div>";
    }
}

echo "<hr>";
echo "<h2>💡 How to Edit Hero Sliders:</h2>";
echo "<p>The hero sliders are now stored in the <code>hero_sliders</code> table in your database.</p>";
echo "<p>You can edit them by:</p>";
echo "<ol>";
echo "<li><strong>Database Management:</strong> Use PhpMyAdmin to directly edit the hero_sliders table</li>";
echo "<li><strong>Admin Panel:</strong> Create an admin page to manage hero sliders (optional)</li>";
echo "<li><strong>SQL Queries:</strong> Use SQL UPDATE statements to modify slides</li>";
echo "</ol>";
echo "<p><strong>Example SQL Update:</strong></p>";
echo "<pre>";
echo "UPDATE hero_sliders SET title='New Title' WHERE id=1;";
echo "</pre>";
echo "<p><strong>To add a new slide:</strong></p>";
echo "<pre>";
echo "INSERT INTO hero_sliders (tag, title, subtitle, button1_text, button1_url, button2_text, button2_url, image_url, stat1_icon, stat1_text, stat2_icon, stat2_text, display_order, status) VALUES (...)";
echo "</pre>";
echo "<p><strong>To deactivate a slide:</strong></p>";
echo "<pre>";
echo "UPDATE hero_sliders SET status='inactive' WHERE id=2;";
echo "</pre>";
?>
<style>
  body {
    font-family: Arial, sans-serif;
    max-width: 900px;
    margin: 40px auto;
    padding: 20px;
    background-color: #f5f5f5;
  }
  h2 {
    color: #667eea;
  }
  pre {
    background-color: #f0f0f0;
    padding: 10px;
    border-radius: 5px;
    overflow-x: auto;
  }
</style>
