<?php
session_start();
require_once 'config.php';

// Set test session for admin
$_SESSION['user_id'] = 1;
$_SESSION['user_role'] = 'admin';
$_SESSION['user_name'] = 'Test Admin';

// Redirect to test API
header('Content-Type: application/json');

echo "=== Testing APIs ===\n\n";

// Test get-properties API
echo "Testing get-properties.php...\n";
$properties_response = @file_get_contents('http://localhost/Zemaraim/api/get-properties.php?page=1&per_page=5', false, stream_context_create(['http' => ['cookie' => 'PHPSESSID=' . session_id()]]));
echo "Properties Response: " . (json_decode($properties_response) ? "SUCCESS" : "FAILED") . "\n";
if ($properties_response) {
    $props = json_decode($properties_response, true);
    if (isset($props['properties'])) {
        echo "Found " . count($props['properties']) . " properties\n";
        if (count($props['properties']) > 0) {
            echo "First property image_url: " . ($props['properties'][0]['image_url'] ?? 'NULL') . "\n";
        }
    }
}

echo "\nTesting get-services.php...\n";
$services_response = @file_get_contents('http://localhost/Zemaraim/api/get-services.php?page=1&per_page=5', false, stream_context_create(['http' => ['cookie' => 'PHPSESSID=' . session_id()]]));
echo "Services Response: " . (json_decode($services_response) ? "SUCCESS" : "FAILED") . "\n";
if ($services_response) {
    $servs = json_decode($services_response, true);
    if (isset($servs['services'])) {
        echo "Found " . count($servs['services']) . " services\n";
    }
}

echo "\n\n=== Database Status ===\n";
$props_count = $mysqli->query("SELECT COUNT(*) as c FROM properties")->fetch_assoc()['c'];
echo "Total properties in DB: $props_count\n";

$props_with_images = $mysqli->query("SELECT COUNT(*) as c FROM properties WHERE image_url IS NOT NULL AND image_url != ''")->fetch_assoc()['c'];
echo "Properties with images: $props_with_images\n";

$services_count = $mysqli->query("SELECT COUNT(*) as c FROM services")->fetch_assoc()['c'];
echo "Total services in DB: $services_count\n";
?>
