<?php
echo "=== Zemaraim Authentication System Test ===\n\n";

// Test 1: Check if config.php exists
echo "1. Checking config.php...\n";
if (file_exists('config.php')) {
    echo "   ✓ config.php exists\n";
} else {
    echo "   ✗ config.php not found\n";
}

// Test 2: Check if dashboards directory exists
echo "\n2. Checking dashboards directory...\n";
if (is_dir('dashboards')) {
    echo "   ✓ dashboards directory exists\n";
    $files = scandir('dashboards');
    foreach ($files as $file) {
        if ($file !== '.' && $file !== '..') {
            echo "   - $file\n";
        }
    }
} else {
    echo "   ✗ dashboards directory not found\n";
}

// Test 3: Check login.php
echo "\n3. Checking login.php...\n";
if (file_exists('login.php')) {
    echo "   ✓ login.php exists\n";
} else {
    echo "   ✗ login.php not found\n";
}

// Test 4: Check logout.php
echo "\n4. Checking logout.php...\n";
if (file_exists('logout.php')) {
    echo "   ✓ logout.php exists\n";
    $lines = file_get_contents('logout.php');
    if (strpos($lines, 'session_destroy') !== false) {
        echo "   ✓ logout.php contains session_destroy()\n";
    } else {
        echo "   ✗ logout.php missing session_destroy()\n";
    }
} else {
    echo "   ✗ logout.php not found\n";
}

// Test 5: Check all dashboards
echo "\n5. Checking all dashboard files...\n";
$dashboards = ['customer-dashboard.php', 'agent-dashboard.php', 'staff-dashboard.php', 'admin-dashboard.php', 'broker-dashboard.php'];
foreach ($dashboards as $dashboard) {
    $path = "dashboards/$dashboard";
    if (file_exists($path)) {
        echo "   ✓ $dashboard exists\n";
        $content = file_get_contents($path);
        if (strpos($content, 'session_start()') !== false) {
            echo "     ✓ Contains session_start()\n";
        }
        if (strpos($content, '$_SESSION') !== false) {
            echo "     ✓ Validates session\n";
        }
    } else {
        echo "   ✗ $dashboard not found\n";
    }
}

// Test 6: Check register.php
echo "\n6. Checking register.php...\n";
if (file_exists('register.php')) {
    echo "   ✓ register.php exists\n";
} else {
    echo "   ✗ register.php not found\n";
}

echo "\n=== Test Complete ===\n";
?>
