<?php
require_once 'config.php';

// Check properties count
$result = $conn->query('SELECT COUNT(*) as count FROM properties');
$row = $result->fetch_assoc();
$count = $row['count'];

echo "Sample properties in database: $count\n";

if ($count == 0) {
    echo "No properties found. Sample data may not have been created.\n";
} else {
    echo "✓ Sample data created successfully!\n";
    
    // List all properties
    $properties = $conn->query('SELECT id, title, price, city FROM properties LIMIT 5');
    echo "\nFirst 5 properties:\n";
    while ($prop = $properties->fetch_assoc()) {
        echo "- [{$prop['id']}] {$prop['title']} - \${$prop['price']} in {$prop['city']}\n";
    }
}
?>
