<?php
require_once 'config.php';

// Check if email is provided
$email = $_GET['email'] ?? '';
if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    header("Location: forgot-password.php");
    exit();
}

$error = $_GET['error'] ?? '';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title>Verify OTP - Real Estate</title>
  <meta name="author" content="vecuro">
  <meta name="description" content="Zemaraim HTML Template">
  <meta name="keywords" content="Zemaraim HTML Template">
  <meta name="robots" content="INDEX,FOLLOW">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="icon" type="image/png" href="assets/img/favicons/favicon.png">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/fontawesome.min.css">
  <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
  <link rel="stylesheet" href="assets/css/slick.min.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <style>
    .otp-section {
      min-height: 100vh;
      display: flex;
      align-items: center;
      background: #f8f9fa;
      padding: 40px 20px;
    }

    .otp-container {
      width: 100%;
      max-width: 1000px;
      margin: 0 auto;
    }

    .otp-grid {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 40px;
      align-items: center;
      background: white;
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
    }

    .otp-image {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      padding: 60px 40px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      min-height: 809px;
      color: white;
      text-align: center;
    }

    .otp-image-content h2 {
      font-size: 32px;
      font-weight: 700;
      margin-bottom: 20px;
      font-family: 'Playfair Display', serif;
    }

    .otp-image-content p {
      font-size: 16px;
      line-height: 1.6;
      margin-bottom: 30px;
      opacity: 0.9;
    }

    .otp-icon {
      font-size: 60px;
      margin-bottom: 20px;
      opacity: 0.8;
    }

    .otp-features {
      list-style: none;
      padding: 0;
      text-align: left;
      display: inline-block;
    }

    .otp-features li {
      margin-bottom: 15px;
      font-size: 14px;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .otp-features i {
      font-size: 16px;
    }

    .otp-form {
      padding: 50px 40px;
    }

    .otp-header {
      margin-bottom: 30px;
    }

    .otp-header h1 {
      font-size: 28px;
      font-weight: 700;
      color: #1a1a1a;
      margin-bottom: 8px;
      font-family: 'Playfair Display', serif;
    }

    .otp-header p {
      color: #999;
      font-size: 14px;
    }

    .email-display {
      background: #f8f9fa;
      padding: 12px 15px;
      border-radius: 5px;
      margin-bottom: 20px;
      font-size: 13px;
      color: #666;
      border: 1px solid #e0e0e0;
    }

    .email-display strong {
      color: #667eea;
    }

    .form-group {
      margin-bottom: 20px;
    }

    .form-group label {
      display: block;
      margin-bottom: 8px;
      color: #1a1a1a;
      font-weight: 600;
      font-size: 14px;
    }

    .otp-input-group {
      display: flex;
      gap: 10px;
      justify-content: space-between;
    }

    .otp-input {
      width: 100%;
      max-width: 60px;
      padding: 15px 10px;
      border: 2px solid #e0e0e0;
      border-radius: 8px;
      text-align: center;
      font-size: 24px;
      font-weight: 700;
      font-family: 'Courier New', monospace;
      transition: all 0.3s ease;
    }

    .otp-input:focus {
      outline: none;
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .otp-input.filled {
      border-color: #667eea;
      background: rgba(102, 126, 234, 0.05);
    }

    .form-description {
      font-size: 13px;
      color: #999;
      margin-top: 12px;
    }

    .timer {
      display: flex;
      align-items: center;
      gap: 10px;
      font-size: 13px;
      margin-top: 12px;
    }

    .timer-badge {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 3px 8px;
      border-radius: 12px;
      font-size: 12px;
      font-weight: 600;
      min-width: 40px;
      text-align: center;
    }

    .verify-btn {
      width: 100%;
      padding: 12px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      border-radius: 5px;
      font-weight: 600;
      font-size: 14px;
      cursor: pointer;
      transition: all 0.3s ease;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      font-family: 'Poppins', sans-serif;
    }

    .verify-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
    }

    .verify-btn:disabled {
      opacity: 0.6;
      cursor: not-allowed;
      transform: none;
    }

    .resend-section {
      text-align: center;
      margin-top: 20px;
    }

    .resend-link {
      color: #667eea;
      text-decoration: none;
      font-size: 13px;
      font-weight: 600;
      transition: color 0.3s ease;
      cursor: pointer;
    }

    .resend-link:hover:not(.disabled) {
      color: #764ba2;
    }

    .resend-link.disabled {
      color: #ccc;
      cursor: not-allowed;
    }

    .alert {
      padding: 12px 15px;
      border-radius: 5px;
      margin-bottom: 20px;
      font-size: 14px;
    }

    .alert-danger {
      background: rgba(255, 71, 87, 0.1);
      color: #ff4757;
      border: 1px solid rgba(255, 71, 87, 0.2);
    }

    .alert-info {
      background: rgba(52, 152, 219, 0.1);
      color: #3498db;
      border: 1px solid rgba(52, 152, 219, 0.2);
    }

    .back-link {
      display: inline-block;
      margin-bottom: 20px;
      color: #667eea;
      text-decoration: none;
      font-size: 13px;
      transition: color 0.3s ease;
    }

    .back-link:hover {
      color: #764ba2;
    }

    .back-link i {
      margin-right: 5px;
    }

    @media (max-width: 992px) {
      .otp-grid {
        grid-template-columns: 1fr;
        gap: 0;
      }

      .otp-image {
        min-height: auto;
        padding: 40px 30px;
      }

      .otp-image-content h2 {
        font-size: 24px;
      }

      .otp-form {
        padding: 40px 30px;
      }

      .otp-header h1 {
        font-size: 24px;
      }
    }

    @media (max-width: 768px) {
      .otp-section {
        padding: 20px 15px;
      }

      .otp-grid {
        border-radius: 8px;
      }

      .otp-image {
        padding: 30px 25px;
      }

      .otp-image-content h2 {
        font-size: 22px;
      }

      .otp-image-content p {
        font-size: 14px;
      }

      .otp-form {
        padding: 30px 25px;
      }

      .otp-header h1 {
        font-size: 22px;
      }

      .otp-input {
        max-width: 50px;
        padding: 12px 8px;
        font-size: 20px;
      }
    }

    @media (max-width: 480px) {
      .otp-section {
        padding: 15px;
      }

      .otp-image {
        display: none;
      }

      .otp-form {
        padding: 20px 15px;
      }

      .otp-header h1 {
        font-size: 20px;
      }

      .otp-input-group {
        gap: 8px;
      }

      .otp-input {
        max-width: 45px;
        padding: 12px 5px;
        font-size: 18px;
      }

      .verify-btn {
        padding: 10px;
        font-size: 12px;
      }

      .otp-icon {
        font-size: 40px;
      }
    }
  </style>
</head>

<body>
  <!-- header -->
  <?php include 'header.php'; ?>
  
  <section class="otp-section">
    <div class="otp-container">
      <div class="otp-grid">
        
        <div class="otp-image">
          <div class="otp-image-content">
            <div class="otp-icon">✉️</div>
            <h2>Verification Code Sent</h2>
            <p>Check your email inbox</p>
            <ul class="otp-features">
              <li><i class="fas fa-check-circle"></i> Enter the 6-digit code</li>
              <li><i class="fas fa-clock"></i> Code expires in 15 minutes</li>
              <li><i class="fas fa-shield-alt"></i> Keep your account secure</li>
              <li><i class="fas fa-repeat"></i> Resend if not received</li>
            </ul>
          </div>
        </div>

        <div class="otp-form">
          <a href="forgot-password.php" class="back-link">
            <i class="fas fa-arrow-left"></i> Back to Reset
          </a>

          <div class="otp-header">
            <h1>Enter OTP</h1>
            <p>We've sent a 6-digit code to your email</p>
          </div>

          <div class="email-display">
            <i class="fas fa-envelope"></i> Code sent to <strong><?php echo htmlspecialchars($email); ?></strong>
          </div>

          <?php if ($error): ?>
            <div class="alert alert-danger">
              <i class="fas fa-exclamation-circle"></i> <?php echo htmlspecialchars($error); ?>
            </div>
          <?php endif; ?>

          <form method="POST" action="process-verify-otp.php" id="otpForm">
            <input type="hidden" name="email" value="<?php echo htmlspecialchars($email); ?>">
            
            <div class="form-group">
              <label for="otp">Verification Code</label>
              <div class="otp-input-group" id="otpInputGroup">
                <input type="text" class="otp-input" maxlength="1" inputmode="numeric" placeholder="0" required>
                <input type="text" class="otp-input" maxlength="1" inputmode="numeric" placeholder="0" required>
                <input type="text" class="otp-input" maxlength="1" inputmode="numeric" placeholder="0" required>
                <input type="text" class="otp-input" maxlength="1" inputmode="numeric" placeholder="0" required>
                <input type="text" class="otp-input" maxlength="1" inputmode="numeric" placeholder="0" required>
                <input type="text" class="otp-input" maxlength="1" inputmode="numeric" placeholder="0" required>
              </div>
              <input type="hidden" name="otp" id="otpCombined" required>
              <div class="form-description">
                <i class="fas fa-info-circle"></i> Enter all 6 digits
              </div>
            </div>

            <div class="timer">
              <span>Expires in:</span>
              <span class="timer-badge" id="timerBadge">15:00</span>
            </div>

            <button type="submit" class="verify-btn" id="verifyBtn">
              Verify OTP
            </button>
          </form>

          <div class="resend-section">
            <p style="font-size: 13px; color: #999; margin-bottom: 10px;">Didn't receive the code?</p>
            <form method="POST" action="process-resend-otp.php" id="resendForm">
              <input type="hidden" name="email" value="<?php echo htmlspecialchars($email); ?>">
              <button type="submit" class="resend-link" id="resendBtn" disabled>
                Resend in <span id="resendTimer">60</span>s
              </button>
            </form>
          </div>
        </div>

      </div>
    </div>
  </section>

  <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
  <script src="assets/js/bootstrap.min.js"></script>
  <script src="assets/js/slick.min.js"></script>
  <script src="assets/js/jquery.magnific-popup.min.js"></script>
  <script src="assets/js/imagesloaded.pkgd.min.js"></script>
  <script src="assets/js/isotope.pkgd.min.js"></script>
  <script src="assets/js/main.js"></script>

  <script>
    // OTP Input Handling
    const otpInputs = document.querySelectorAll('.otp-input');
    const otpCombined = document.getElementById('otpCombined');
    const otpForm = document.getElementById('otpForm');
    const verifyBtn = document.getElementById('verifyBtn');

    otpInputs.forEach((input, index) => {
      input.addEventListener('input', function(e) {
        // Only allow numbers
        this.value = this.value.replace(/[^0-9]/g, '');
        
        // Move to next input if filled
        if (this.value.length === 1 && index < otpInputs.length - 1) {
          otpInputs[index + 1].focus();
        }
        
        // Update combined OTP
        updateOTP();
        
        // Check if all fields are filled
        const allFilled = Array.from(otpInputs).every(input => input.value.length === 1);
        verifyBtn.disabled = !allFilled;
      });

      // Handle backspace
      input.addEventListener('keydown', function(e) {
        if (e.key === 'Backspace' && this.value.length === 0 && index > 0) {
          otpInputs[index - 1].focus();
        }
      });

      // Handle paste
      input.addEventListener('paste', function(e) {
        e.preventDefault();
        const pastedData = e.clipboardData.getData('text').replace(/[^0-9]/g, '');
        
        pastedData.split('').forEach((digit, i) => {
          if (index + i < otpInputs.length) {
            otpInputs[index + i].value = digit;
          }
        });
        
        updateOTP();
        const allFilled = Array.from(otpInputs).every(input => input.value.length === 1);
        verifyBtn.disabled = !allFilled;
      });
    });

    function updateOTP() {
      const otp = Array.from(otpInputs).map(input => input.value).join('');
      otpCombined.value = otp;
    }

    // OTP Expiry Timer (15 minutes)
    let timeLeft = 15 * 60;
    const timerBadge = document.getElementById('timerBadge');

    setInterval(() => {
      timeLeft--;
      const minutes = Math.floor(timeLeft / 60);
      const seconds = timeLeft % 60;
      timerBadge.textContent = `${minutes}:${seconds.toString().padStart(2, '0')}`;

      if (timeLeft <= 0) {
        verifyBtn.disabled = true;
        verifyBtn.textContent = 'OTP Expired';
        timerBadge.textContent = 'Expired';
      }
    }, 1000);

    // Resend Timer (60 seconds)
    let resendTimeLeft = 60;
    const resendBtn = document.getElementById('resendBtn');
    const resendTimer = document.getElementById('resendTimer');

    setInterval(() => {
      if (resendTimeLeft > 0) {
        resendTimeLeft--;
        resendTimer.textContent = resendTimeLeft;
        resendBtn.disabled = true;
      } else {
        resendBtn.disabled = false;
        resendBtn.textContent = 'Resend Code';
        resendBtn.classList.remove('disabled');
      }
    }, 1000);

    // Form submission
    otpForm.addEventListener('submit', function(e) {
      const otp = Array.from(otpInputs).map(input => input.value).join('');
      if (otp.length !== 6) {
        e.preventDefault();
        alert('Please enter all 6 digits');
      }
    });
  </script>
</body>

</html>
<?php include 'footer.php'; ?>
