<?php
// Debug log viewer
header('Content-Type: text/html; charset=utf-8');

$logFile = dirname(__FILE__) . '/appointment_debug.log';

echo "<style>
body { font-family: 'Courier New', monospace; margin: 20px; background: #1e1e1e; color: #d4d4d4; }
.log-viewer { background: #252526; padding: 20px; border-radius: 5px; border: 1px solid #3e3e42; max-width: 1000px; }
h1 { color: #4ec9b0; }
.log-line { padding: 5px 0; border-bottom: 1px solid #333; }
.log-line.ERROR { color: #f48771; }
.log-line.SUCCESS { color: #6a9955; }
.log-line.DEBUG { color: #9cdcfe; }
.log-line.WARNING { color: #ce9178; }
.button-group { margin: 20px 0; }
.btn { padding: 10px 20px; background: #007acc; color: white; border: none; border-radius: 3px; cursor: pointer; margin-right: 10px; }
.btn:hover { background: #005a9e; }
.btn-danger { background: #d16969; }
.btn-danger:hover { background: #a74747; }
.stats { margin: 20px 0; padding: 15px; background: #2d2d30; border-left: 3px solid #007acc; }
</style>";

echo "<div class='log-viewer'>";
echo "<h1>📋 Appointment Debug Log</h1>";

if (file_exists($logFile)) {
    $logs = file_get_contents($logFile);
    
    if (empty($logs)) {
        echo "<p style='color: #999;'>Log file is empty. Try submitting the form again.</p>";
    } else {
        // Count errors, successes, etc
        $errorCount = substr_count($logs, 'ERROR:');
        $successCount = substr_count($logs, 'SUCCESS:');
        $debugCount = substr_count($logs, 'DEBUG:');
        
        echo "<div class='stats'>";
        echo "🔴 Errors: <strong>$errorCount</strong> | ";
        echo "🟢 Successes: <strong>$successCount</strong> | ";
        echo "🔵 Debug lines: <strong>$debugCount</strong>";
        echo "</div>";
        
        echo "<h3>Recent Logs:</h3>";
        $lines = array_reverse(explode("\n", trim($logs)));
        $displayed = 0;
        
        foreach ($lines as $line) {
            if (empty($line)) continue;
            if ($displayed >= 50) break; // Show last 50 lines
            
            $class = 'log-line';
            if (strpos($line, 'ERROR:') !== false) $class .= ' ERROR';
            elseif (strpos($line, 'SUCCESS:') !== false) $class .= ' SUCCESS';
            elseif (strpos($line, 'DEBUG:') !== false) $class .= ' DEBUG';
            
            echo "<div class='$class'>" . htmlspecialchars($line) . "</div>";
            $displayed++;
        }
    }
    
    echo "<div class='button-group'>";
    echo "<form method='POST' style='display:inline;'>";
    echo "<button type='submit' name='action' value='clear' class='btn btn-danger' onclick=\"return confirm('Clear log file?')\">Clear Log</button>";
    echo "</form>";
    echo "<button class='btn' onclick='location.reload()'>Refresh</button>";
    echo "</div>";
    
    // Handle clear
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
        if ($_POST['action'] === 'clear') {
            file_put_contents($logFile, '');
            echo "<p style='color: #6a9955; margin-top: 20px;'>✓ Log file cleared</p>";
        }
    }
} else {
    echo "<p style='color: #f48771;'>❌ Log file not found at: <code>" . htmlspecialchars($logFile) . "</code></p>";
    echo "<p>Submit the appointment form first to generate logs.</p>";
}

echo "</div>";

echo "<div style='margin-top: 20px; padding: 15px; background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; border-radius: 3px;'>";
echo "<h3>🔍 How to debug:</h3>";
echo "<ol>";
echo "<li>Submit the appointment form</li>";
echo "<li>Look at the recent logs below</li>";
echo "<li>If you see ERROR lines, that's the problem</li>";
echo "<li>Use browser DevTools (F12) Console tab for frontend errors</li>";
echo "</ol>";
echo "</div>";
?>
